/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SourceBranchFailureDialog
extends MessageDialog {
    private Button toggleButton;
    private URIish uri;

    public static void show(Shell parentShell, URIish uri) {
        SourceBranchFailureDialog dialog = new SourceBranchFailureDialog(parentShell, uri);
        dialog.setShellStyle(dialog.getShellStyle() | 0x10000000 | 0x10);
        dialog.open();
    }

    private SourceBranchFailureDialog(Shell parentShell, URIish uri) {
        super(parentShell, UIText.CloneFailureDialog_tile, null, null, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.uri = uri;
    }

    protected void buttonPressed(int buttonId) {
        if (this.toggleButton != null) {
            Activator.getDefault().getPreferenceStore().setValue("CloneWizard_ShowDetailedFailureDialog", !this.toggleButton.getSelection());
        }
        super.buttonPressed(buttonId);
    }

    protected Control createMessageArea(Composite composite) {
        Composite main = new Composite(composite, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        super.createMessageArea(main);
        StyledText text = new StyledText(main, 65600);
        text.setEnabled(false);
        text.setBackground(main.getBackground());
        Object messageText = NLS.bind((String)UIText.CloneFailureDialog_checkList, (Object)this.uri.toString());
        int bullets = 2;
        if (!this.uri.getPath().endsWith(".git")) {
            messageText = (String)messageText + UIText.CloneFailureDialog_checkList_git;
            ++bullets;
        }
        if ("ssh".equals(this.uri.getScheme())) {
            messageText = (String)messageText + UIText.CloneFailureDialog_checkList_ssh;
            ++bullets;
        } else if ("https".equals(this.uri.getScheme())) {
            messageText = (String)messageText + UIText.CloneFailureDialog_checkList_https;
            ++bullets;
        }
        int newLinesCount = ((String)messageText).split("\n").length;
        Bullet bullet = this.createBullet(main);
        text.setText((String)messageText);
        text.setLineBullet(newLinesCount - bullets, bullets, bullet);
        return main;
    }

    private Bullet createBullet(Composite main) {
        StyleRange style = new StyleRange();
        style.metrics = new GlyphMetrics(0, 0, 40);
        style.foreground = main.getDisplay().getSystemColor(2);
        Bullet bullet = new Bullet(style);
        return bullet;
    }

    protected Control createCustomArea(Composite parent) {
        this.toggleButton = new Button(parent, 16416);
        this.toggleButton.setText(UIText.CloneFailureDialog_dontShowAgain);
        return null;
    }
}

