/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.extension;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egf.model.pattern.BasicQuery;
import org.eclipse.egf.model.pattern.InjectedContext;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.model.pattern.SuperCall;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PatternFactory {
    public static final String INIT_METHOD_NAME = "init";
    public static final String HEADER_METHOD_NAME = "header";
    public static final String FOOTER_METHOD_NAME = "footer";
    public static final String PRECONDITION_METHOD_NAME = "preCondition";
    public static final String BODY_METHOD_NAME = "body";

    public static boolean isSpecialMethod(String name) {
        return HEADER_METHOD_NAME.equals(name) || INIT_METHOD_NAME.equals(name) || PRECONDITION_METHOD_NAME.equals(name) || FOOTER_METHOD_NAME.equals(name);
    }

    public void createDebugPatternUC5(PatternLibrary lib) {
        Pattern p1 = this.createPattern(lib, "Pattern UN");
        PatternVariable var1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternVariable();
        var1.setName("myVar");
        var1.setType("String");
        p1.getVariables().add((Object)var1);
        PatternMethod method1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternMethod();
        method1.setName("My_Method_1");
        p1.getMethods().add((Object)method1);
        method1.setPatternFilePath(this.createURI(method1));
    }

    public void createDebugPatternUC4(PatternLibrary lib) {
        Pattern parentPattern = this.createPattern(lib, "Pattern UN");
        Pattern childPattern = this.createPattern(lib, "Pattern DEUX");
        PatternVariable var1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternVariable();
        var1.setName("myVar");
        var1.setType("String");
        parentPattern.getVariables().add((Object)var1);
        PatternInjectedCall patternCall = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternInjectedCall();
        patternCall.setContext((InjectedContext)var1);
        patternCall.setCalled(childPattern);
        childPattern.getVariables().add((Object)var1);
    }

    public void createDebugPatternUC3(PatternLibrary lib) {
        Pattern p1 = this.createPattern(lib, "Pattern Called");
        Pattern p2 = this.createPattern(lib, "Pattern Parent");
        Pattern p3 = this.createPattern(lib, "Pattern Child");
        p1.setSuperPattern(p2);
        PatternParameter param1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternParameter();
        param1.setName("myCalledParam");
        param1.setType("http://www.eclipse.org/emf/2002/Ecore#//EClass");
        param1.setQuery(this.createBasicQuery());
        p1.getParameters().add((Object)param1);
        PatternParameter param2 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternParameter();
        param2.setName("myChildParam");
        param2.setType("http://www.eclipse.org/emf/2002/Ecore#//EClass");
        param2.setQuery(this.createBasicQuery());
        p2.getParameters().add((Object)param2);
        PatternCall patternCall = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternCall();
        patternCall.setCalled(p1);
        patternCall.getParameterMatching().put((Object)param1, (Object)param2);
        p3.getOrchestration().add((Object)patternCall);
    }

    public void createDebugPattern15(PatternLibrary lib) {
        Pattern p1 = this.createPattern(lib, "Pattern GrandParent");
        Pattern p2 = this.createPattern(lib, "Pattern Parent");
        Pattern p3 = this.createPattern(lib, "Pattern Child");
        p2.setSuperPattern(p1);
        p3.setSuperPattern(p2);
        PatternParameter param1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternParameter();
        param1.setName("myGrandParentParam");
        param1.setType("http://www.eclipse.org/emf/2002/Ecore#//EClass");
        param1.setQuery(this.createBasicQuery());
        p1.getParameters().add((Object)param1);
        p2.getOrchestration().clear();
        p3.getOrchestration().clear();
    }

    public void createDebugPattern14(PatternLibrary lib) {
        Pattern p1 = this.createPattern(lib, "Pattern GrandParent");
        Pattern p2 = this.createPattern(lib, "Pattern Parent");
        Pattern p3 = this.createPattern(lib, "Pattern Child");
        p2.setSuperPattern(p1);
        p3.setSuperPattern(p2);
        PatternMethod method1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternMethod();
        method1.setName("test1");
        p1.getMethods().add((Object)method1);
        method1.setPatternFilePath(this.createURI(method1));
        PatternMethod method2 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternMethod();
        method2.setName("test2");
        p1.getMethods().add((Object)method2);
        method2.setPatternFilePath(this.createURI(method2));
        MethodCall methodCall1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createMethodCall();
        methodCall1.setCalled(method1);
        p1.getOrchestration().add((Object)methodCall1);
        MethodCall methodCall2 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createMethodCall();
        methodCall2.setCalled(method2);
        p1.getOrchestration().add((Object)methodCall2);
        method1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternMethod();
        method1.setName("test1");
        p2.getMethods().add((Object)method1);
        method1.setPatternFilePath(this.createURI(method1));
        p2.getOrchestration().clear();
        method1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternMethod();
        method1.setName("test2");
        p3.getMethods().add((Object)method1);
        method1.setPatternFilePath(this.createURI(method1));
        p3.getOrchestration().clear();
    }

    public void createDebugPattern13(PatternLibrary lib) {
        Pattern p1 = this.createPattern(lib, "Pattern UN");
        Pattern p2 = this.createPattern(lib, "Pattern DEUX");
        Pattern p3 = this.createPattern(lib, "Pattern TROIS");
        p2.setSuperPattern(p1);
        p3.setSuperPattern(p1);
        PatternMethod method1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternMethod();
        method1.setName("run1");
        p1.getMethods().add((Object)method1);
        method1.setPatternFilePath(this.createURI(method1));
        MethodCall methodCall1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createMethodCall();
        methodCall1.setCalled(method1);
        p1.getOrchestration().add((Object)methodCall1);
        method1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternMethod();
        method1.setName("run1");
        p2.getMethods().add((Object)method1);
        method1.setPatternFilePath(this.createURI(method1));
        p2.getOrchestration().clear();
        p3.getOrchestration().clear();
    }

    public void createDebugPattern12(PatternLibrary lib) {
        Pattern p1 = this.createPattern(lib, "Pattern UN");
        Pattern p2 = this.createPattern(lib, "Pattern DEUX");
        Pattern p3 = this.createPattern(lib, "Pattern TROIS");
        PatternMethod method1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternMethod();
        method1.setName("run1");
        p1.getMethods().add((Object)method1);
        method1.setPatternFilePath(this.createURI(method1));
        MethodCall methodCall1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createMethodCall();
        methodCall1.setCalled(method1);
        p1.getOrchestration().add((Object)methodCall1);
        p2.setSuperPattern(p1);
        p3.setSuperPattern(p2);
    }

    public void createDebugPattern11(PatternLibrary lib) {
        Pattern p1 = this.createPattern(lib, "Pattern UN");
        Pattern p2 = this.createPattern(lib, "Pattern DEUX");
        Pattern p3 = this.createPattern(lib, "Pattern TROIS");
        PatternLibrary subLib = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternLibrary();
        subLib.setName("subLib");
        lib.getElements().add((Object)subLib);
        Pattern sp1 = this.createPattern(subLib, "Sub UN");
        Pattern sp2 = this.createPattern(subLib, "Sub DEUX");
        Pattern sp3 = this.createPattern(subLib, "Sub TROIS");
        BasicEList rule1 = new BasicEList();
        rule1.add((Object)subLib);
        rule1.add((Object)p1);
        rule1.add((Object)p2);
        lib.getFilters().put((Object)"rule1", (Object)rule1);
        BasicEList srule1 = new BasicEList();
        srule1.add((Object)sp2);
        srule1.add((Object)sp1);
        subLib.getFilters().put((Object)"rule12", (Object)srule1);
    }

    public void createDebugPattern9(PatternLibrary lib) {
        Pattern p1 = this.createPattern(lib, "Pattern UN");
        Pattern p2 = this.createPattern(lib, "Pattern DEUX");
        Pattern p3 = this.createPattern(lib, "Pattern TROIS");
        PatternLibrary subLib = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternLibrary();
        subLib.setName("subLib");
        lib.getElements().add((Object)subLib);
        Pattern sp1 = this.createPattern(subLib, "Sub UN");
        Pattern sp2 = this.createPattern(subLib, "Sub DEUX");
        Pattern sp3 = this.createPattern(subLib, "Sub TROIS");
    }

    public List<Pattern> createDebugPatternUC2(PatternLibrary lib) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        Pattern p1 = this.createPattern(lib, "Pattern UN");
        Pattern p2 = this.createPattern(lib, "Pattern DEUX");
        Pattern p3 = this.createPattern(lib, "Pattern TROIS");
        PatternCall patternCall = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternCall();
        patternCall.setCalled(p2);
        p1.getOrchestration().add((Object)patternCall);
        patternCall = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternCall();
        patternCall.setCalled(p3);
        p2.getOrchestration().add((Object)patternCall);
        result.add(p3);
        result.add(p1);
        result.add(p2);
        return result;
    }

    public List<Pattern> createDebugPattern7(PatternLibrary lib) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        Pattern parentPattern = this.createPattern(lib, "ParentPattern");
        Pattern childPattern = this.createPattern(lib, "ChildPattern");
        PatternVariable var1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternVariable();
        var1.setName("myVar");
        var1.setType("String");
        parentPattern.getVariables().add((Object)var1);
        PatternParameter param1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternParameter();
        param1.setName("myParam");
        param1.setType("http://www.eclipse.org/emf/2002/Ecore#//EClass");
        param1.setQuery(this.createBasicQuery());
        childPattern.getParameters().add((Object)param1);
        PatternInjectedCall iCall = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternInjectedCall();
        iCall.setContext((InjectedContext)var1);
        iCall.setCalled(childPattern);
        parentPattern.getOrchestration().add((Object)iCall);
        result.add(parentPattern);
        result.add(childPattern);
        return result;
    }

    public List<Pattern> createDebugPattern6(PatternLibrary lib) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        Pattern createPattern = this.createPattern(lib, "MyPattern");
        PatternParameter param1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternParameter();
        param1.setName("myParam");
        param1.setType("http://www.eclipse.org/emf/2002/Ecore#//EClass");
        param1.setQuery(this.createBasicQuery());
        createPattern.getParameters().add((Object)param1);
        result.add(createPattern);
        return result;
    }

    private Query createBasicQuery() {
        BasicQuery createBasicQuery = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createBasicQuery();
        createBasicQuery.setExtensionId("org.eclipse.egf.pattern.basic.query");
        return createBasicQuery;
    }

    public Pattern createDebugPattern1(PatternLibrary lib) {
        Pattern createPattern = this.createPattern(lib, "MyPattern");
        return createPattern;
    }

    public List<Pattern> createDebugPattern3(PatternLibrary lib) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        Pattern parent = this.createPattern(lib, "parent");
        Pattern child = this.createPattern(lib, "child");
        PatternCall patternCall = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternCall();
        patternCall.setCalled(child);
        parent.getOrchestration().add((Object)patternCall);
        result.add(parent);
        result.add(child);
        return result;
    }

    public List<Pattern> createDebugPatternUC1(PatternLibrary lib) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        Pattern parent = this.createPattern(lib, "parent");
        Pattern child = this.createPattern(lib, "child");
        PatternParameter param1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternParameter();
        param1.setName("parentP1");
        param1.setType("http://www.eclipse.org/emf/2002/Ecore#//EClass");
        parent.getParameters().add((Object)param1);
        PatternParameter param12 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternParameter();
        param12.setName("parentP2");
        param12.setType("http://www.eclipse.org/emf/2002/Ecore#//EClass");
        parent.getParameters().add((Object)param12);
        PatternParameter param2 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternParameter();
        param2.setName("childP");
        param2.setType("http://www.eclipse.org/emf/2002/Ecore#//EClass");
        child.getParameters().add((Object)param2);
        PatternCall patternCall = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternCall();
        patternCall.getParameterMatching().put((Object)param2, (Object)param12);
        patternCall.setCalled(child);
        parent.getOrchestration().add((Object)patternCall);
        result.add(parent);
        result.add(child);
        return result;
    }

    public List<Pattern> createDebugPattern4(PatternLibrary lib) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        Pattern parent = this.createPattern(lib, "parent");
        PatternParameter param1 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternParameter();
        param1.setName("parentP");
        param1.setType("http://www.eclipse.org/emf/2002/Ecore#//EClass");
        parent.getParameters().add((Object)param1);
        Pattern child = this.createPattern(lib, "child");
        PatternParameter param2 = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternParameter();
        param2.setName("childP");
        param2.setType("http://www.eclipse.org/emf/2002/Ecore#//EClass");
        child.getParameters().add((Object)param2);
        PatternCall patternCall = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternCall();
        patternCall.setCalled(child);
        parent.getOrchestration().add((Object)patternCall);
        result.add(parent);
        result.add(child);
        return result;
    }

    public Pattern createPattern(PatternLibrary lib, String patternName) {
        Pattern pattern = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPattern();
        pattern.setName(patternName);
        if (lib != null) {
            lib.getElements().add((Object)pattern);
        }
        this.addNature(pattern);
        PatternMethod headerMethod = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternMethod();
        pattern.getMethods().add((Object)headerMethod);
        pattern.setHeaderMethod(headerMethod);
        this.initHeader(headerMethod);
        PatternMethod initMethod = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternMethod();
        pattern.getMethods().add((Object)initMethod);
        pattern.setInitMethod(initMethod);
        this.initIinit(initMethod);
        PatternMethod preConditionMethod = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternMethod();
        pattern.getMethods().add((Object)preConditionMethod);
        pattern.setConditionMethod(preConditionMethod);
        this.initPreCondition(preConditionMethod);
        PatternMethod bodyMethod = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternMethod();
        pattern.getMethods().add((Object)bodyMethod);
        this.initBody(bodyMethod);
        PatternMethod footerMethod = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createPatternMethod();
        pattern.getMethods().add((Object)footerMethod);
        pattern.setFooterMethod(footerMethod);
        this.initFooter(footerMethod);
        SuperCall superCall = org.eclipse.egf.model.pattern.PatternFactory.eINSTANCE.createSuperCall();
        pattern.getOrchestration().add((Object)superCall);
        return pattern;
    }

    protected void initFooter(PatternMethod method) {
        method.setName(FOOTER_METHOD_NAME);
        method.setPatternFilePath(this.createURI(method));
        this.initFooterContent(method);
    }

    private void initFooterContent(PatternMethod method) {
    }

    protected void initBody(PatternMethod method) {
        method.setName(BODY_METHOD_NAME);
        method.setPatternFilePath(this.createURI(method));
    }

    protected void initHeader(PatternMethod method) {
        method.setName(HEADER_METHOD_NAME);
        method.setPatternFilePath(this.createURI(method));
    }

    protected void initIinit(PatternMethod method) {
        method.setName(INIT_METHOD_NAME);
        method.setPatternFilePath(this.createURI(method));
    }

    protected void initPreCondition(PatternMethod method) {
        method.setName(PRECONDITION_METHOD_NAME);
        method.setPatternFilePath(this.createURI(method));
    }

    public URI createURI(PatternMethod method) {
        if (method.getID() == null) {
            return null;
        }
        return PatternHelper.Filename.computeFileURI(method);
    }

    protected abstract void addNature(Pattern var1);
}

