/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.execution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.model.pattern.CallBackHandler;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternRuntimeException;
import org.eclipse.egf.model.pattern.TypePatternSubstitution;
import org.eclipse.egf.pattern.Activator;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.engine.PatternEngine;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.utils.SubstitutionHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallHelper {
    public static void executeWithContextInjection(String patternURI, PatternContext ctx) {
        try {
            List<Pattern> patterns = CallHelper.getPatterns(patternURI, ctx);
            TypePatternSubstitution substitutions = (TypePatternSubstitution)ctx.getValue("pattern.substitutions");
            SubstitutionHelper.apply(patterns, substitutions);
            for (Pattern pattern : patterns) {
                PatternExtension extension = ExtensionHelper.getExtension(pattern.getNature());
                String reason = extension.canExecute(pattern);
                if (reason != null) {
                    throw new PatternException(reason);
                }
                extension.createEngine(pattern).execute(ctx);
            }
        }
        catch (PatternException e) {
            throw new PatternRuntimeException((Throwable)e);
        }
        catch (ExtensionHelper.MissingExtensionException e) {
            throw new PatternRuntimeException((Throwable)e);
        }
    }

    public static void executeWithParameterInjection(String patternURI, PatternContext ctx, Map<String, Object> name2parameterValue) {
        try {
            List<Pattern> patterns = CallHelper.getPatterns(patternURI, ctx);
            Pattern originalPattern = patterns.get(0);
            ArrayList<Object> values = new ArrayList<Object>(originalPattern.getAllParameters().size());
            for (PatternParameter param : originalPattern.getAllParameters()) {
                Object value = name2parameterValue.get(param.getName());
                values.add(value);
            }
            List<Pattern> substituedPatterns = SubstitutionHelper.apply(ctx, patterns, values);
            for (Pattern pattern : substituedPatterns) {
                PatternExtension extension = ExtensionHelper.getExtension(pattern.getNature());
                String reason = extension.canExecute(pattern);
                if (reason != null) {
                    throw new PatternException(reason);
                }
                HashMap<PatternParameter, Object> parameters = new HashMap<PatternParameter, Object>();
                for (Map.Entry<String, Object> entry : name2parameterValue.entrySet()) {
                    PatternParameter parameter = pattern.getParameter(entry.getKey());
                    if (parameter == null) {
                        throw new PatternException(Messages.bind((String)Messages.call_execution_error1, (Object)entry.getKey(), (Object)pattern.getName()));
                    }
                    parameters.put(parameter, entry.getValue());
                }
                PatternEngine engine = extension.createEngine(pattern);
                if (!engine.checkCondition(ctx, parameters)) continue;
                engine.executeWithInjection(ctx, parameters);
            }
        }
        catch (PatternException e) {
            throw new PatternRuntimeException((Throwable)e);
        }
        catch (ExtensionHelper.MissingExtensionException e) {
            throw new PatternRuntimeException((Throwable)e);
        }
    }

    private static List<Pattern> getPatterns(String patternURI, PatternContext ctx) throws PatternException {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (patternURI == null) {
            throw new PatternException(Messages.call_execution_error3);
        }
        ResourceSet resourceSet = (ResourceSet)ctx.getValue("internal.pattern.resourceset");
        if (resourceSet == null) {
            throw new PatternException(Messages.call_execution_error2);
        }
        URI uri = URI.createURI((String)patternURI, (boolean)false);
        Pattern targetPattern = (Pattern)resourceSet.getEObject(uri, true);
        if (targetPattern == null) {
            throw new PatternException(Messages.bind((String)Messages.call_execution_error4, (Object)patternURI));
        }
        patterns.add(targetPattern);
        return patterns;
    }

    public static void callBack(PatternContext ctx, Map<String, Object> parameters) {
        try {
            CallBackHandler handler = (CallBackHandler)ctx.getValue("pattern.call.back.handler");
            if (handler == null) {
                Activator.getDefault().logWarning(Messages.missing_callback_handler);
            } else {
                handler.handleCall(ctx, parameters);
            }
        }
        catch (PatternException e) {
            throw new PatternRuntimeException((Throwable)e);
        }
    }

    private CallHelper() {
    }
}

