/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.fx.core.Range;
import org.eclipse.fx.core.array.ArrayUtils;

public final class AnnotatedString<T>
implements CharSequence {
    final char[] content;
    final int[][] ranges;
    final T[][] annotations;

    AnnotatedString(char[] content, int[][] ranges, T[][] annotations) {
        this.content = content;
        this.ranges = ranges;
        this.annotations = annotations;
    }

    public void forEachSegment(SegmentConsumer<T> consumer) {
        int r = 0;
        while (r < this.ranges.length) {
            consumer.accept(r, this.ranges[r][0], this.ranges[r][1], this.annotations[r]);
            ++r;
        }
    }

    public Stream<Segment> stream() {
        return IntStream.range(0, this.ranges.length).mapToObj(n -> new Segment(n));
    }

    public char[] getContent(int segmentIndex) {
        return Arrays.copyOfRange(this.content, this.ranges[segmentIndex][0], this.ranges[segmentIndex][1]);
    }

    public int copyContent(int segmentIndex, char[] target) {
        int l = this.ranges[segmentIndex][1] - this.ranges[segmentIndex][0];
        System.arraycopy(this.content, 0, target, 0, l);
        return l;
    }

    @Override
    public int length() {
        return this.content.length;
    }

    @Override
    public char charAt(int index) {
        return this.content[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int idx = -1;
        int i = 0;
        while (i < this.ranges.length) {
            if (Range.intersects(start, end, this.ranges[i][0], this.ranges[i][1])) {
                idx = i;
                break;
            }
            ++i;
        }
        int[][] targetRange = (int[][])Arrays.copyOfRange(this.ranges, 0, 0);
        Class<?> type = this.annotations.getClass().getComponentType();
        Object targetAnnotation = ArrayUtils.createArray2Dim(type, 0);
        if (idx != -1) {
            targetRange = (int[][])Arrays.copyOf(this.ranges, this.ranges.length - idx);
            targetAnnotation = (Object[][])Arrays.copyOf(this.annotations, this.annotations.length - idx);
        }
        return new AnnotatedString(Arrays.copyOfRange(this.content, start, end), targetRange, (T[][])targetAnnotation);
    }

    @Override
    public String toString() {
        return String.valueOf(this.content);
    }

    public static <T> Builder<T> create(Class<T> type, int capacity) {
        return new BuilderImpl<T>(type, capacity);
    }

    public static interface Builder<T> {
        public Builder<T> add(char[] var1, T ... var2);

        public Builder<T> add(CharSequence var1, T ... var2);

        public AnnotatedString<T> build();
    }

    private static final class BuilderImpl<T>
    implements Builder<T> {
        private StringBuilder builder;
        private final List<Struct<T>> ranges = new ArrayList<Struct<T>>();
        private final Class<T> clazz;

        BuilderImpl(Class<T> clazz, int capacity) {
            this.clazz = clazz;
            this.builder = new StringBuilder(capacity);
        }

        @Override
        @SafeVarargs
        public final Builder<T> add(char[] c, T ... annotations) {
            this.ranges.add(new Struct<T>(this.builder.length(), this.builder.length() + c.length, annotations));
            this.builder.append(c);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder<T> add(CharSequence s, T ... annotations) {
            this.ranges.add(new Struct<T>(this.builder.length(), this.builder.length() + s.length(), annotations));
            this.builder.append(s);
            return this;
        }

        @Override
        public AnnotatedString<T> build() {
            char[] content = new char[this.builder.length()];
            this.builder.getChars(0, this.builder.length(), content, 0);
            int[][] ranges = new int[this.ranges.size()][2];
            T[][] annotations = ArrayUtils.createArray2Dim(this.clazz, this.ranges.size());
            ArrayUtils.fill(ranges, i -> this.ranges.get((int)i).range);
            ArrayUtils.fill(annotations, i -> this.ranges.get((int)i).annotations);
            return new AnnotatedString<T>(content, ranges, annotations);
        }
    }

    public class Segment {
        private final int idx;

        Segment(int idx) {
            this.idx = idx;
        }

        public char[] text() {
            return Arrays.copyOfRange(AnnotatedString.this.content, this.start(), this.end());
        }

        public IntStream chars() {
            return ArrayUtils.stream(AnnotatedString.this.content, this.start(), this.end());
        }

        public int start() {
            return AnnotatedString.this.ranges[this.idx][0];
        }

        public int end() {
            return AnnotatedString.this.ranges[this.idx][1];
        }

        public T[] annotations() {
            return Arrays.copyOf(AnnotatedString.this.annotations[this.idx], AnnotatedString.this.annotations[this.idx].length);
        }
    }

    public static interface SegmentConsumer<T> {
        public void accept(int var1, int var2, int var3, T[] var4);
    }

    private static class Struct<T> {
        int[] range;
        T[] annotations;

        public Struct(int start, int end, T[] annotations) {
            this.range = new int[]{start, end};
            this.annotations = annotations;
        }
    }
}

