/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.part1;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import servlet.tck.api.jakarta_servlet_http.part.PartTests;
import servlet.tck.api.jakarta_servlet_http.part.TestServlet;
import servlet.tck.api.jakarta_servlet_http.part1.TestServletWrapper;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.servlets.CommonServlets;
import servlet.tck.common.util.ServletTestUtil;

public class Part1Tests
extends AbstractTckTest {
    private static final String CRLF = "\r\n";

    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("TestServlet");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"part1.war")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addClasses(new Class[]{TestServletWrapper.class, TestServlet.class});
    }

    @Test
    public void getPartTest() throws Exception {
        byte[] data;
        String testname = "getPartTest";
        Boolean passed = true;
        String EXPECTED_RESPONSE = "getParameter(\"xyz\"): 1234567abcdefg|Part name: xyz|Submitted File Name: null|Size: 14|Content Type: text/plain|Header Names: content-disposition content-type|getPart(String) test=true";
        StringBuilder test_log = new StringBuilder();
        StringBuilder header = new StringBuilder();
        String requestUrl = this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testname + " HTTP/1.1";
        URL url = null;
        try {
            url = this.getURL("http", this._hostname, this._port, requestUrl.substring(1));
            this.logger.debug("url: {}", (Object)url.toExternalForm());
        }
        catch (MalformedURLException ex) {
            passed = false;
            throw new Exception("EXception getting URL " + requestUrl + " with host " + this._hostname + " at port " + this._port, ex);
        }
        try (ByteArrayOutputStream ba = new ByteArrayOutputStream();){
            this.addFile(ba, "xyz", null, "1234567abcdefg");
            ba.write("\r\n--AaB03x--\r\n".getBytes());
            data = ba.toByteArray();
            header.append("POST ").append(url.toExternalForm().replace("http://", "").replace(this._hostname, "").replace(":" + Integer.toString(this._port), "")).append(CRLF);
            header.append("Host: " + this._hostname + CRLF);
            header.append("Connection: close\r\n");
            header.append("Content-Type: multipart/form-data; boundary=AaB03x\r\n");
            header.append("Content-Length: " + data.length + "\r\n\r\n");
            this.logger.debug("Header: {}", (Object)header);
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception creating data", ex);
        }
        try (Socket sock = new Socket(this._hostname, this._port);
             InputStream is = sock.getInputStream();
             OutputStream os = sock.getOutputStream();
             BufferedReader bis = new BufferedReader(new InputStreamReader(is));){
            os.write(header.toString().getBytes());
            os.write(data);
            test_log.append("Data sent");
            String line = null;
            while ((line = bis.readLine()) != null) {
                test_log.append("Received: " + line + CRLF);
            }
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception reading data", ex);
        }
        if (!ServletTestUtil.compareString(EXPECTED_RESPONSE, test_log.toString())) {
            passed = false;
        }
        this.logger.debug("test_log: {}", (Object)test_log);
        if (!passed.booleanValue()) {
            throw new Exception("Test failed due to incorrect response");
        }
    }

    @Test
    public void getPartTest1() throws Exception {
        byte[] data;
        String testname = "getPartTest1";
        Boolean passed = true;
        String EXPECTED_RESPONSE = "Expected ServletException thrown";
        StringBuilder test_log = new StringBuilder();
        StringBuilder header = new StringBuilder();
        String requestUrl = this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testname + " HTTP/1.1";
        URL url = null;
        try {
            url = this.getURL("http", this._hostname, this._port, requestUrl.substring(1));
            this.logger.debug("url: {}", (Object)url.toExternalForm());
        }
        catch (MalformedURLException ex) {
            passed = false;
            throw new Exception("EXception getting URL " + requestUrl + " with host " + this._hostname + " at port " + this._port, ex);
        }
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            this.addFile(ba, "xyz", null, "1234567abcdefg");
            ba.write("\r\n--AaB03x--\r\n".getBytes());
            this.logger.debug("Content: {}", (Object)ba);
            data = ba.toByteArray();
            header.append("POST ").append(url.toExternalForm().replace("http://", "").replace(this._hostname, "").replace(":" + Integer.toString(this._port), "")).append(CRLF);
            header.append("Host: " + this._hostname + CRLF);
            header.append("Connection: close\r\n");
            header.append("Content-Type:  text/plain; boundary=AaB03x\r\n");
            header.append("Content-Length: " + data.length + "\r\n\r\n");
            this.logger.debug("Header: {}", (Object)header);
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception creating data", ex);
        }
        try (Socket sock = new Socket(this._hostname, this._port);
             InputStream is = sock.getInputStream();
             OutputStream os = sock.getOutputStream();
             BufferedReader bis = new BufferedReader(new InputStreamReader(is));){
            os.write(header.toString().getBytes());
            os.write(data);
            test_log.append("Data sent");
            String line = null;
            while ((line = bis.readLine()) != null) {
                test_log.append("Received: " + line + CRLF);
            }
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception reading data", ex);
        }
        if (!ServletTestUtil.compareString(EXPECTED_RESPONSE, test_log.toString())) {
            passed = false;
        }
        this.logger.debug("test_log: {}", (Object)test_log);
        if (!passed.booleanValue()) {
            throw new Exception("Test failed due to incorrect response");
        }
    }

    @Test
    public void getPartsTest() throws Exception {
        byte[] data;
        URL url;
        String testname = "getPartsTest";
        Boolean passed = true;
        String EXPECTED_RESPONSE = "Expected ServletException thrown";
        StringBuilder test_log = new StringBuilder();
        StringBuilder header = new StringBuilder();
        String requestUrl = this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testname + " HTTP/1.1";
        try {
            url = this.getURL("http", this._hostname, this._port, requestUrl.substring(1));
            this.logger.debug("url: {}", (Object)url.toExternalForm());
        }
        catch (MalformedURLException ex) {
            passed = false;
            throw new Exception("EXception getting URL " + requestUrl + " with host " + this._hostname + " at port " + this._port, ex);
        }
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            this.addFile(ba, "myFile", "test.txt", null);
            ba.write(CRLF.getBytes());
            this.addFile(ba, "myFile2", "test2.txt", null);
            ba.write(CRLF.getBytes());
            this.addFile(ba, "xyz", null, "1234567abcdefg");
            ba.write("\r\n--AaB03x--\r\n".getBytes());
            this.logger.debug("Content: {}", (Object)ba);
            data = ba.toByteArray();
            header.append("POST ").append(url.toExternalForm().replace("http://", "").replace(this._hostname, "").replace(":" + Integer.toString(this._port), "")).append(CRLF);
            header.append("Host: " + this._hostname + CRLF);
            header.append("Connection: close\r\n");
            header.append("Content-Type:  text/plain; boundary=AaB03x\r\n");
            header.append("Content-Length: " + data.length + "\r\n\r\n");
            this.logger.debug("Header: {}", (Object)header);
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception creating data", ex);
        }
        try (Socket sock = new Socket(this._hostname, this._port);
             InputStream is = sock.getInputStream();
             OutputStream os = sock.getOutputStream();
             BufferedReader bis = new BufferedReader(new InputStreamReader(is));){
            os.write(header.toString().getBytes());
            os.write(data);
            test_log.append("Data sent");
            String line = null;
            while ((line = bis.readLine()) != null) {
                test_log.append("Received: " + line + CRLF);
            }
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception reading data", ex);
        }
        if (!ServletTestUtil.compareString(EXPECTED_RESPONSE, test_log.toString())) {
            passed = false;
        }
        this.logger.debug("test_log: {}", (Object)test_log);
        if (!passed.booleanValue()) {
            throw new Exception("Test failed due to incorrect response");
        }
    }

    @Test
    public void getPartsTest1() throws Exception {
        byte[] data;
        URL url;
        String testname = "getPartsTest1";
        Boolean passed = true;
        String EXPECTED_RESPONSE = "getParameter(\"xyz\"): 1234567abcdefg|Part name: myFile|Submitted File Name: test.txt|Size: 36|Content Type: text/plain|Header Names: content-disposition content-type|Part name: myFile2|Submitted File Name: test2.txt|Size: 37|Content Type: text/plain|Header Names: content-disposition content-type|Part name: xyz|Submitted File Name: null|Size: 14|Content Type: text/plain|Header Names: content-disposition content-type";
        StringBuilder test_log = new StringBuilder();
        StringBuilder header = new StringBuilder();
        String requestUrl = this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testname + " HTTP/1.1";
        try {
            url = this.getURL("http", this._hostname, this._port, requestUrl.substring(1));
            this.logger.debug("url: {}", (Object)url.toExternalForm());
        }
        catch (MalformedURLException ex) {
            passed = false;
            throw new Exception("EXception getting URL " + requestUrl + " with host " + this._hostname + " at port " + this._port, ex);
        }
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            this.addFile(ba, "myFile", "test.txt", null);
            this.logger.debug("first file: {}", (Object)ba);
            ba.write(CRLF.getBytes());
            this.addFile(ba, "myFile2", "test2.txt", null);
            ba.write(CRLF.getBytes());
            this.logger.debug("second file: {}", (Object)ba);
            this.addFile(ba, "xyz", null, "1234567abcdefg");
            this.logger.debug("third: {}", (Object)ba);
            ba.write("\r\n--AaB03x--\r\n".getBytes());
            data = ba.toByteArray();
            this.logger.debug("Data: {}", (Object)data);
            header.append("POST ").append(url.toExternalForm().replace("http://", "").replace(this._hostname, "").replace(":" + Integer.toString(this._port), "")).append(CRLF);
            header.append("Host: " + this._hostname + CRLF);
            header.append("Connection: close\r\n");
            header.append("Content-Type: multipart/form-data; boundary=AaB03x\r\n");
            header.append("Content-Length: " + data.length + "\r\n\r\n");
            this.logger.debug("Header: {}", (Object)header);
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception creating data", ex);
        }
        try (Socket sock = new Socket(this._hostname, this._port);
             InputStream is = sock.getInputStream();
             OutputStream os = sock.getOutputStream();
             BufferedReader bis = new BufferedReader(new InputStreamReader(is));){
            os.write(header.toString().getBytes());
            os.write(data);
            this.logger.debug("Data sent: {}", (Object)data);
            String line = null;
            while ((line = bis.readLine()) != null) {
                test_log.append("Received: " + line + CRLF);
            }
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception reading data", ex);
        }
        if (!ServletTestUtil.compareString(EXPECTED_RESPONSE, test_log.toString())) {
            passed = false;
        }
        this.logger.debug("test_log: {}", (Object)test_log);
        if (!passed.booleanValue()) {
            throw new Exception("Test failed due to incorrect response");
        }
    }

    @Test
    public void getHeaderTest() throws Exception {
        byte[] data;
        URL url;
        String testname = "getHeaderTest";
        Boolean passed = true;
        String EXPECTED_RESPONSE = "Part name: myFile|content-disposition:|form-data;|name=\"myFile\";|filename=\"test.txt\"|content-type: text/plain|TCKDummyNameNonExistant: null|Part name: myFile2|content-disposition:|form-data;|name=\"myFile2\";|filename=\"test2.txt\"|content-type: text/plain|TCKDummyNameNonExistant: null|Part name: xyz|content-disposition:|form-data;|name=\"xyz\"|content-type: text/plain|TCKDummyNameNonExistant: null";
        StringBuilder test_log = new StringBuilder();
        StringBuilder header = new StringBuilder();
        String requestUrl = this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testname + " HTTP/1.1";
        try {
            url = this.getURL("http", this._hostname, this._port, requestUrl.substring(1));
            this.logger.debug("url: {}", (Object)url.toExternalForm());
        }
        catch (MalformedURLException ex) {
            passed = false;
            throw new Exception("EXception getting URL " + requestUrl + " with host " + this._hostname + " at port " + this._port, ex);
        }
        try (ByteArrayOutputStream ba = new ByteArrayOutputStream();){
            this.addFile(ba, "myFile", "test.txt", null);
            ba.write(CRLF.getBytes());
            this.addFile(ba, "myFile2", "test2.txt", null);
            ba.write(CRLF.getBytes());
            this.addFile(ba, "xyz", null, "1234567abcdefg");
            ba.write("\r\n--AaB03x--\r\n".getBytes());
            data = ba.toByteArray();
            header.append("POST ").append(url.toExternalForm().replace("http://", "").replace(this._hostname, "").replace(":" + Integer.toString(this._port), "")).append(CRLF);
            header.append("Host: " + this._hostname + CRLF);
            header.append("Connection: close\r\n");
            header.append("Content-Type: multipart/form-data; boundary=AaB03x\r\n");
            header.append("Content-Length: " + data.length + "\r\n\r\n");
            this.logger.debug("Header: {}", (Object)header);
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception creating data", ex);
        }
        try (Socket sock = new Socket(this._hostname, this._port);
             InputStream is = sock.getInputStream();
             OutputStream os = sock.getOutputStream();
             BufferedReader bis = new BufferedReader(new InputStreamReader(is));){
            os.write(header.toString().getBytes());
            os.write(data);
            this.logger.debug("Data sent: {}", (Object)data.toString());
            String line = null;
            while ((line = bis.readLine()) != null) {
                test_log.append("Received: " + line + CRLF);
            }
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception reading data", ex);
        }
        if (!ServletTestUtil.compareString(EXPECTED_RESPONSE, test_log.toString())) {
            passed = false;
        }
        this.logger.debug("test_log: {}", (Object)test_log.toString());
        if (!passed.booleanValue()) {
            throw new Exception("Test failed due to incorrect response");
        }
    }

    @Test
    public void getHeadersTest() throws Exception {
        byte[] data;
        String testname = "getHeadersTest";
        Boolean passed = true;
        String EXPECTED_RESPONSE = "Part name: myFile|content-disposition:|form-data;|name=\"myFile\";|filename=\"test.txt\"|content-type: text/plain|TCKDummyNameNonExistant: 0|Part name: myFile2|content-disposition:|form-data;|name=\"myFile2\";|filename=\"test2.txt\"|content-type: text/plain|TCKDummyNameNonExistant: 0|Part name: xyz|content-disposition:|form-data;|name=\"xyz\"|content-type: text/plain|TCKDummyNameNonExistant: 0";
        StringBuilder test_log = new StringBuilder();
        StringBuilder header = new StringBuilder();
        String requestUrl = this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testname + " HTTP/1.1";
        URL url = null;
        try {
            url = this.getURL("http", this._hostname, this._port, requestUrl.substring(1));
            this.logger.debug("url: {}", (Object)url.toExternalForm());
        }
        catch (MalformedURLException ex) {
            passed = false;
            throw new Exception("EXception getting URL " + requestUrl + " with host " + this._hostname + " at port " + this._port, ex);
        }
        try (ByteArrayOutputStream ba = new ByteArrayOutputStream();){
            this.addFile(ba, "myFile", "test.txt", null);
            ba.write(CRLF.getBytes());
            this.addFile(ba, "myFile2", "test2.txt", null);
            ba.write(CRLF.getBytes());
            this.addFile(ba, "xyz", null, "1234567abcdefg");
            ba.write("\r\n--AaB03x--\r\n".getBytes());
            data = ba.toByteArray();
            header.append("POST ").append(url.toExternalForm().replace("http://", "").replace(this._hostname, "").replace(":" + Integer.toString(this._port), "")).append(CRLF);
            header.append("Host: " + this._hostname + CRLF);
            header.append("Connection: close\r\n");
            header.append("Content-Type: multipart/form-data; boundary=AaB03x\r\n");
            header.append("Content-Length: " + data.length + "\r\n\r\n");
            this.logger.debug("Header: {}", (Object)header);
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception creating data", ex);
        }
        try (Socket sock = new Socket(this._hostname, this._port);
             InputStream is = sock.getInputStream();
             OutputStream os = sock.getOutputStream();
             BufferedReader bis = new BufferedReader(new InputStreamReader(is));){
            os.write(header.toString().getBytes());
            os.write(data);
            this.logger.debug("Data sent: {}", (Object)data.toString());
            String line = null;
            while ((line = bis.readLine()) != null) {
                test_log.append("Received: " + line + CRLF);
            }
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception reading data", ex);
        }
        if (!ServletTestUtil.compareString(EXPECTED_RESPONSE, test_log.toString())) {
            passed = false;
        }
        this.logger.debug("test_log: {}", (Object)test_log);
        if (!passed.booleanValue()) {
            throw new Exception("Test failed due to incorrect response");
        }
    }

    @Test
    public void getInputStreamTest() throws Exception {
        byte[] data;
        String testname = "getInputStreamTest";
        Boolean passed = true;
        String EXPECTED_RESPONSE = "Parts size=1|Part name: myFile|First line.|Second line.|Last line.";
        StringBuilder test_log = new StringBuilder();
        StringBuilder header = new StringBuilder();
        String requestUrl = this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testname + " HTTP/1.1";
        URL url = null;
        try {
            url = this.getURL("http", this._hostname, this._port, requestUrl.substring(1));
            this.logger.debug("url: {}", (Object)url.toExternalForm());
        }
        catch (MalformedURLException ex) {
            passed = false;
            throw new Exception("EXception getting URL " + requestUrl + " with host " + this._hostname + " at port " + this._port, ex);
        }
        try (ByteArrayOutputStream ba = new ByteArrayOutputStream();){
            this.addFile(ba, "myFile", "test.txt", null);
            ba.write("\r\n--AaB03x--\r\n".getBytes());
            data = ba.toByteArray();
            header.append("POST ").append(url.toExternalForm().replace("http://", "").replace(this._hostname, "").replace(":" + Integer.toString(this._port), "")).append(CRLF);
            header.append("Host: " + this._hostname + CRLF);
            header.append("Connection: close\r\n");
            header.append("Content-Type: multipart/form-data; boundary=AaB03x\r\n");
            header.append("Content-Length: " + data.length + "\r\n\r\n");
            this.logger.debug("Header: {}", (Object)header);
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception creating data", ex);
        }
        try (Socket sock = new Socket(this._hostname, this._port);
             InputStream is = sock.getInputStream();
             OutputStream os = sock.getOutputStream();
             BufferedReader bis = new BufferedReader(new InputStreamReader(is));){
            os.write(header.toString().getBytes());
            os.write(data);
            this.logger.debug("Data sent: {}", (Object)data.toString());
            String line = null;
            while ((line = bis.readLine()) != null) {
                test_log.append("Received: " + line + CRLF);
            }
        }
        catch (IOException ex) {
            passed = false;
            throw new Exception("Exception reading data", ex);
        }
        if (!ServletTestUtil.compareString(EXPECTED_RESPONSE, test_log.toString())) {
            passed = false;
        }
        this.logger.debug("test_log: {}", (Object)test_log);
        if (!passed.booleanValue()) {
            throw new Exception("Test failed due to incorrect response");
        }
    }

    void addFile(ByteArrayOutputStream ba, String partname, String filename, String content) throws IOException {
        ba.write("--AaB03x\r\n".getBytes());
        if (filename != null) {
            ba.write(("Content-Disposition: form-data; name=\"" + partname + "\"; filename=\"" + filename + "\"\r\n").getBytes());
            ba.write("Content-Type: text/plain\r\n\r\n".getBytes());
            URL url = PartTests.class.getResource(filename);
            byte[] file1Bytes = url.openStream().readAllBytes();
            ba.write(file1Bytes, 0, file1Bytes.length);
        } else {
            ba.write(("Content-Disposition: form-data; name=\"" + partname + "\"\r\n").getBytes());
            ba.write("Content-Type: text/plain\r\n\r\n".getBytes());
        }
        if (content != null) {
            ba.write(content.getBytes());
        }
    }
}

