/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)TestMessageListener.java	1.11 03/05/16
 */
package com.sun.ts.tests.jms.common;
import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;
import java.io.*;
import java.rmi.RemoteException;
import java.util.*;
import com.sun.javatest.Status;
import javax.jms.*;


/**
 * Message Listener implementation for JMS testing
 */
public class TestMessageListener implements javax.jms.MessageListener {
    public MessageConsumer 	mConsumer;
    public DoneLatch		monitor;
    public ArrayList		messageArray = new ArrayList();

    /**
     * Constructor takes a MessageConsumer argument
     * 
     * @param MessageConsumer
     */
    public TestMessageListener(MessageConsumer mc, DoneLatch dl) {
        mConsumer = mc;
        monitor = dl;
    }

    /**
     * Returns the list of messages received.
     * 
     * @return ArrayList the list of Messages that have been received
     */
    public ArrayList getMessageArray() {
        return messageArray;
    }

    /**
     * Clears the list of messages received.
     * 
     */
    public DoneLatch getLatch() {
        return monitor;
    }

    /**
     * Clears the list of messages received.
     * 
     */
    public void clearMessageArray() {
        messageArray.clear();
    }

    /**
     * Responds to incoming Messages. A TextMessage is the end
     * of stream signal.
     * 
     * @param Message the message passed to the listener
     */
    public void onMessage(Message message) {
        try {
            TestUtil.logTrace("MessageListener for " + mConsumer.toString() + " received message: " 
                              + message.toString());
            messageArray.add(message);
        } catch (Exception e) {
            TestUtil.logErr("Error in MessageListener: " + e.toString(), e);
        }
        if (message instanceof TextMessage) {
            monitor.allDone();
        }
    }
}
