/*
 * Copyright (c) 2007, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SunRIJMSObjects.java 69701 2013-01-30 17:28:34Z af70133 $
 */

package com.sun.ts.lib.implementation.sun.jms;

import java.util.*;
import java.io.*;
import javax.naming.*;
import javax.jms.*;
import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
    
/**
 * This is an implementation of the TSJMSObjectsInterface.  An implementation
 * of this class must be supplied by any JMS implementation wishing to
 * get JMS adminsitered objects: ConnectionFactories, queues and topics. 
 *
 * @author  Dianne Jiao
 */

public class SunRIJMSObjects implements TSJMSObjectsInterface {
    private static Context          	     jndiContext = null;
    private static QueueConnectionFactory    qcf = null;
    private static TopicConnectionFactory    tcf = null;
    private static ConnectionFactory         cf = null;
    private javax.jms.Topic                  testTopic = null;
    private javax.jms.Queue         	     testQueue = null;


    private void getJNDIContext() throws Exception {

        if (jndiContext == null) {
            try {
                TestUtil.logTrace("Getting initial context");
                jndiContext = new InitialContext();
            } catch (javax.naming.NamingException ne) {
                TestUtil.logErr("Could not create JNDI context because: ", ne);
                TestUtil.printStackTrace(ne);
                throw ne;
            }
        }
    }


    /**
    * This method allows individual implementation to
    * get the Queue
    */

    public javax.jms.Queue getQueue(String name) throws Exception {
        getJNDIContext();

        try {
            testQueue = (javax.jms.Queue) jndiContext.lookup(name);
        } catch (Exception e) {
            TestUtil.logErr("Failed to lookup Queue");
            TestUtil.printStackTrace(e);
            throw e;
        }
        return testQueue;
    }


    /**
    * This method allows individual implementation to
    * get the Topic
    */

    public Topic getTopic(String name) throws Exception {
        getJNDIContext();

        try {
            testTopic= (Topic) jndiContext.lookup(name);
        } catch (Exception e) {
            TestUtil.logErr("Failed to lookup Topic");
            TestUtil.printStackTrace(e);
            throw e;
        }
        return testTopic;
    }


    /**
    * This method allows individual implementation to
    * get the QueueConnectionFactory
    */

    public QueueConnectionFactory getQueueConnectionFactory(String name) 
                                  throws Exception {
        getJNDIContext();

        try {
            qcf = (QueueConnectionFactory) jndiContext.lookup(name);
        } catch (Exception e) {
            TestUtil.logErr("Failed to lookup QueueConnectionFactory");
            TestUtil.printStackTrace(e);
            throw e;
        }
        return qcf;
    }


    /**
    * This method allows individual implementation to
    * get the TopicConnectionFactory
    */

    public TopicConnectionFactory getTopicConnectionFactory(String name) 
                                  throws Exception {
        getJNDIContext();

        try {
            tcf = (TopicConnectionFactory) jndiContext.lookup(name);
        } catch (Exception e) {
            TestUtil.logErr("Failed to lookup TopicConnectionFactory");
            TestUtil.printStackTrace(e);
            throw e;
        }
        return tcf;
    }


    /**
    * This method allows individual implementation to
    * get the ConnectionFactory
    */

    public ConnectionFactory getConnectionFactory(String name) 
                                  throws Exception {
        getJNDIContext();

        try {
            cf = (ConnectionFactory) jndiContext.lookup(name);
        } catch (Exception e) {
            TestUtil.logErr("Failed to lookup ConnectionFactory");
            TestUtil.printStackTrace(e);
            throw e;
        }
        return cf;
    }
}
