/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */

package com.sun.ts.tests.jaxrs.spec.provider.visibility;

import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
public class HolderResolver implements ContextResolver<HolderClass> {
	private HttpHeaders headers;
	private UriInfo info;
	private Application application;
	private Request request;
	private Providers provider;

	protected HolderResolver(@Context HttpHeaders headers, @Context UriInfo info,
			@Context Application application, @Context Request request,
			@Context Providers provider) {
		super();
		this.headers = headers;
		this.info = info;
		this.application = application;
		this.request = request;
		this.provider = provider;
	}

	public HolderResolver(@Context HttpHeaders headers, @Context UriInfo info,
			@Context Application application, @Context Request request) {
		super();
		this.headers = headers;
		this.info = info;
		this.application = application;
		this.request = request;
	}

	public HolderResolver(@Context HttpHeaders headers, @Context UriInfo info,
			@Context Application application) {
		super();
		this.headers = headers;
		this.info = info;
		this.application = application;
	}

	public HolderResolver(@Context HttpHeaders headers, @Context UriInfo info) {
		super();
		this.headers = headers;
		this.info = info;
	}

	public HolderResolver(@Context HttpHeaders headers) {
		super();
		this.headers = headers;
	}

	@Override
	public HolderClass getContext(Class<?> type) {
		return new HolderClass(headers, info, application, request, provider);
	}
}
