/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: TSAppConfig.java 75010 2017-05-30 19:45:08Z jsupol $  
 */

package com.sun.ts.tests.jaxrs.jaxrs21.ee.priority;

import java.util.HashSet;
import java.util.Set;

import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;

@ApplicationPath("/")
public class TSAppConfig extends Application {

	public java.util.Set<java.lang.Class<?>> getClasses() {
		Set<Class<?>> resources = new HashSet<Class<?>>();
		resources.add(ExceptionMapperTwo.class);
		resources.add(ExceptionMapperOne.class);
		resources.add(ExceptionMapperThree.class);
		resources.add(ExceptionResource.class);
		resources.add(ParamConverterResource.class);
		resources.add(ParamConverterProviderTwo.class);
		return resources;
	}
	
	@Override
	public Set<Object> getSingletons() {
		Set<Object> resources = new HashSet<Object>();
		resources.add(new ParamConverterProviderAnother());
		resources.add(new ParamConverterProviderOne());
		return resources;
	}
}
