/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: Resource.java 73547 2014-02-26 20:08:48Z supol $
 */

package com.sun.ts.tests.jaxrs.ee.rs.constrainedto;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path("resource")
public class Resource {
	public static final String MESSAGE = "ConstrainedTo message";

	@POST
	@Path("echo")
	public String post(String entity) {
		return entity;
	}

	@POST
	@Path("media")
	public Response buildResponseWithMedia(String media) {
		Response r = Response.ok().entity(MESSAGE).type(media).build();
		return r;
	}

	@POST
	@Path("clientwriter")
	public Response return201IfWriterWorkedOnClient(String entity) {
		Response r = null;
		if (ClientSideWriter.FAKE_MESSAGE.equals(entity))
			r = Response.noContent().build();
		else
			r = Response.ok().build();
		return r;
	}
}
