/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AbstractMessageBodyRW.java 75004 2017-05-30 16:04:30Z jsupol $
 */
package com.sun.ts.tests.jaxrs.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import javax.ws.rs.Path;

/**
 * This class is a superclass used in MessageBodyWriters which need to check 
 * @Path annotation value 
 */
public abstract class AbstractMessageBodyRW {

	public static String getPathValue(Annotation[] annotations) {		
		return getSpecifiedAnnotationValue(annotations, Path.class);
	}

	@SuppressWarnings("unchecked")
	public static <T extends Annotation> T getSpecifiedAnnotation(
			Annotation[] annotations, Class<T> clazz) {
		T t = null;
		for (Annotation a : annotations)
			if (a.annotationType() == clazz)
				t = (T) a;
		return t != null ? t : null;
	}

	public static <T extends Annotation> String getSpecifiedAnnotationValue(
			Annotation[] annotations, Class<T> clazz) {
		T t = getSpecifiedAnnotation(annotations, clazz);
		try {
			Method m = clazz.getMethod("value");
			return (String) m.invoke(t);
		} catch (Exception e) {
			return null;
		}
	}

}
