/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: InterceptorOneBody.java 69498 2013-01-14 14:49:15Z supol $ 
 */

package com.sun.ts.tests.jaxrs.api.rs.ext.interceptor.reader.readerinterceptorcontext;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ReaderInterceptorContext;

import com.sun.ts.tests.jaxrs.api.rs.ext.interceptor.TemplateInterceptorBody;
import com.sun.ts.tests.jaxrs.common.provider.StringBean;
import com.sun.ts.tests.jaxrs.common.util.JaxrsUtil;

public class InterceptorOneBody extends
		TemplateInterceptorBody<ReaderInterceptorContext> {

	public void getHeaders() {
		MultivaluedMap<String, String> headers = context.getHeaders();
		setEntity(JaxrsUtil.iterableToString(";", headers.keySet()));
	}

	public void getHeadersIsMutable() {
		MultivaluedMap<String, String> headers = context.getHeaders();
		headers.add(PROPERTY, PROPERTY);
	}

	public void getInputStream() throws IOException {
		InputStream stream = context.getInputStream();
		String entity = JaxrsUtil.readFromStream(stream);
		stream.close();
		setEntity(entity);
	}

	public void proceedThrowsIOException() {
		try {
			context.proceed();
			setEntity(NULL);
		} catch (IOException ioe) {
			setEntity(IOE);
		}
	}

	public Object proceedThrowsWebAppException()
			throws WebApplicationException, IOException {
		Object proceedObject = new ExceptionThrowingStringBean(NULL, false);
		try {
			proceedObject = context.proceed();
		} catch (WebApplicationException e) {
			//Exception has been thrown, message body reader has read nothing
			//hence we need to set expected value;
			((StringBean) proceedObject).set(WAE);
		}
		return proceedObject;
	}

	public void setInputStream() {
		ByteArrayInputStream stream = new ByteArrayInputStream(NULL.getBytes());
		context.setInputStream(stream);
	}

}
