/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */

package com.sun.ts.tests.jaxrs.api.client.clientrequestcontext;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.Response;

import com.sun.ts.lib.harness.EETest.Fault;
import com.sun.ts.tests.jaxrs.common.util.JaxrsUtil;

public class GetPropertyNamesProvider extends ContextProvider {
	private AtomicInteger counter;

	public GetPropertyNamesProvider(AtomicInteger counter) {
		super();
		this.counter = counter;
	}

	@Override
	protected void checkFilterContext(ClientRequestContext context)
			throws Fault {
		if (counter.incrementAndGet() == 2) {
			Collection<String> properties = context.getPropertyNames();
			String entity = properties == null ? "NULL" : JaxrsUtil
					.iterableToString(";", properties);
			Response r = Response.ok(entity).build();
			context.abortWith(r);
		} else {
			context.setProperty("PROPERTY1", "value1");
			context.setProperty("PROPERTY2", "value2");
		}
	}

	protected static <T> String collectionToString(Collection<T> collection) {
		StringBuilder sb = new StringBuilder();
		for (T t : collection)
			sb.append(t).append(";");
		return sb.toString();
	}
}
