/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javasoft.sqe.apiCheck.API;
import javasoft.sqe.apiCheck.Decision;
import javasoft.sqe.apiCheck.JReader;
import javasoft.sqe.apiCheck.Main;
import javasoft.sqe.apiCheck.PackageSet;
import javasoft.sqe.apiCheck.ReadJhu;
import javasoft.sqe.apiCheck.TestBase;
import javasoft.sqe.apiCheck.TestBincomp;
import javasoft.sqe.apiCheck.TestChanges;
import javasoft.sqe.apiCheck.Tran;
import javasoft.sqe.apiCheck.Version;
import javasoft.sqe.apiCheck.WriteJh;

public class Diff {
    static String[] pars = new String[]{"base$s", "test$s", "update$m$s", "package$m$s", "expackage$m$s", "out$s", "updateout$s", "sigout$s", "verbose", "sort", "check$s", "constvalues", "defpack$s", "nodefpack", "reflect", "static", "version", "time", "debug"};
    static String help = "Options are:\n-base <spec>\n-test <spec>\n-update <file>\n-package <packs>\n-expackage <packs>\n-out <file>\n-updateout <file>\n-sigout <file>\n-verbose\n-sort\n-check [bincomp | <modifier>]\n-constvalues\n-defpack <pack>\n-nodefpack\n-reflect\n-static\n-version";

    public static void main(String[] args) {
        TestBase tb;
        String check;
        API testapi;
        String testpath;
        API baseapi;
        String basepath;
        if (!Main.args.Parse(args, pars) || Main.args.isEmpty()) {
            System.err.println(help);
            return;
        }
        if (Main.args.getProperty("version") != null) {
            System.out.println("Version: " + Version.Ident());
            if (Main.args.size() == 1) {
                return;
            }
        }
        boolean nonempty = false;
        PackageSet packs = new PackageSet(Main.args.getProperty("package"), Main.args.getProperty("expackage"));
        String defpack = Main.args.getProperty("defpack");
        if (Main.args.getProperty("nodefpack") == null) {
            if (defpack == null) {
                defpack = "java.lang";
            }
        } else if (defpack != null) {
            Diff.Stop("error in options -defpack/-nodefpack");
        }
        if (defpack != null) {
            Main.args.setProperty("defpack", defpack);
        }
        if ((basepath = Main.args.getProperty("base")) == null) {
            System.err.println("base not defined - using default classpath");
        }
        if ((baseapi = Diff.Read(basepath, packs)) == null) {
            Diff.Stop("no classes found in \"" + basepath + "\"");
        }
        nonempty |= !baseapi.IsEmpty();
        Tran tran = null;
        String updtpath = Main.args.getProperty("update");
        if (updtpath != null) {
            JReader readupd = null;
            StringTokenizer st = new StringTokenizer(updtpath, File.pathSeparator + ' ', false);
            while (st.hasMoreElements()) {
                String fname = (String)st.nextElement();
                File f = new File(fname);
                if (!f.exists() && !fname.endsWith(".jhu") && (f = new File(fname + ".jhu")).exists() && f.isFile()) {
                    fname = fname + ".jhu";
                }
                f = null;
                if (tran == null) {
                    tran = new Tran();
                    readupd = new ReadJhu(tran);
                }
                if (((ReadJhu)readupd).Read(baseapi, fname)) continue;
                Diff.Stop(null);
            }
            if (readupd != null) {
                readupd.PrintUnknown(System.err);
            }
        }
        if ((testpath = Main.args.getProperty("test")) == null) {
            System.err.println("test not defined - using default classpath");
        }
        if ((testapi = Diff.Read(testpath, packs)) == null) {
            Diff.Stop("no classes found in \"" + testpath + "\"");
        }
        nonempty |= !testapi.IsEmpty();
        if (tran != null) {
            Decision dec = new Decision(baseapi.GetUnits(), testapi.GetUnits(), tran);
            dec.Work(baseapi.props);
            baseapi.xprog = null;
            nonempty |= !baseapi.IsEmpty();
        }
        if (!nonempty) {
            Diff.Stop("base and test empty");
        }
        PrintWriter pw = null;
        try {
            pw = Main.args.getProperty("out") == null ? new PrintWriter(System.out) : new PrintWriter(new FileWriter(Main.args.getProperty("out")));
        }
        catch (IOException x) {
            Diff.Stop("out error\n" + x.getMessage());
        }
        if (Main.IsDebugMode()) {
            WriteJh wjh = new WriteJh();
            pw.println("BASE");
            wjh.WriteAll(baseapi, pw);
            pw.println("TEST");
            wjh.WriteAll(testapi, pw);
            pw.println("----");
        }
        PrintWriter pwupd = null;
        try {
            pwupd = Main.args.getProperty("updateout") == null ? null : new PrintWriter(new FileWriter(Main.args.getProperty("updateout")));
        }
        catch (IOException x) {
            Diff.Stop("updateout error\n" + x.getMessage());
        }
        if (tran != null && Main.args.getProperty("verbose") != null) {
            tran.Print(pw);
        }
        if ((check = Main.args.getProperty("check")) != null && check.equals("bincomp")) {
            tb = new TestBincomp();
            tb.mode = "protected";
            tb.check = "bincomp";
            tb.values = false;
            if (Main.args.getProperty("constvalues") != null) {
                System.err.println("-constvalues option ignored in bincomp mode");
            }
            if (pwupd != null) {
                System.err.println("updates cannot be genereated in bincomp mode");
            }
        } else {
            tb = new TestChanges();
            tb.mode = check == null ? "protected" : check;
            tb.check = "maint(" + tb.mode + ")";
            tb.values = Main.args.getProperty("constvalues") != null;
            tb.upd.out = pwupd;
        }
        tb.out = pw;
        tb.sort = Main.args.getProperty("sort") != null;
        tb.verbose = Main.args.getProperty("verbose") != null;
        tb.check = tb.check + ", verbose:" + (tb.verbose ? "yes" : "no");
        tb.Compare(packs, baseapi, testapi);
        if (pwupd != null) {
            pwupd.flush();
            pwupd.close();
            pwupd = null;
        }
        if (tran == null) {
            if (tb.errs == 0) {
                pw.println("\n- No differences found -");
            } else {
                pw.println("\n- Differences found : " + tb.errs + " -");
            }
        } else {
            String s1 = tb.errs == 0 ? "No unapproved differences found" : "Unapproved differences found : " + tb.errs;
            String s2 = tran.Status() == 2 ? "All updates implemented" : "Not all updates umplemented";
            pw.println("\n - " + s1 + ". " + s2 + ". -");
        }
        pw.close();
        pw = null;
        if (Main.args.getProperty("sigout") != null) {
            WriteJh writer = new WriteJh();
            writer.Write(baseapi, Main.args.getProperty("sigout"));
            writer.Close();
        }
        System.exit(0 + (tb.errs == 0 ? 0 : 2) + (tran == null || tran.Status() == 2 ? 0 : 4));
    }

    static API Read(String name, PackageSet pset) {
        API api = null;
        if (name != null && name.indexOf(System.getProperty("path.separator")) == -1 && !name.equals("$")) {
            File f = new File(name);
            if (!f.exists()) {
                if (name.endsWith(".jh")) {
                    System.err.println("not found \"" + name + "\"");
                    return null;
                }
                f = new File(name + ".jh");
                if (!f.exists() || !f.isFile()) {
                    System.err.println("not found \"" + name + "\"");
                    return null;
                }
                name = name + ".jh";
            }
            if (f.isFile()) {
                if (!f.canRead()) {
                    System.err.println("cannot read \"" + name + "\"");
                    return null;
                }
                api = new API();
                return api.ReadAll(name, pset) > 0 ? api : null;
            }
        }
        return (api = new API()).ReadAll(name, pset) > 0 ? api : null;
    }

    static void Stop(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println("Diff terminated.");
        System.exit(1);
    }
}

