/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.platform.cdi;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.platform.cdi.WSInjectableServer;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;

@ServerEndpoint(value="/constructor")
@ApplicationScoped
public class WSConstructorServer {
    private static final System.Logger logger = System.getLogger(WSConstructorServer.class.getName());
    private WSInjectableServer injectableServer;

    @OnMessage
    public String inject(String echo) {
        if (this.injectableServer == null) {
            return "Nothing injected using CDI";
        }
        return this.injectableServer.getName(echo);
    }

    @Inject
    public WSConstructorServer(WSInjectableServer injectableServer) {
        this.injectableServer = injectableServer;
    }

    public WSConstructorServer() {
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = IOUtil.printStackTrace((Throwable)t);
        session.getBasicRemote().sendText(message);
    }
}

