/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.resourceDefs.ejb;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.resourceDefs.ejb.ITestAdminObjStatelessEjb;
import jakarta.annotation.security.DeclareRoles;
import jakarta.ejb.EJB;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.HttpMethodConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

@DeclareRoles(value={"Administrator", "Manager", "Employee"})
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"Administrator"}), httpMethodConstraints={@HttpMethodConstraint(value="GET", rolesAllowed={"Administrator"}), @HttpMethodConstraint(value="POST", rolesAllowed={"Administrator"})})
@WebServlet(name="AODTestServlet", urlPatterns={"/AODTestServlet"})
public class AODTestServlet
extends HttpServlet {
    private String servletAppContext = null;
    private String testMethod = null;
    private String RARJndiScope = null;
    @EJB
    private ITestAdminObjStatelessEjb testAdminObjStatelessEjb;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.debug("in AODTestServlet.doGet()");
        this.getPropsAndParams(request, response);
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.debug("in AODTestServlet.doPost()");
        this.getPropsAndParams(request, response);
        this.doTests(request, response);
    }

    private void doTests(HttpServletRequest request, HttpServletResponse response) {
        this.debug("in AODTestServlet.doTests()");
        PrintWriter out = null;
        try {
            out = response.getWriter();
        }
        catch (Exception ex) {
            this.debug("got exception in AODTestServlet");
            ex.printStackTrace();
        }
        this.getPropsAndParams(request, response);
        if (this.testMethod.equals("ValidateGlobalAdminObj")) {
            this.debug("AODTestServlet.doTests(): testMethod == ValidateGlobalAdminObj");
            this.validateGlobalAdminObj(request, response);
        } else if (this.testMethod.equals("ValidateAppAdminObj")) {
            this.debug("AODTestServlet.doTests(): testMethod == ValidateAppAdminObj");
            this.validateAppAdminObj(request, response);
        } else if (this.testMethod.equals("ValidateCompAdminObj")) {
            this.debug("AODTestServlet.doTests(): testMethod == ValidateCompAdminObj");
            this.validateCompAdminObj(request, response);
        } else if (this.testMethod.equals("ValidateModuleAdminObj")) {
            this.debug("AODTestServlet.doTests(): testMethod == ValidateModuleAdminObj");
            this.validateModuleAdminObj(request, response);
        }
    }

    private void getPropsAndParams(HttpServletRequest req, HttpServletResponse response) {
        this.testMethod = req.getParameter("method.under.test");
        this.RARJndiScope = req.getParameter("rar.jndi.scope");
        this.debug("AODTestServlet.getPropsAndParams():  testMethod = " + this.testMethod);
        this.debug("AODTestServlet.getPropsAndParams():  RARJndiScope = " + this.RARJndiScope);
    }

    public void validateGlobalAdminObj(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean bval;
            PrintWriter out = response.getWriter();
            System.out.println("TestServlet->validateGlobalResourceDef()  calling testStatefullEjb.validateGlobalResourceDef()");
            if (this.testAdminObjStatelessEjb == null) {
                this.send_output(out, "ERROR:  test will fail since testAdminObjStatelessEjb == null");
            }
            if (bval = this.testAdminObjStatelessEjb.validateConnectorResource(this.RARJndiScope)) {
                this.send_output(out, "SUCCESS:  validateGlobalAdminObj passed.");
            } else {
                this.send_output(out, "FAILURE:  validateGlobalAdminObj had unexpected exception.");
            }
        }
        catch (Exception ex) {
            System.out.println("AODTestServlet->validateGlobalAdminObj() failed");
            ex.printStackTrace();
            System.out.println("FAILURE:  validateGlobalAdminObj had unexpected exception.");
        }
    }

    public void validateAppAdminObj(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean bval;
            PrintWriter out = response.getWriter();
            if (this.testAdminObjStatelessEjb == null) {
                this.send_output(out, "ERROR:  test will fail since testAdminObjStatelessEjb == null");
            }
            if (bval = this.testAdminObjStatelessEjb.validateConnectorResource(this.RARJndiScope)) {
                this.send_output(out, "SUCCESS:  validateAppAdminObj passed.");
            } else {
                this.send_output(out, "FAILURE:  validateAppAdminObj had unexpected exception.");
            }
        }
        catch (Exception ex) {
            System.out.println("AODTestServlet->validateAppAdminObj() failed");
            ex.printStackTrace();
            System.out.println("FAILURE:  validateAppAdminObj had unexpected exception.");
        }
    }

    public void validateCompAdminObj(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean bval;
            PrintWriter out = response.getWriter();
            if (this.testAdminObjStatelessEjb == null) {
                this.send_output(out, "ERROR:  test will fail since testAdminObjStatelessEjb == null");
            }
            if (bval = this.testAdminObjStatelessEjb.validateConnectorResource(this.RARJndiScope)) {
                this.send_output(out, "SUCCESS:  validateCompAdminObj passed.");
            } else {
                this.send_output(out, "FAILURE:  validateCompAdminObj had unexpected exception.");
            }
        }
        catch (Exception ex) {
            System.out.println("TestServlet->validateCompAdminObj() failed");
            ex.printStackTrace();
            System.out.println("FAILURE:  validateCompAdminObj had unexpected exception.");
        }
    }

    public void validateModuleAdminObj(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean bval;
            PrintWriter out = response.getWriter();
            if (this.testAdminObjStatelessEjb == null) {
                this.send_output(out, "ERROR:  test will fail since testAdminObjStatelessEjb == null");
            }
            if (bval = this.testAdminObjStatelessEjb.validateConnectorResource(this.RARJndiScope)) {
                this.send_output(out, "SUCCESS:  validateModuleAdminObj passed.");
            } else {
                this.send_output(out, "FAILURE:  validateModuleAdminObj had unexpected exception.");
            }
        }
        catch (Exception ex) {
            System.out.println("TestServlet->validateModuleAdminObj() failed");
            ex.printStackTrace();
            System.out.println("FAILURE:  validateModuleAdminObj had unexpected exception.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateConnectorResource(String jndiName) {
        Object c = null;
        boolean rval = false;
        try {
            this.debug("validateConnectorResource():  calling new TSNamingContext()");
            TSNamingContext ic = new TSNamingContext();
            this.debug("Doing lookup of jndiName = " + jndiName);
            TSDataSource ds = (TSDataSource)ic.lookup(jndiName);
            this.debug("validateConnectorResource(): Successfully did lookup of jndiName = " + jndiName);
            rval = true;
        }
        catch (Exception e) {
            this.debug("Fail to access connector resource: " + jndiName);
            e.printStackTrace();
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return rval;
    }

    public void send_output(PrintWriter out, String str) {
        if (out != null) {
            out.println(str);
            out.flush();
            this.debug(str);
        } else {
            this.print_err("ERROR, Null PrintWriter:  can not properly send back message: " + str);
        }
    }

    public void print_err(String str) {
        System.err.println(str);
        this.debug(str);
    }

    public void debug(String str) {
        TestUtil.logMsg((String)str);
        System.out.println(str);
    }
}

