/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.batchUpdate;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class batchUpdateClient
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.batchUpdate";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String drManager = null;
    private transient DatabaseMetaData dbmd = null;
    private Properties sqlp = null;
    private boolean supbatupdflag;
    private String fTableName = null;
    PreparedStatement pstmt = null;
    PreparedStatement pstmt1 = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        batchUpdateClient theTests = new batchUpdateClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.fTableName = p.getProperty("ftable", "");
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.supbatupdflag = this.dbmd.supportsBatchUpdates();
                this.logTrace("Driver Supports BatchUpdates  : " + this.supbatupdflag);
                this.msg = new JDBCTestMsg();
                if (!this.supbatupdflag) {
                    this.logTrace("Driver does not support Batch Updates ");
                    throw new Exception("Driver does not support Batch Updates ");
                }
                this.Insert_Tab(p, this.conn);
                this.stmt = this.conn.createStatement();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void Insert_Tab(Properties testProps, Connection conn) throws Exception {
        String newName = null;
        float newPrice = 0.0f;
        int newType = 0;
        String sDelete = this.sqlp.getProperty("BatchUpdate_Delete");
        try {
            this.logTrace("About to delete the Existing Rows");
            Statement stm = conn.createStatement();
            stm.execute(sDelete);
            this.logTrace("Deleted the Previous Existed Rows ");
            String strCofSize = testProps.getProperty("cofSize");
            TestUtil.logTrace((String)("strCofSize: " + strCofSize));
            String strCofTypeSize = testProps.getProperty("cofTypeSize");
            TestUtil.logTrace((String)("strCofTypeSize : " + strCofTypeSize));
            int cofTypeSize = Integer.parseInt(strCofTypeSize);
            int cofSize = Integer.parseInt(strCofSize);
            TestUtil.logTrace((String)("Adding the " + this.fTableName + " table rows"));
            String updateString1 = this.sqlp.getProperty("BatchInsert_String");
            this.pstmt = conn.prepareStatement(updateString1);
            int newKey = 1;
            for (int i = 1; i <= cofTypeSize && newKey <= cofSize; ++i) {
                for (int j = 1; j <= i && newKey <= cofSize; ++newKey, ++j) {
                    newName = "COFFEE-" + newKey;
                    newPrice = (float)newKey + 0.0f;
                    newType = i;
                    this.pstmt.setInt(1, newKey);
                    this.pstmt.setString(2, newName);
                    this.pstmt.setFloat(3, newPrice);
                    this.pstmt.setInt(4, newType);
                    this.pstmt.executeUpdate();
                }
            }
            this.logTrace("Inserted the Rows ");
        }
        catch (SQLException sql) {
            this.logErr("SQL Exception " + sql.getMessage());
            throw new Exception("Call to SetupFailed!", sql);
        }
        catch (Exception ex) {
            this.logErr("Exception " + ex.getMessage());
            throw new Exception("Call to Setup Failed!", ex);
        }
    }

    public void testAddBatch01() throws Exception {
        int i = 0;
        int[] retValue = new int[]{0, 0, 0};
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, 2);
            this.pstmt.addBatch();
            this.pstmt.setInt(1, 3);
            this.pstmt.addBatch();
            this.pstmt.setInt(1, 4);
            this.pstmt.addBatch();
            int[] updateCount = this.pstmt.executeBatch();
            int updateCountlen = updateCount.length;
            this.msg.setMsg("Successfully Updated");
            this.msg.setMsg("updateCount Length :" + updateCountlen);
            if (updateCountlen != 3) {
                this.msg.printTestError("addBatch does not add the SQL Statements to Batch ", "call to addBatch failed");
            } else {
                this.msg.setMsg("addBatch add the SQL statements to Batch ");
            }
            String sPrepStmt1 = this.sqlp.getProperty("BatchUpdate_Query");
            this.pstmt1 = this.conn.prepareStatement(sPrepStmt1);
            for (int n = 2; n <= 4; ++n) {
                this.pstmt1.setInt(1, n);
                this.rs = this.pstmt1.executeQuery();
                this.rs.next();
                retValue[i++] = this.rs.getInt(1);
            }
            this.pstmt1.close();
            for (int j = 0; j < updateCount.length; ++j) {
                this.msg.addOutputMsg("" + updateCount[j], "" + retValue[j]);
                if (updateCount[j] == retValue[j] || updateCount[j] == -2) continue;
                this.msg.printTestError("affected row count does not match with the updateCount value", "Call to addBatch is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to addBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to addBatch is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to addBatch is Failed!");
        }
    }

    public void testAddBatch02() throws Exception {
        int i = 0;
        int[] retValue = new int[]{0, 0, 0};
        int updCountLength = 0;
        try {
            String sUpdCoffee = this.sqlp.getProperty("Upd_Coffee_Tab");
            String sDelCoffee = this.sqlp.getProperty("Del_Coffee_Tab");
            String sInsCoffee = this.sqlp.getProperty("Ins_Coffee_Tab");
            this.msg.setMsg("execute the addBatch method");
            this.stmt.addBatch(sUpdCoffee);
            this.stmt.addBatch(sDelCoffee);
            this.stmt.addBatch(sInsCoffee);
            int[] updateCount = this.stmt.executeBatch();
            updCountLength = updateCount.length;
            if (updCountLength != 3) {
                this.msg.printTestError("addBatch does not add the SQL Statements to Batch ", "Call to addBatch is Failed!");
            } else {
                this.msg.setMsg("addBatch add the SQL statements to Batch ");
            }
            String sPrepStmt1 = this.sqlp.getProperty("BatchUpdate_Query");
            this.pstmt1 = this.conn.prepareStatement(sPrepStmt1);
            this.pstmt1.setInt(1, 1);
            this.rs = this.pstmt1.executeQuery();
            this.rs.next();
            retValue[i++] = this.rs.getInt(1);
            this.pstmt1.close();
            retValue[i++] = 1;
            retValue[i++] = 1;
            this.msg.setMsg("ReturnValue count : " + retValue.length);
            for (int j = 0; j < updateCount.length; ++j) {
                this.msg.addOutputMsg("" + updateCount[j], "" + retValue[j]);
                if (updateCount[j] == retValue[j]) continue;
                this.msg.setMsg("affected row count does not match with the updateCount value");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to addBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to addBatch is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to addBatch is Failed!");
        }
    }

    public void testAddBatch03() throws Exception {
        int i = 0;
        int[] retValue = new int[]{0, 0, 0};
        int updCountLength = 0;
        try {
            this.msg.setMsg("get the CallableStatement object");
            CallableStatement cstmt = this.conn.prepareCall("{call UpdCoffee_Proc(?)}");
            cstmt.setInt(1, 2);
            cstmt.addBatch();
            cstmt.setInt(1, 3);
            cstmt.addBatch();
            cstmt.setInt(1, 4);
            cstmt.addBatch();
            this.msg.setMsg("execute the executeBatch method");
            int[] updateCount = cstmt.executeBatch();
            updCountLength = updateCount.length;
            this.msg.setMsg("Successfully Updated");
            if (updCountLength != 3) {
                this.msg.printTestError("addBatch does not add the SQL Statements to Batch ", "Call to addBatch is Failed!");
            } else {
                this.msg.setMsg("addBatch add the SQL statements to Batch ");
            }
            String sPrepStmt1 = this.sqlp.getProperty("BatchUpdate_Query");
            this.pstmt1 = this.conn.prepareStatement(sPrepStmt1);
            for (int n = 2; n <= 4; ++n) {
                this.pstmt1.setInt(1, n);
                this.rs = this.pstmt1.executeQuery();
                this.rs.next();
                retValue[i++] = this.rs.getInt(1);
            }
            this.pstmt1.close();
            for (int j = 0; j < updateCount.length; ++j) {
                this.msg.addOutputMsg("" + updateCount[j], "" + retValue[j]);
                if (updateCount[j] == retValue[j]) continue;
                this.msg.setMsg("addBatch does not add the SQL Statements to Batch");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to addBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to addBatch is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to addBatch is Failed!");
        }
    }

    public void testClearBatch01() throws Exception {
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, 2);
            this.pstmt.addBatch();
            this.pstmt.setInt(1, 3);
            this.pstmt.addBatch();
            this.pstmt.setInt(1, 4);
            this.pstmt.addBatch();
            this.msg.setMsg("execute clearBatch() method");
            this.pstmt.clearBatch();
            int[] updateCount = this.pstmt.executeBatch();
            int updCountLength = updateCount.length;
            if (updCountLength == 0) {
                this.msg.setMsg("clearBatch Method clears the current Batch ");
            } else {
                this.msg.printTestError("clearBatch Method does not clear the Current Batch ", "Call to clearBatch is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to clearBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to clearBatch is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to clearBatch is Failed!");
        }
    }

    public void testClearBatch02() throws Exception {
        int updCountLength = 0;
        try {
            String sUpdCoffee = this.sqlp.getProperty("Upd_Coffee_Tab");
            String sInsCoffee = this.sqlp.getProperty("Ins_Coffee_Tab");
            String sDelCoffee = this.sqlp.getProperty("Del_Coffee_Tab");
            this.msg.setMsg("execute addBatch method");
            this.stmt.addBatch(sUpdCoffee);
            this.stmt.addBatch(sDelCoffee);
            this.stmt.addBatch(sInsCoffee);
            this.msg.setMsg("execute clearBatch method");
            this.stmt.clearBatch();
            int[] updateCount = this.stmt.executeBatch();
            updCountLength = updateCount.length;
            if (updCountLength == 0) {
                this.msg.setMsg("clearBatch Method clears the current Batch ");
            } else {
                this.msg.printTestError("clearBatch Method does not clear the current Batch", "Call to clearBatch is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to clearBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to clearBatch is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to clearBatch is Failed!");
        }
    }

    public void testClearBatch03() throws Exception {
        int updCountLength = 0;
        try {
            this.msg.setMsg("get the CallableStatement object");
            CallableStatement cstmt = this.conn.prepareCall("{call UpdCoffee_Proc(?)}");
            cstmt.setInt(1, 2);
            cstmt.addBatch();
            cstmt.setInt(1, 3);
            cstmt.addBatch();
            cstmt.setInt(1, 4);
            cstmt.addBatch();
            this.msg.setMsg("execute clearBatch method");
            cstmt.clearBatch();
            int[] updateCount = cstmt.executeBatch();
            updCountLength = updateCount.length;
            if (updCountLength == 0) {
                this.msg.setMsg("clearBatch Method clears the current Batch ");
            } else {
                this.msg.printTestError("clearBatch Method does not clear the current Batch", "Call to clearBatch is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to addBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to clearBatch is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to clearBatch is Failed!");
        }
    }

    public void testExecuteBatch01() throws Exception {
        int i = 0;
        int[] retValue = new int[]{0, 0, 0};
        int updCountLength = 0;
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, 1);
            this.pstmt.addBatch();
            this.pstmt.setInt(1, 2);
            this.pstmt.addBatch();
            this.pstmt.setInt(1, 3);
            this.pstmt.addBatch();
            this.msg.setMsg("execute the executeBatch Method");
            int[] updateCount = this.pstmt.executeBatch();
            updCountLength = updateCount.length;
            this.msg.setMsg("Successfully Updated");
            this.msg.setMsg("updateCount Length :" + updCountLength);
            if (updCountLength != 3) {
                this.msg.printTestError("executeBatch does not execute the Batch of SQL statements", "Call to executeBatch is Failed!");
            } else {
                this.msg.setMsg("executeBatch executes the Batch of SQL statements");
            }
            String sPrepStmt1 = this.sqlp.getProperty("BatchUpdate_Query");
            this.pstmt1 = this.conn.prepareStatement(sPrepStmt1);
            for (int n = 1; n <= 3; ++n) {
                this.pstmt1.setInt(1, n);
                this.rs = this.pstmt1.executeQuery();
                this.rs.next();
                retValue[i++] = this.rs.getInt(1);
            }
            this.pstmt1.close();
            this.msg.setMsg("retvalue length : " + retValue.length);
            for (int j = 0; j < updateCount.length; ++j) {
                this.msg.addOutputMsg("" + updateCount[j], "" + retValue[j]);
                if (updateCount[j] == retValue[j] || updateCount[j] == -2) continue;
                this.msg.printTestError("executeBatch does not execute the Batch of SQL statements", "Call to executeBatch is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to executeBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeBatch is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeBatch is Failed!");
        }
    }

    public void testExecuteBatch02() throws Exception {
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, 1);
            this.pstmt.setInt(1, 2);
            this.pstmt.setInt(1, 3);
            int[] updateCount = this.pstmt.executeBatch();
            int updCountLength = updateCount.length;
            this.msg.setMsg("UpdateCount Length : " + updCountLength);
            if (updCountLength == 0) {
                this.msg.setMsg("executeBatch does not execute Empty Batch");
            } else {
                this.msg.printTestError("executeBatch executes Empty Batch", "Call to executeBatch is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to executeBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeBatch is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeBatch is Failed!");
        }
    }

    public void testExecuteBatch03() throws Exception {
        boolean bexpflag = false;
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Select", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, 1);
            this.pstmt.addBatch();
            try {
                this.msg.setMsg("execute the executeBatch method");
                int[] nArray = this.pstmt.executeBatch();
            }
            catch (BatchUpdateException b) {
                TestUtil.printStackTrace((Throwable)b);
                bexpflag = true;
            }
            if (bexpflag) {
                this.msg.setMsg("executeBatch does not execute the Batch with a SQL select statement ");
            } else {
                this.msg.printTestError("executeBatch executes the Batch with a SQL select statement ", "Call to executeBatch is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to executeBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeBatch is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeBatch is Failed!");
        }
    }

    public void testExecuteBatch04() throws Exception {
        int i = 0;
        int[] retValue = new int[]{0, 0, 0};
        int updCountLength = 0;
        try {
            String sUpdCoffee = this.sqlp.getProperty("Upd_Coffee_Tab");
            String sInsCoffee = this.sqlp.getProperty("Ins_Coffee_Tab");
            String sDelCoffee = this.sqlp.getProperty("Del_Coffee_Tab");
            this.stmt.addBatch(sUpdCoffee);
            this.stmt.addBatch(sDelCoffee);
            this.stmt.addBatch(sInsCoffee);
            this.msg.setMsg("execute the executeBatch method");
            int[] updateCount = this.stmt.executeBatch();
            updCountLength = updateCount.length;
            this.msg.setMsg("Successfully Updated");
            this.msg.setMsg("updateCount Length :" + updCountLength);
            if (updCountLength != 3) {
                this.msg.printTestError("executeBatch does not execute the Batch of SQL statements", "Call to executeBatch is Failed!");
            } else {
                this.msg.setMsg("executeBatch executes the Batch of SQL statements");
            }
            String sPrepStmt1 = this.sqlp.getProperty("BatchUpdate_Query");
            this.pstmt1 = this.conn.prepareStatement(sPrepStmt1);
            this.pstmt1.setInt(1, 1);
            this.rs = this.pstmt1.executeQuery();
            this.rs.next();
            retValue[i++] = this.rs.getInt(1);
            retValue[i++] = 1;
            retValue[i++] = 1;
            for (int j = 0; j < updateCount.length; ++j) {
                this.msg.addOutputMsg("" + updateCount[j], "" + retValue[j]);
                if (updateCount[j] == retValue[j]) continue;
                this.msg.setMsg("affected row count does not match with the updateCount value");
            }
            this.msg.printTestMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to executeBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeBatch is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeBatch is Failed!");
        }
    }

    public void testExecuteBatch05() throws Exception {
        int updCountLength = 0;
        try {
            String sUpdCoffee = this.sqlp.getProperty("Upd_Coffee_Tab");
            String sInsCoffee = this.sqlp.getProperty("Ins_Coffee_Tab");
            String sDelCoffee = this.sqlp.getProperty("Del_Coffee_Tab");
            int[] updateCount = this.stmt.executeBatch();
            updCountLength = updateCount.length;
            this.msg.setMsg("updateCount Length :" + updCountLength);
            if (updCountLength == 0) {
                this.msg.setMsg("executeBatch Method does not execute the Empty Batch ");
            } else {
                this.msg.printTestError("executeBatch Method executes the Empty Batch", "Call to executeBatch is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to executeBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeBatch is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeBatch is Failed!");
        }
    }

    public void testExecuteBatch06() throws Exception {
        boolean bexpflag = false;
        try {
            String sInsCoffee = this.sqlp.getProperty("Ins_Coffee_Tab");
            String sDelCoffee = this.sqlp.getProperty("Del_Coffee_Tab");
            String sUpdCoffee = this.sqlp.getProperty("Upd_Coffee_Tab");
            this.stmt.addBatch(sInsCoffee);
            this.stmt.addBatch(sInsCoffee);
            this.stmt.addBatch(sDelCoffee);
            try {
                int[] nArray = this.stmt.executeBatch();
            }
            catch (BatchUpdateException b) {
                TestUtil.printStackTrace((Throwable)b);
                bexpflag = true;
                int[] updCounts = b.getUpdateCounts();
                for (int i = 0; i < updCounts.length; ++i) {
                    this.msg.setMsg("Update counts of Successful Commands : " + updCounts[i]);
                }
            }
            if (bexpflag) {
                this.msg.setMsg("executeBatch does not execute the SQL statement with a violation SQL constraint");
            } else {
                this.msg.printTestError("executeBatch executes the SQL statement with a violation Constraints", "Call to executeBatch is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to executeBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeBatch is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeBatch is Failed!");
        }
    }

    public void testExecuteBatch07() throws Exception {
        boolean bexpflag = false;
        try {
            String sDelCoffee = this.sqlp.getProperty("Del_Coffee_Tab");
            String sUpdCoffee = this.sqlp.getProperty("Upd_Coffee_Tab");
            String sSelCoffee = this.sqlp.getProperty("Sel_Coffee_Tab");
            this.msg.setMsg("sSelCoffee = " + sSelCoffee);
            Statement stmt = this.conn.createStatement();
            stmt.addBatch(sSelCoffee);
            try {
                int[] updateCount = stmt.executeBatch();
                this.msg.setMsg("updateCount Length : " + updateCount.length);
            }
            catch (BatchUpdateException be) {
                TestUtil.printStackTrace((Throwable)be);
                bexpflag = true;
            }
            if (bexpflag) {
                this.msg.setMsg("executeBatch does not execute the Batch with a SQL select statement ");
            } else {
                this.msg.printTestError("executeBatch executes the Batch with a SQL select statement ", "Call to executeBatch is Failed");
            }
            this.msg.printTestMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to executeBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeBatch is Failed");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeBatch is Failed");
        }
    }

    public void testExecuteBatch08() throws Exception {
        int i = 0;
        int[] retValue = new int[]{0, 0, 0};
        int updCountLength = 0;
        try {
            this.msg.setMsg("get the CallableStatement object");
            CallableStatement cstmt = this.conn.prepareCall("{call UpdCoffee_Proc(?)}");
            cstmt.setInt(1, 4);
            cstmt.addBatch();
            cstmt.setInt(1, 3);
            cstmt.addBatch();
            cstmt.setInt(1, 1);
            cstmt.addBatch();
            int[] updateCount = cstmt.executeBatch();
            updCountLength = updateCount.length;
            this.msg.setMsg("Successfully Updated");
            this.msg.setMsg("updateCount Length :" + updCountLength);
            if (updCountLength != 3) {
                this.msg.printTestError("executeBatch does not execute the Batch of SQL statements", "Call to executeBatch is Failed");
            } else {
                this.msg.setMsg("executeBatch executes the Batch of SQL statements");
            }
            String sPrepStmt1 = this.sqlp.getProperty("BatchUpdate_Query");
            this.pstmt1 = this.conn.prepareStatement(sPrepStmt1);
            for (int n = 1; n <= 3; ++n) {
                this.pstmt1.setInt(1, n);
                this.rs = this.pstmt1.executeQuery();
                this.rs.next();
                retValue[i++] = this.rs.getInt(1);
            }
            this.pstmt1.close();
            for (int j = 0; j < updateCount.length; ++j) {
                this.msg.addOutputMsg("" + updateCount[j], "" + retValue[j]);
                if (updateCount[j] == retValue[j]) continue;
                this.msg.setMsg("affected row count does not match with the updateCount value");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to executeBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeBatch is Failed");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeBatch is Failed");
        }
    }

    public void testExecuteBatch09() throws Exception {
        int updCountLength = 0;
        try {
            CallableStatement cstmt = this.conn.prepareCall("{call UpdCoffee_Proc(?)}");
            cstmt.setInt(1, 1);
            cstmt.setInt(1, 2);
            cstmt.setInt(1, 3);
            int[] updateCount = cstmt.executeBatch();
            updCountLength = updateCount.length;
            this.msg.setMsg("updateCount Length :" + updCountLength);
            if (updCountLength == 0) {
                this.msg.setMsg("executeBatch Method does not execute the Empty Batch");
            } else {
                this.msg.printTestError("executeBatch Method executes the Empty Batch", "Call to executeBatch is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to executeBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeBatch is Failed");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeBatch is Failed");
        }
    }

    public void testExecuteBatch12() throws Exception {
        try {
            this.msg.setMsg("get the CallableStatement object");
            CallableStatement cstmt = this.conn.prepareCall("{call Coffee_Proc(?)}");
            cstmt.setInt(1, 2);
            cstmt.addBatch();
            cstmt.setInt(1, 3);
            cstmt.addBatch();
            cstmt.setInt(1, 5);
            cstmt.addBatch();
            int[] updateCount = cstmt.executeBatch();
            int updCountLength = updateCount.length;
            this.msg.setMsg("updateCountLength : " + updCountLength);
            if (updCountLength != 3) {
                this.msg.printTestError("executeBatch does not execute the Batch of SQL statements", "Call to executeBatch is Failed");
            } else {
                this.msg.setMsg("executeBatch executes the Batch of SQL statements");
            }
            for (int i = 0; i < updCountLength; ++i) {
                this.msg.setMsg("UpdateCount Value : " + updateCount[i]);
            }
            this.msg.printTestMsg();
        }
        catch (BatchUpdateException b) {
            this.msg.printSQLError(b, "BatchUpdateException :  Call to executeBatch is Failed!");
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeBatch is Failed");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeBatch is Failed");
        }
    }

    public void testContinueBatch01() throws Exception {
        int[] batchUpdates = new int[]{0, 0, 0};
        int[] updateCount = new int[]{0, 0, 0};
        int buCountlen = 0;
        boolean updateCountlen = false;
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Continue1", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, 1);
            this.pstmt.setString(2, "Continue-1");
            this.pstmt.setString(3, "COFFEE-1");
            this.pstmt.addBatch();
            this.pstmt.setInt(1, 1);
            this.pstmt.setString(2, "Invalid");
            this.pstmt.setString(3, "COFFEE-3");
            this.pstmt.addBatch();
            this.pstmt.setInt(1, 2);
            this.pstmt.setString(2, "Continue-2");
            this.pstmt.setString(3, "COFFEE-2");
            this.pstmt.addBatch();
            this.msg.setMsg("execute the method executeBatch");
            updateCount = this.pstmt.executeBatch();
        }
        catch (BatchUpdateException b) {
            TestUtil.printStackTrace((Throwable)b);
            this.msg.setMsg("Caught expected BatchUpdateException");
            batchUpdates = b.getUpdateCounts();
            buCountlen = batchUpdates.length;
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to continueUpdate failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to continueUpdate failed!");
        }
        if (buCountlen == 1) {
            this.msg.setMsg("Driver does not support continued updates - OK");
            return;
        }
        if (buCountlen == 3) {
            this.msg.setMsg("Driver supports continued updates.");
            try {
                String query = this.sqlp.getProperty("CoffeeTab_ContinueSelect1", "");
                this.msg.setMsg("Query is: " + query);
                this.rs = this.stmt.executeQuery(query);
                this.rs.next();
                int count = this.rs.getInt(1);
                this.rs.close();
                this.stmt.close();
                this.msg.setMsg("Count val is: " + count);
                if (batchUpdates[1] != -3 || count != 1) {
                    throw new Exception("Driver did not insert after error.");
                }
                this.msg.printTestMsg();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to continueUpdate failed!");
            }
        }
    }

    public void cleanup() throws Exception {
        try {
            this.pstmt.close();
            this.stmt.close();
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

