/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import javax.xml.namespace.QName;

public class XPathQName {
    private boolean isNamespaceAware;
    private String localName;
    private String namespaceUri;

    public XPathQName() {
        this.isNamespaceAware = true;
        this.namespaceUri = "";
    }

    public XPathQName(String localName, boolean namespaceAware) {
        this("", localName, namespaceAware);
    }

    public XPathQName(String namespaceUri, String localName, boolean namespaceAware) {
        this.namespaceUri = namespaceUri == null ? "" : namespaceUri;
        this.localName = localName;
        this.isNamespaceAware = namespaceAware;
    }

    public XPathQName(QName qname, boolean namespaceAware) {
        this(qname.getNamespaceURI(), qname.getLocalPart(), namespaceAware);
    }

    public int hashCode() {
        if (null == this.localName) {
            return 1;
        }
        return this.localName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XPathQName)) {
            return false;
        }
        XPathQName qName = (XPathQName)obj;
        if (this.isNamespaceAware && qName.isNamespaceAware) {
            if (this.namespaceUri == null) {
                if (qName.namespaceUri != null) {
                    return false;
                }
            } else {
                if (qName.namespaceUri == null) {
                    return false;
                }
                if (this.namespaceUri != qName.namespaceUri && !this.namespaceUri.equals(qName.namespaceUri)) {
                    return false;
                }
            }
        }
        return this.localName == qName.localName || this.localName != null && this.localName.equals(qName.localName);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != this.namespaceUri && this.namespaceUri.length() > 0) {
            stringBuilder.append('{');
            stringBuilder.append(this.namespaceUri);
            stringBuilder.append('}');
        }
        if (null != this.localName) {
            stringBuilder.append(this.localName);
        }
        return stringBuilder.toString();
    }
}

