/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.glassfish.config.support.XMLStreamReaderFilter;

abstract class ServerReaderFilter
extends XMLStreamReaderFilter {
    final File domainXml;
    final XMLInputFactory xif;
    private final InputStream stream;
    private final FileLock lock;

    ServerReaderFilter(URL theDomainXml, XMLInputFactory theXif) throws XMLStreamException {
        try {
            this.domainXml = new File(theDomainXml.toURI());
            this.xif = theXif;
            FileInputStream fis = new FileInputStream(this.domainXml);
            this.lock = fis.getChannel().lock(0L, Long.MAX_VALUE, true);
            this.stream = new BufferedInputStream(fis);
            this.setParent(this.xif.createXMLStreamReader(this.stream, StandardCharsets.UTF_8.name()));
        }
        catch (IOException | URISyntaxException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public final void close() throws XMLStreamException {
        try {
            if (this.lock.isValid()) {
                this.lock.release();
            }
            super.close();
            this.stream.close();
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }
}

