/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.ClassLoaderFinder;
import com.sun.webui.jsf.util.ResourceBundleManager;
import jakarta.faces.context.FacesContext;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageUtil {
    protected MessageUtil() {
    }

    public static String getMessage(FacesContext context, String baseName, String key) {
        return MessageUtil.getMessage(context, baseName, key, null);
    }

    public static String getMessage(FacesContext context, String baseName, String key, Object[] args) {
        return MessageUtil.getMessage(MessageUtil.getLocale(context), baseName, key, args);
    }

    public static String getMessage(String baseName, String key) {
        return MessageUtil.getMessage(baseName, key, null);
    }

    public static String getMessage(String baseName, String key, Object[] args) {
        return MessageUtil.getMessage(MessageUtil.getLocale(), baseName, key, args);
    }

    public static String getMessage(Locale locale, String baseName, String key, Object[] args) {
        ClassLoader loader = ClassLoaderFinder.getCurrentLoader(MessageUtil.class);
        return MessageUtil.getMessage(locale, baseName, key, args, loader);
    }

    public static String getMessage(Locale locale, String baseName, String key, Object[] args, ClassLoader loader) {
        if (key == null) {
            return key;
        }
        if (locale == null || baseName == null || loader == null) {
            throw new NullPointerException("One or more parameters is null");
        }
        ResourceBundle bundle = ResourceBundleManager.getInstance().getBundle(baseName, locale, loader);
        if (null == bundle) {
            throw new NullPointerException("Could not obtain resource bundle");
        }
        String message = null;
        try {
            message = bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (message != null) {
            return MessageUtil.getFormattedMessage(message, args);
        }
        return MessageUtil.getFormattedMessage(key, args);
    }

    protected static String getFormattedMessage(String message, Object[] args) {
        if (args == null || args.length == 0) {
            return message;
        }
        String result = null;
        try {
            MessageFormat mf = new MessageFormat(message);
            result = mf.format(args);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (result != null) {
            return result;
        }
        return message;
    }

    protected static Locale getLocale() {
        return MessageUtil.getLocale(FacesContext.getCurrentInstance());
    }

    protected static Locale getLocale(FacesContext context) {
        if (context == null) {
            return Locale.getDefault();
        }
        Locale locale = null;
        if (context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
        }
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    public static ClassLoader getCurrentLoader(Object obj) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            return loader;
        }
        return obj.getClass().getClassLoader();
    }
}

