/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.management.util.PortMapperMQAddress;
import com.sun.messaging.jmq.util.log.Logger;

public class MQAddressUtil {
    private static boolean DEBUG = false;

    public static MQAddress getPortMapperMQAddress(Integer port) {
        PortMapperMQAddress addr;
        block4: {
            addr = null;
            if (port == null) {
                if (DEBUG) {
                    Logger logger = Globals.getLogger();
                    logger.log(4, "Null port passed in to getPortMapperMQAddress()");
                }
                return null;
            }
            try {
                String url = Globals.getMQAddress().getHostName() + ":" + port.toString();
                addr = PortMapperMQAddress.createAddress(url);
            }
            catch (Exception e) {
                if (!DEBUG) break block4;
                Logger logger = Globals.getLogger();
                logger.log(4, "Failed to create portmapper address", e);
            }
        }
        return addr;
    }

    public static MQAddress getServiceMQAddress(String svcName, Integer port, boolean bypassPortmapper) {
        MQAddress addr;
        block10: {
            addr = null;
            String scheme = "mq";
            Logger logger = Globals.getLogger();
            if (svcName == null || svcName.equals("") || port == null) {
                if (DEBUG) {
                    logger.log(4, "Null service name and/or port passed in to getServiceMQAddress()");
                }
                return null;
            }
            if (bypassPortmapper) {
                scheme = MQAddressUtil.getScheme(svcName);
            }
            if (scheme == null) {
                return null;
            }
            if (bypassPortmapper) {
                try {
                    String url = scheme + "://" + Globals.getMQAddress().getHostName() + ":" + port.toString() + "/" + svcName;
                    addr = MQAddress.getMQAddress(url);
                }
                catch (Exception e) {
                    if (DEBUG) {
                        logger.log(4, "Failed to create service address", e);
                    }
                    break block10;
                }
            }
            try {
                String url = Globals.getMQAddress().getHostName() + ":" + port.toString() + "/" + svcName;
                addr = PortMapperMQAddress.createAddress(url);
            }
            catch (Exception e) {
                if (!DEBUG) break block10;
                logger.log(4, "Failed to create service address", e);
            }
        }
        return addr;
    }

    private static String getScheme(String svcName) {
        String proto = Globals.getConfig().getProperty("imq." + svcName + ".protocoltype");
        String scheme = null;
        if (proto.equals("tcp")) {
            scheme = "mqtcp";
        } else if (proto.equals("tls")) {
            scheme = "mqssl";
        }
        return scheme;
    }
}

