/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class XMLUtil {
    private XMLUtil() {
    }

    public static void printXML(StringBuffer out, String msg) {
        XMLUtil.printXML(out, msg, true);
    }

    public static void printXML(StringBuffer out, String msg, boolean attribute) {
        if (msg == null) {
            return;
        }
        XMLUtil.appendLine(out, msg, attribute);
    }

    public static void printXML(StringBuffer out, char msg, boolean attribute) {
        if (msg == '&') {
            out.append("&amp;");
        } else if (msg == '<') {
            out.append("&lt;");
        } else if (msg == '>') {
            out.append("&gt;");
        } else if (attribute) {
            if (msg == '\"') {
                out.append("&quot;");
            } else if (msg == '\'') {
                out.append("&apos;");
            } else if (msg == '\n') {
                out.append("&#xA");
            } else if (msg == '\t') {
                out.append("&#x9");
            } else {
                out.append(msg);
            }
        } else {
            out.append(msg);
        }
    }

    public static void writeXML(Writer out, String msg) throws IOException {
        XMLUtil.writeXML(out, msg, true);
    }

    public static void writeXML(Writer out, String msg, boolean attribute) throws IOException {
        if (msg == null) {
            return;
        }
        XMLUtil.appendLine(out, msg, attribute);
    }

    public static void writeXML(Writer out, char msg, boolean attribute) throws IOException {
        if (msg == '&') {
            out.write("&amp;");
        } else if (msg == '<') {
            out.write("&lt;");
        } else if (msg == '>') {
            out.write("&gt;");
        } else if (attribute) {
            if (msg == '\"') {
                out.write("&quot;");
            } else if (msg == '\'') {
                out.write("&apos;");
            } else if (msg == '\n') {
                out.write("&#xA;");
            } else if (msg == '\t') {
                out.write("&#x9;");
            } else {
                out.write(msg);
            }
        } else {
            out.write(msg);
        }
    }

    public static boolean shouldEscape(char c) {
        if (c == '&') {
            return true;
        }
        if (c == '<') {
            return true;
        }
        return c == '>';
    }

    public static boolean shouldEscape(String s) {
        if (s == null) {
            return false;
        }
        int msgLength = s.length();
        for (int i = 0; i < msgLength; ++i) {
            char c = s.charAt(i);
            if (!XMLUtil.shouldEscape(c)) continue;
            return true;
        }
        return false;
    }

    public static void printXML(Writer out, String msg) throws IOException {
        XMLUtil.printXML(out, msg, true);
    }

    public static void printXML(Writer out, String msg, boolean attribute) throws IOException {
        if (msg == null) {
            return;
        }
        XMLUtil.appendLine(out, msg, attribute);
    }

    private static void appendLine(StringBuffer out, String msg, boolean attribute) {
        out.append(XMLUtil.convertChars(msg, attribute));
    }

    private static void appendLine(Writer out, String msg, boolean attribute) throws IOException {
        out.write(XMLUtil.convertChars(msg, attribute));
    }

    private static String convertChars(String msg, boolean attribute) {
        String result = msg;
        if (msg.indexOf("&") >= 0) {
            result = result.replaceAll("&", "&amp;");
        }
        if (msg.indexOf("<") >= 0) {
            result = result.replaceAll("<", "&lt;");
        }
        if (msg.indexOf(">") >= 0) {
            result = result.replaceAll(">", "&gt;");
        }
        if (attribute) {
            if (msg.indexOf("\"") >= 0) {
                result = result.replaceAll("\"", "&quot;");
            }
            if (msg.indexOf("'") >= 0) {
                result = result.replaceAll("'", "&apos;");
            }
            if (msg.indexOf("\n") >= 0) {
                result = result.replaceAll("\n", "&#xA");
            }
            if (msg.indexOf("\t") >= 0) {
                result = result.replaceAll("\t", "&#x9");
            }
        }
        return result;
    }

    public static void printXML(Writer out, char msg, boolean attribute) throws IOException {
        if (msg == '&') {
            out.write("&amp;");
        } else if (msg == '<') {
            out.write("&lt;");
        } else if (msg == '>') {
            out.write("&gt;");
        } else if (attribute) {
            if (msg == '\"') {
                out.write("&quot;");
            } else if (msg == '\'') {
                out.write("&apos;");
            } else if (msg == '\n') {
                out.write("&#xA;");
            } else if (msg == '\t') {
                out.write("&#x9;");
            } else {
                out.write(msg);
            }
        } else {
            out.write(msg);
        }
    }

    protected static String getDocTypeName(Document doc) {
        NodeList children = doc.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (!(node instanceof DocumentType)) continue;
            DocumentType docType = (DocumentType)node;
            return docType.getName();
        }
        Element rootNode = doc.getDocumentElement();
        return rootNode.getNodeName();
    }

    public static void reindent(Document doc, String indent) {
        XMLUtil.reindent(doc, doc, -1, indent);
    }

    public static boolean reindent(Document doc, Node node, int level, String indent) {
        String nodeValue = node.getNodeValue();
        boolean hasOnlyWhitespaceTextChildren = true;
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            if (XMLUtil.reindent(doc, children.item(i), level + 1, indent)) continue;
            hasOnlyWhitespaceTextChildren = false;
        }
        if (hasOnlyWhitespaceTextChildren && level >= 0 && length > 0) {
            StringBuffer idealWhitespaceBuf = new StringBuffer();
            XMLUtil.printLevel(idealWhitespaceBuf, level, indent);
            String idealFinalWhitespace = "\n" + idealWhitespaceBuf.toString().intern();
            XMLUtil.printLevel(idealWhitespaceBuf, 1, indent);
            String idealChildWhitespace = "\n" + idealWhitespaceBuf.toString().intern();
            if (length > 1 && !(children.item(length - 1) instanceof Text)) {
                node.appendChild(doc.createTextNode(idealFinalWhitespace));
                ++length;
            }
            boolean shouldBeTextNode = true;
            for (int i = 0; i < length; ++i) {
                Text textNode;
                String childNodeValue;
                Node childNode = children.item(i);
                boolean isTextNode = childNode instanceof Text;
                if (shouldBeTextNode) {
                    if (isTextNode) {
                        childNodeValue = childNode.getNodeValue().intern();
                        if (length == 1) continue;
                        textNode = (Text)childNode;
                        if (i == length - 1) {
                            if (idealFinalWhitespace != childNodeValue) {
                                if (textNode.getLength() > 0) {
                                    textNode.deleteData(0, textNode.getLength());
                                }
                                textNode.appendData(idealFinalWhitespace);
                            }
                        } else if (idealChildWhitespace != childNodeValue) {
                            textNode.deleteData(0, textNode.getLength());
                            textNode.appendData(idealChildWhitespace);
                        }
                        shouldBeTextNode ^= true;
                        continue;
                    }
                    if (i == length - 1) {
                        node.insertBefore(doc.createTextNode(idealChildWhitespace), childNode);
                        node.appendChild(doc.createTextNode(idealFinalWhitespace));
                        ++length;
                    } else {
                        node.insertBefore(doc.createTextNode(idealChildWhitespace), childNode);
                    }
                    ++i;
                    ++length;
                    continue;
                }
                if (isTextNode) {
                    node.removeChild(childNode);
                    if (--i != --length - 1 || i < 0 || idealFinalWhitespace == (childNodeValue = (childNode = children.item(i)).getNodeValue().intern())) continue;
                    textNode = (Text)childNode;
                    if (textNode.getLength() > 0) {
                        textNode.deleteData(0, textNode.getLength());
                    }
                    textNode.appendData(idealFinalWhitespace);
                    continue;
                }
                shouldBeTextNode ^= true;
            }
        }
        if (node instanceof Text) {
            if (nodeValue == null) {
                return true;
            }
            return nodeValue.trim().equals("");
        }
        return true;
    }

    protected static void printLevel(StringBuffer out, int level, String indent) {
        for (int i = 0; i < level; ++i) {
            out.append(indent);
        }
    }

    public static Locator findLocationXPath(InputSource in, String xpathExpr) throws IOException, SAXException {
        XMLReader parser;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            parser = spf.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        XPathLocator locator = new XPathLocator(xpathExpr);
        parser.setContentHandler(locator);
        parser.parse(in);
        return locator.getDocumentLocator();
    }

    public static boolean isAttrContent(int i) {
        if (i < 9) {
            return false;
        }
        return i <= 9 || i >= 32;
    }

    private static class XPathLocator
    extends DefaultHandler
    implements ContentHandler {
        private String xpathExpr;
        private String[] xpathParts;
        private int partNum;
        private String desiredElementName;
        private int desiredPosition;
        private boolean isAttribute;
        private Locator locator = null;
        private Locator resultLocator = null;

        public XPathLocator(String xpathExpr) {
            xpathExpr = xpathExpr.trim();
            if (xpathExpr.startsWith("/")) {
                xpathExpr = xpathExpr.substring(1, xpathExpr.length());
            }
            this.xpathExpr = xpathExpr;
            this.xpathParts = xpathExpr.split("/");
            this.partNum = 0;
            this.setElementName();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setElementName() {
            this.desiredElementName = this.xpathParts[this.partNum].trim();
            this.desiredPosition = 0;
            this.isAttribute = false;
            int startPos = this.desiredElementName.indexOf(91);
            int endPos = this.desiredElementName.indexOf(93);
            if (startPos >= 0) {
                if (endPos < 0) {
                    throw new IllegalArgumentException("XPath subexpression (" + this.desiredElementName + ") is missing an ending ']'.");
                }
                String subExpr = this.desiredElementName.substring(startPos + 1, endPos).trim();
                this.desiredElementName = this.desiredElementName.substring(0, startPos);
                if (subExpr.startsWith("position()=")) {
                    this.desiredPosition = Integer.parseInt(subExpr.substring(11, subExpr.length()));
                    return;
                } else {
                    boolean allDigits = subExpr.length() > 0;
                    for (int i = 0; i < subExpr.length(); ++i) {
                        if (Character.isDigit(subExpr.charAt(i))) continue;
                        allDigits = false;
                        break;
                    }
                    if (!allDigits) throw new UnsupportedOperationException("XPath (" + subExpr + " in " + this.xpathExpr + ") not supported.");
                    this.desiredPosition = Integer.parseInt(subExpr);
                }
                return;
            } else {
                if (!this.desiredElementName.startsWith("@")) return;
                this.isAttribute = true;
                this.desiredElementName = this.desiredElementName.substring(1, this.desiredElementName.length());
            }
        }

        private boolean foundGotoNext() {
            ++this.partNum;
            if (this.partNum >= this.xpathParts.length) {
                this.resultLocator = new LocatorImpl(this.locator);
                return true;
            }
            this.setElementName();
            return false;
        }

        public Locator getDocumentLocator() {
            return this.resultLocator;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
            if (this.resultLocator != null) {
                return;
            }
            if (this.desiredElementName.equals(localName) || this.desiredElementName.equals(rawName)) {
                if (this.desiredPosition == 0) {
                    if (!this.foundGotoNext() && this.isAttribute) {
                        int size = attrs.getLength();
                        for (int i = 0; i < size; ++i) {
                            if (!this.desiredElementName.equals(attrs.getLocalName(i)) && !this.desiredElementName.equals(attrs.getQName(i))) continue;
                            this.foundGotoNext();
                            return;
                        }
                    }
                } else {
                    --this.desiredPosition;
                }
            }
        }
    }

    public static class DOMWriter {
        private Writer out;
        private boolean writeCData = false;
        private String docTypePublic;
        private String docTypeSystem;

        public void setWriter(Writer out) {
            this.out = out;
        }

        public void setWriteCData(boolean value) {
            this.writeCData = value;
        }

        public void setDocTypePublic(String value) {
            this.docTypePublic = value;
        }

        public void setDocTypeSystem(String value) {
            this.docTypeSystem = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(File f, Document document) throws IOException {
            FileOutputStream fout = new FileOutputStream(f);
            try {
                this.write(fout, document);
            }
            finally {
                ((OutputStream)fout).close();
            }
        }

        public void write(OutputStream os, Document document) throws IOException {
            this.write(os, null, document);
        }

        public void write(OutputStream os, String encoding, Document document) throws IOException {
            if (encoding == null) {
                encoding = "UTF-8";
            }
            this.out = new BufferedWriter(new OutputStreamWriter(os, encoding));
            this.write(document, encoding);
        }

        public void write(Document document) throws IOException {
            this.write(document, null);
        }

        public void write(Document document, String encoding) throws IOException {
            this.write(document, encoding, true);
        }

        public void write(Document document, String encoding, boolean writeHeader) throws IOException {
            Node node;
            int i;
            if (writeHeader) {
                this.out.write("<?xml version=\"1.0\"");
                if (encoding != null) {
                    this.out.write(" encoding=\"" + encoding + "\"?>\n");
                } else {
                    this.out.write(" encoding=\"UTF-8\"?>\n");
                }
            }
            if (this.docTypePublic != null || this.docTypeSystem != null) {
                String docName = XMLUtil.getDocTypeName(document);
                DocumentType docType = document.getDoctype();
                NamedNodeMap entities = null;
                if (docType != null) {
                    entities = docType.getEntities();
                }
                this.write(docName, this.docTypePublic, this.docTypeSystem, entities);
                this.out.write("\n");
            }
            NodeList children = document.getChildNodes();
            int length = children.getLength();
            for (i = 0; i < length; ++i) {
                node = children.item(i);
                if (!(node instanceof DocumentType)) continue;
                this.write(node);
                this.out.write("\n");
            }
            for (i = 0; i < length; ++i) {
                node = children.item(i);
                if (node instanceof DocumentType) continue;
                this.write(node);
                this.out.write("\n");
            }
            this.out.flush();
        }

        public void write(Node node) throws IOException {
            boolean needsReturnBetweenChildren = false;
            NodeList children = node.getChildNodes();
            if (node instanceof Element) {
                this.out.write("<" + node.getNodeName());
                this.write(node.getAttributes());
                if (children.getLength() == 0 || children.getLength() == 1 && children.item(0) instanceof Text && "".equals(children.item(0).getNodeValue())) {
                    this.out.write("/>");
                    return;
                }
                this.out.write(">");
            } else if (node instanceof Text) {
                this.printXML(node.getNodeValue(), false);
            } else if (node instanceof Document) {
                needsReturnBetweenChildren = true;
            } else if (node instanceof DocumentType) {
                this.write((DocumentType)node);
            } else if (node instanceof Comment) {
                this.write((Comment)node);
            } else if (node instanceof Entity) {
                this.write((Entity)node);
            } else if (node instanceof ProcessingInstruction) {
                this.write((ProcessingInstruction)node);
            } else {
                System.err.println("! schema2beans found unknown node type in DOM graph:");
                System.err.println("write: node.getClass=" + node.getClass() + " node=" + node);
                System.err.println("write: nodename=" + node.getNodeName() + " nodevalue=" + node.getNodeValue());
                System.err.println("write: getAttributes=" + node.getAttributes());
            }
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                this.write(children.item(i));
                if (!needsReturnBetweenChildren) continue;
                this.out.write("\n");
            }
            if (node instanceof Element) {
                this.out.write("</" + node.getNodeName() + ">");
            }
        }

        protected void write(DocumentType docType) throws IOException {
            if (this.docTypePublic != null || this.docTypeSystem != null) {
                return;
            }
            this.write(docType.getName(), docType.getPublicId(), docType.getSystemId(), docType.getEntities());
        }

        protected void write(String docName, String publicId, String systemId, NamedNodeMap entities) throws IOException {
            int length;
            this.out.write("<!DOCTYPE " + docName);
            if (publicId != null) {
                this.out.write(" PUBLIC \"");
                XMLUtil.printXML(this.out, publicId);
                this.out.write("\"");
                if (systemId == null) {
                    systemId = "SYSTEM";
                }
            }
            if (systemId != null) {
                this.out.write(" \"");
                XMLUtil.printXML(this.out, systemId);
                this.out.write("\"");
            }
            if (entities != null && (length = entities.getLength()) > 0) {
                this.out.write(" [");
                for (int i = 0; i < length; ++i) {
                    Node node = entities.item(i);
                    this.write(node);
                }
                this.out.write("]");
            }
            this.out.write(">");
        }

        protected void write(Comment comment) throws IOException {
            this.out.write("<!--");
            String text = comment.getNodeValue();
            int pos = text.indexOf("--");
            while (pos >= 0) {
                this.out.write(text.substring(0, pos));
                this.out.write("&#x2d;&#x2d;");
                text = text.substring(pos + 2, text.length());
                pos = text.indexOf("--");
            }
            this.out.write(text);
            this.out.write("-->");
        }

        protected void write(Entity entity) throws IOException {
            this.out.write("<!ENTITY " + entity.getNodeName());
            this.out.write(" UNKNOWN>");
        }

        protected void write(ProcessingInstruction pi) throws IOException {
            if ("xml".equals(pi.getTarget())) {
                return;
            }
            this.out.write("<?" + pi.getTarget() + " " + pi.getData() + "?>");
        }

        protected void write(NamedNodeMap nodes) throws IOException {
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nodes.item(i);
                this.out.write(" ");
                this.out.write(node.getNodeName());
                this.out.write("=\"");
                XMLUtil.printXML(this.out, node.getNodeValue());
                this.out.write("\"");
            }
        }

        protected void printXML(String msg, boolean attribute) throws IOException {
            if (this.writeCData && msg.indexOf("]]>") < 0) {
                boolean shouldEscape = XMLUtil.shouldEscape(msg);
                if (shouldEscape) {
                    this.out.write("<![CDATA[");
                }
                this.out.write(msg);
                if (shouldEscape) {
                    this.out.write("]]>");
                }
            } else {
                XMLUtil.printXML(this.out, msg, attribute);
            }
        }
    }
}

