/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import org.glassfish.api.ActionReport;

public interface AdminCommandState {
    public static final String EVENT_STATE_CHANGED = "AdminCommandState/stateChanged";

    default public boolean isJobStillActive() {
        return State.PREPARED.equals((Object)this.getState()) || State.RUNNING.equals((Object)this.getState()) || State.RUNNING_RETRYABLE.equals((Object)this.getState());
    }

    public State getState();

    public ActionReport getActionReport();

    public boolean isOutboundPayloadEmpty();

    public String getId();

    public String getName();

    public static enum State {
        PREPARED,
        RUNNING,
        COMPLETED,
        RECORDED,
        RUNNING_RETRYABLE,
        FAILED_RETRYABLE,
        REVERTING,
        REVERTED;


        public static boolean isAllowedTransition(State from, State to) {
            switch (from) {
                case PREPARED: {
                    return to == RUNNING;
                }
                case RUNNING: {
                    return to == COMPLETED || to == FAILED_RETRYABLE || to == REVERTING;
                }
                case COMPLETED: {
                    return to == RECORDED;
                }
                case RECORDED: {
                    return false;
                }
                case RUNNING_RETRYABLE: {
                    return to == COMPLETED || to == FAILED_RETRYABLE || to == REVERTING;
                }
                case FAILED_RETRYABLE: {
                    return to == RUNNING_RETRYABLE || to == REVERTING;
                }
                case REVERTING: {
                    return to == REVERTED;
                }
                case REVERTED: {
                    return false;
                }
            }
            throw new IllegalArgumentException("Unknown state: " + String.valueOf((Object)from));
        }
    }
}

