/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emfforms.common.RankingHelper;
import org.eclipse.emfforms.spi.core.services.segments.DmrSegmentGenerator;
import org.eclipse.emfforms.spi.core.services.segments.EMFFormsSegmentGenerator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="SegmentGeneratorService")
public class SegmentGeneratorService
implements EMFFormsSegmentGenerator {
    private static final RankingHelper<DmrSegmentGenerator> RANKING_HELPER = new RankingHelper(DmrSegmentGenerator.class, Double.NEGATIVE_INFINITY, Double.valueOf(Double.NEGATIVE_INFINITY));
    private final List<DmrSegmentGenerator> segmentGenerators = new LinkedList<DmrSegmentGenerator>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void addDmrSegmentGenerator(DmrSegmentGenerator segmentGenerator) {
        this.segmentGenerators.add(segmentGenerator);
    }

    void removeDmrSegmentGenerator(DmrSegmentGenerator segmentGenerator) {
        this.segmentGenerators.remove(segmentGenerator);
    }

    @Override
    public List<VDomainModelReferenceSegment> generateSegments(VDomainModelReference reference) {
        Assert.create((Object)reference).notNull();
        DmrSegmentGenerator bestGenerator = (DmrSegmentGenerator)RANKING_HELPER.getHighestRankingElement(this.segmentGenerators, generator -> generator.isApplicable(reference));
        if (bestGenerator == null) {
            throw new IllegalStateException(String.format("There is no applicable DmrSegmentConverter for %s. Please register a suitable DmrSegmentConverter.", reference));
        }
        return bestGenerator.generateSegments(reference);
    }
}

