/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.notifications.AbstractNotificationPopup;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;
import org.osgi.service.prefs.BackingStoreException;

public class ViewsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String E4_THEME_EXTENSION_POINT = "org.eclipse.e4.ui.css.swt.theme";
    private IThemeEngine engine;
    private ComboViewer themeIdCombo;
    private ControlDecoration themeComboDecorator;
    private ITheme currentTheme;
    private String defaultTheme;
    private Button useRoundTabs;
    private Button enableMru;
    private Button useColoredLabels;
    private ComboViewer colorsAndFontsThemeCombo;
    private ControlDecoration colorFontsDecorator;
    private ColorsAndFontsTheme currentColorsAndFontsTheme;
    private Map<String, String> themeAssociations;
    private boolean highContrastMode;
    private Button themingEnabled;
    private NotificationPopUp notificationPopUp;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite comp = new Composite(parent, 0);
        this.themingEnabled = this.createCheckButton(comp, WorkbenchMessages.ThemingEnabled, this.engine != null);
        if (this.engine == null) {
            GridLayout layout = new GridLayout(1, false);
            layout.horizontalSpacing = 10;
            comp.setLayout((Layout)layout);
            this.createThemeIndependentComposits(comp);
            return comp;
        }
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        comp.setLayout((Layout)layout);
        new Label(comp, 0).setText(WorkbenchMessages.ViewsPreferencePage_Theme);
        this.highContrastMode = parent.getDisplay().getHighContrast();
        this.themeIdCombo = new ComboViewer(comp, 8);
        this.themeIdCombo.setLabelProvider((IBaseLabelProvider)LabelProvider.createTextProvider(element -> ((ITheme)element).getLabel()));
        this.themeIdCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.themeIdCombo.setInput(this.getCSSThemes(this.highContrastMode));
        this.themeIdCombo.getCombo().setEnabled(!this.highContrastMode);
        this.themeIdCombo.getControl().setLayoutData((Object)new GridData(768));
        this.currentTheme = this.engine.getActiveTheme();
        if (this.currentTheme != null) {
            this.themeIdCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentTheme));
        }
        this.themeComboDecorator = new ControlDecoration((Control)this.themeIdCombo.getCombo(), 16512);
        this.themeIdCombo.addSelectionChangedListener(event -> {
            ITheme selection = this.getSelectedTheme();
            if (!selection.equals(this.currentTheme)) {
                this.themeComboDecorator.setDescriptionText(WorkbenchMessages.ThemeChangeWarningText);
                Image decorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
                this.themeComboDecorator.setImage(decorationImage);
                this.themeComboDecorator.show();
            } else {
                this.themeComboDecorator.hide();
            }
            this.selectColorsAndFontsTheme(this.getColorAndFontThemeIdByThemeId(selection.getId()));
        });
        this.currentColorsAndFontsTheme = this.getCurrentColorsAndFontsTheme();
        this.createColorsAndFontsThemeCombo(comp);
        this.createThemeIndependentComposits(comp);
        if (this.currentTheme != null) {
            String colorsAndFontsThemeId = this.getColorAndFontThemeIdByThemeId(this.currentTheme.getId());
            if (colorsAndFontsThemeId != null && !this.currentColorsAndFontsTheme.getId().equals(colorsAndFontsThemeId)) {
                colorsAndFontsThemeId = this.currentColorsAndFontsTheme.getId();
            }
            this.selectColorsAndFontsTheme(colorsAndFontsThemeId);
        }
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    private void createThemeIndependentComposits(Composite comp) {
        this.createUseRoundTabs(comp);
        this.createColoredLabelsPref(comp);
        this.createEnableMruPref(comp);
    }

    private List<ITheme> getCSSThemes(boolean highContrastMode) {
        ArrayList<ITheme> themes = new ArrayList<ITheme>();
        for (ITheme theme : this.engine.getThemes()) {
            if (!highContrastMode && !Util.isGtk() && theme.getId().equals("org.eclipse.e4.ui.css.theme.high-contrast")) continue;
            themes.add(theme);
        }
        Collator collator = Collator.getInstance(Locale.getDefault());
        themes.sort((t1, t2) -> collator.compare(t1.getLabel(), t2.getLabel()));
        return themes;
    }

    private void createColoredLabelsPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.useColoredLabels = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_useColoredLabels, apiStore.getBoolean("USE_COLORED_LABELS"));
    }

    private Button createCheckButton(Composite composite, String text, boolean selection) {
        Button button = new Button(composite, 32);
        GridData data = new GridData(1, 0x1000000, false, false, 2, 1);
        button.setLayoutData((Object)data);
        button.setText(text);
        button.setSelection(selection);
        return button;
    }

    private Label createLabel(Composite composite, String text) {
        Label label = new Label(composite, 0);
        GridData data = new GridData(1, 0x1000000, false, false, 2, 1);
        label.setLayoutData((Object)data);
        label.setText(text);
        return label;
    }

    protected void createUseRoundTabs(Composite composite) {
        IEclipsePreferences prefs = this.getSwtRendererPreferences();
        boolean enabled = prefs.getBoolean("USE_ROUND_TABS", false);
        this.useRoundTabs = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_useRoundTabs, enabled);
    }

    protected void createEnableMruPref(Composite composite) {
        this.createLabel(composite, "");
        this.createLabel(composite, WorkbenchMessages.ViewsPreference_visibleTabs_description);
        IEclipsePreferences prefs = this.getSwtRendererPreferences();
        boolean defaultValue = this.getDefaultMRUValue();
        boolean actualValue = prefs.getBoolean("enableMRU", defaultValue);
        this.enableMru = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_enableMRU, actualValue);
    }

    private ITheme getSelectedTheme() {
        return (ITheme)this.themeIdCombo.getStructuredSelection().getFirstElement();
    }

    @Override
    public void init(IWorkbench workbench) {
        MApplication application = (MApplication)workbench.getService(MApplication.class);
        IEclipseContext context = application.getContext();
        this.defaultTheme = (String)context.get("cssTheme");
        this.engine = (IThemeEngine)context.get(IThemeEngine.class);
    }

    public boolean performOk() {
        ITheme theme;
        if (this.engine != null && (theme = this.getSelectedTheme()) != null) {
            this.engine.setTheme(this.getSelectedTheme(), !this.highContrastMode);
        }
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        apiStore.setValue("USE_COLORED_LABELS", this.useColoredLabels.getSelection());
        IEclipsePreferences prefs = this.getSwtRendererPreferences();
        prefs.putBoolean("enableMRU", this.enableMru.getSelection());
        boolean themingEnabledChanged = prefs.getBoolean("themeEnabled", true) ^ this.themingEnabled.getSelection();
        prefs.putBoolean("themeEnabled", this.themingEnabled.getSelection());
        prefs.putBoolean("USE_ROUND_TABS", this.useRoundTabs.getSelection());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            WorkbenchPlugin.log("Failed to set SWT renderer preferences", e);
        }
        if (this.engine != null) {
            ColorsAndFontsTheme colorsAndFontsTheme;
            boolean colorsAndFontsThemeChanged;
            ITheme theme2 = this.getSelectedTheme();
            boolean themeChanged = theme2 != null && !theme2.equals(this.currentTheme);
            boolean bl = colorsAndFontsThemeChanged = !PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getId().equals(this.currentColorsAndFontsTheme.getId());
            if (theme2 != null) {
                this.currentTheme = theme2;
            }
            if ((colorsAndFontsTheme = this.getSelectedColorsAndFontsTheme()) != null) {
                this.currentColorsAndFontsTheme = colorsAndFontsTheme;
            }
            this.themeComboDecorator.hide();
            this.colorFontsDecorator.hide();
            if ((themeChanged || colorsAndFontsThemeChanged) && this.notificationPopUp == null) {
                this.notificationPopUp = new NotificationPopUp(this.getShell().getDisplay());
                this.notificationPopUp.open();
            }
        }
        if (themingEnabledChanged && this.notificationPopUp == null) {
            this.notificationPopUp = new NotificationPopUp(this.getShell().getDisplay());
            this.notificationPopUp.open();
        }
        return super.performOk();
    }

    private IEclipsePreferences getSwtRendererPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.e4.ui.workbench.renderers.swt");
    }

    private boolean getDefaultMRUValue() {
        return this.getSwtRendererPreferences().getBoolean("enableMRUDefault", true);
    }

    private void setColorsAndFontsTheme(ColorsAndFontsTheme theme) {
        org.eclipse.ui.themes.ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        if (theme != null && !currentTheme.getId().equals(theme.getId())) {
            PlatformUI.getWorkbench().getThemeManager().setCurrentTheme(theme.getId());
        }
    }

    protected void performDefaults() {
        if (this.engine != null) {
            this.setColorsAndFontsTheme(this.currentColorsAndFontsTheme);
            this.engine.setTheme(this.defaultTheme, true);
            if (this.engine.getActiveTheme() != null) {
                this.themeIdCombo.setSelection((ISelection)new StructuredSelection((Object)this.engine.getActiveTheme()));
            }
        }
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.useColoredLabels.setSelection(apiStore.getDefaultBoolean("USE_COLORED_LABELS"));
        this.useRoundTabs.setSelection(false);
        this.enableMru.setSelection(this.getDefaultMRUValue());
        super.performDefaults();
    }

    public boolean performCancel() {
        if (this.engine != null) {
            this.setColorsAndFontsTheme(this.currentColorsAndFontsTheme);
            if (this.currentTheme != null) {
                this.engine.setTheme(this.currentTheme, false);
            }
        }
        return super.performCancel();
    }

    private void createColorsAndFontsThemeCombo(Composite composite) {
        new Label(composite, 0).setText(WorkbenchMessages.ViewsPreference_currentTheme);
        this.colorsAndFontsThemeCombo = new ComboViewer(composite, 8);
        this.colorsAndFontsThemeCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.colorsAndFontsThemeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ColorsAndFontsTheme)element).getLabel();
            }
        });
        this.colorFontsDecorator = new ControlDecoration((Control)this.colorsAndFontsThemeCombo.getCombo(), 16512);
        this.colorsAndFontsThemeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.colorsAndFontsThemeCombo.setInput(this.getColorsAndFontsThemes());
        this.colorsAndFontsThemeCombo.getControl().setLayoutData((Object)new GridData(768));
        this.colorsAndFontsThemeCombo.addSelectionChangedListener(event -> {
            ColorsAndFontsTheme colorsAndFontsTheme = this.getSelectedColorsAndFontsTheme();
            if (!colorsAndFontsTheme.equals(this.currentColorsAndFontsTheme)) {
                Image decorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
                this.colorFontsDecorator.setImage(decorationImage);
                this.colorFontsDecorator.setDescriptionText(WorkbenchMessages.ThemeChangeWarningText);
                this.colorFontsDecorator.show();
            } else {
                this.colorFontsDecorator.hide();
            }
            this.setColorsAndFontsTheme(colorsAndFontsTheme);
        });
    }

    private void selectColorsAndFontsTheme(String colorAndFontThemeId) {
        if (colorAndFontThemeId == null) {
            colorAndFontThemeId = this.currentColorsAndFontsTheme.getId();
        }
        for (ColorsAndFontsTheme theme : (List)this.colorsAndFontsThemeCombo.getInput()) {
            if (!theme.getId().equals(colorAndFontThemeId)) continue;
            StructuredSelection selection = new StructuredSelection((Object)theme);
            this.colorsAndFontsThemeCombo.setSelection((ISelection)selection);
            break;
        }
    }

    private String getColorAndFontThemeIdByThemeId(String themeId) {
        String result;
        if (this.themeAssociations == null) {
            this.themeAssociations = this.createThemeAssociations();
        }
        if ((result = this.themeAssociations.get(themeId)) == null) {
            for (Map.Entry<String, String> entry : this.themeAssociations.entrySet()) {
                if (!themeId.startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return result;
    }

    private Map<String, String> createThemeAssociations() {
        HashMap<String, String> result = new HashMap<String, String>();
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(E4_THEME_EXTENSION_POINT);
        IExtension[] iExtensionArray = extPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equals("themeAssociation")) {
                    String themeId = ce.getAttribute("themeId");
                    String osVersion = ce.getAttribute("os_version");
                    result.put(osVersion != null ? String.valueOf(themeId) + osVersion : themeId, ce.getAttribute("colorAndFontId"));
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private List<ColorsAndFontsTheme> getColorsAndFontsThemes() {
        ArrayList<ColorsAndFontsTheme> result = new ArrayList<ColorsAndFontsTheme>();
        org.eclipse.ui.themes.ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        IThemeDescriptor[] descs = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes();
        String defaultThemeString = PlatformUI.getWorkbench().getThemeManager().getTheme("org.eclipse.ui.defaultTheme").getLabel();
        if (currentTheme.getId().equals("org.eclipse.ui.defaultTheme")) {
            defaultThemeString = NLS.bind((String)WorkbenchMessages.ViewsPreference_currentThemeFormat, (Object[])new Object[]{defaultThemeString});
        }
        result.add(new ColorsAndFontsTheme("org.eclipse.ui.defaultTheme", defaultThemeString));
        IThemeDescriptor[] iThemeDescriptorArray = descs;
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            IThemeDescriptor themeDescriptor = iThemeDescriptorArray[n2];
            String themeString = themeDescriptor.getName();
            if (themeDescriptor.getId().equals(currentTheme.getId())) {
                themeString = NLS.bind((String)WorkbenchMessages.ViewsPreference_currentThemeFormat, (Object[])new Object[]{themeString});
            }
            result.add(new ColorsAndFontsTheme(themeDescriptor.getId(), themeString));
            ++n2;
        }
        return result;
    }

    private ColorsAndFontsTheme getSelectedColorsAndFontsTheme() {
        return (ColorsAndFontsTheme)this.colorsAndFontsThemeCombo.getStructuredSelection().getFirstElement();
    }

    private ColorsAndFontsTheme getCurrentColorsAndFontsTheme() {
        org.eclipse.ui.themes.ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        return new ColorsAndFontsTheme(theme.getId(), theme.getLabel());
    }

    private static class ColorsAndFontsTheme {
        private String label;
        private String id;

        public ColorsAndFontsTheme(String id, String label) {
            this.id = id;
            this.label = label;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ColorsAndFontsTheme other = (ColorsAndFontsTheme)obj;
            return Objects.equals(this.id, other.id);
        }
    }

    private class NotificationPopUp
    extends AbstractNotificationPopup {
        public NotificationPopUp(Display display) {
            super(display);
            this.setDelayClose(0L);
            this.setParentShell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        }

        protected String getPopupShellTitle() {
            return WorkbenchMessages.ThemeChangeWarningTitle;
        }

        protected void createContentArea(Composite parent) {
            parent.setLayout((Layout)new RowLayout());
            Link link = new Link(parent, 64);
            link.setText(WorkbenchMessages.ThemeChangeWarningHyperlinkedText);
            link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                boolean bl = PlatformUI.getWorkbench().restart(true);
            }));
        }
    }
}

