/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.util.Optional;
import org.eclipse.comma.monitoring.lib.CDispatcher;
import org.eclipse.comma.monitoring.lib.CFactory;
import org.eclipse.comma.monitoring.lib.CFileJsonTraceReader;
import org.eclipse.comma.monitoring.lib.CFileTraceReader;
import org.eclipse.comma.monitoring.lib.CMonitoringContext;
import org.eclipse.comma.monitoring.lib.CRecordsTracker;
import org.eclipse.comma.monitoring.lib.CTraceResults;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public class CTracePlayer {
    private String tracePath;
    private CFileTraceReader traceReader = null;
    private CFileJsonTraceReader jsonTraceReader = null;
    private CDispatcher dispatcher;
    private CTraceResults result;
    private CFactory factory;
    private CRecordsTracker recordsTracker;

    public CTracePlayer(CMonitoringContext context, String tracePath) {
        this.tracePath = tracePath;
        this.factory = context.getFactory();
        this.dispatcher = this.factory.createDispatcher(context);
        this.result = new CTraceResults(tracePath);
        this.recordsTracker = this.factory.getRecordsTracker();
    }

    public void run() {
        String formatOfEventFile = this.getEventFormatOf(this.tracePath);
        if (formatOfEventFile.equals("jsonl")) {
            try {
                this.jsonTraceReader = new CFileJsonTraceReader(this.tracePath);
                this.jsonTraceReader.processEvents(this.dispatcher, this.result, this.recordsTracker);
                return;
            }
            catch (Exception e) {
                this.handleTraceError(e.getMessage());
                return;
            }
        }
        try {
            this.traceReader = new CFileTraceReader(this.tracePath, this.recordsTracker);
            if (this.traceReader.traceInWrongFormat()) {
                this.handleTraceError("Trace file format error: missing events section");
                return;
            }
            if (this.traceReader.traceHasErrors()) {
                this.handleTraceError("Trace file contains errors: check the error section");
                return;
            }
        }
        catch (Exception e) {
            this.handleTraceError(e.getMessage());
            return;
        }
        try {
            Optional<CObservedMessage> optionalMessage = this.traceReader.readMessage();
            while (optionalMessage.isPresent()) {
                CObservedMessage msg = optionalMessage.get();
                this.dispatcher.consume(msg);
                optionalMessage = this.traceReader.readMessage();
            }
            this.dispatcher.traceEnded();
            this.result.setMonitorResults(this.dispatcher.getResults());
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            if (errorMsg == null) {
                errorMsg = "Error reading from the trace. Line " + this.traceReader.getCurrentLine();
            }
            this.handleTraceError(errorMsg);
            try {
                this.dispatcher.traceEnded();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.result.setMonitorResults(this.dispatcher.getResults());
        }
    }

    public CTraceResults getResults() {
        return this.result;
    }

    private void handleTraceError(String msg) {
        this.result.markTraceError(msg);
    }

    private String getEventFormatOf(String eventFile) {
        return eventFile.substring(eventFile.lastIndexOf(".") + 1);
    }
}

