/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchyCore;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;

class CallSearchResultCollector {
    private Map<String, MethodCall> fCalledMembers = this.createCalledMethodsData();

    public Map<String, MethodCall> getCallers() {
        return this.fCalledMembers;
    }

    protected void addMember(IMember member, IMember calledMember, int start, int end) {
        this.addMember(member, calledMember, start, end, -1);
    }

    protected void addMember(IMember member, IMember calledMember, int start, int end, int lineNumber) {
        if (member != null && calledMember != null && !this.isIgnored(calledMember)) {
            MethodCall methodCall = this.fCalledMembers.get(calledMember.getHandleIdentifier());
            if (methodCall == null) {
                methodCall = new MethodCall(calledMember);
                this.fCalledMembers.put(calledMember.getHandleIdentifier(), methodCall);
            }
            methodCall.addCallLocation(new CallLocation(member, calledMember, start, end, lineNumber));
        }
    }

    protected Map<String, MethodCall> createCalledMethodsData() {
        return new HashMap<String, MethodCall>();
    }

    private boolean isIgnored(IMember enclosingElement) {
        IClasspathEntry classpathEntry;
        String fullyQualifiedName = this.getTypeOfElement(enclosingElement).getFullyQualifiedName();
        if (CallHierarchyCore.getDefault().isFilterTestCode() && (classpathEntry = CallSearchResultCollector.determineClassPathEntry(enclosingElement)) != null && classpathEntry.isTest()) {
            return true;
        }
        return CallHierarchyCore.getDefault().isIgnored(fullyQualifiedName);
    }

    private static IClasspathEntry determineClassPathEntry(Object element) {
        IPackageFragmentRoot packageFragmentRoot;
        if (element instanceof IJavaElement && (packageFragmentRoot = (IPackageFragmentRoot)((IJavaElement)element).getAncestor(3)) != null) {
            try {
                return packageFragmentRoot.getResolvedClasspathEntry();
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    private IType getTypeOfElement(IMember element) {
        if (element.getElementType() == 7) {
            return (IType)element;
        }
        return element.getDeclaringType();
    }
}

