/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingmodel.repository.internal.PathComparator;

public final class Path
implements Comparable<Path> {
    private final String path;

    private Path(String path) {
        this.path = (String)Preconditions.checkNotNull((Object)path);
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public int compareTo(Path other) {
        Preconditions.checkNotNull((Object)other);
        return PathComparator.INSTANCE.compare(this.path, other.path);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Path that = (Path)other;
        return Objects.equal((Object)this.path, (Object)that.path);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path});
    }

    public static Path from(String path) {
        return new Path(path);
    }

    public static enum Comparator implements java.util.Comparator<Path>
    {
        INSTANCE;


        @Override
        public int compare(Path o1, Path o2) {
            return o1.compareTo(o2);
        }
    }
}

