/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.gradle;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.ModelRepositoryProvider;
import com.gradleware.tooling.toolingmodel.repository.SimpleModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.util.List;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.console.ProcessStreamsProvider;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.util.progress.ToolingApiJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public final class LoadEclipseGradleBuildJob
extends ToolingApiJob {
    private final ModelRepositoryProvider modelRepositoryProvider;
    private final ProcessStreamsProvider processStreamsProvider;
    private final FetchStrategy modelFetchStrategy;
    private final ProjectConfiguration configuration;
    private OmniEclipseGradleBuild result;

    public LoadEclipseGradleBuildJob(ModelRepositoryProvider modelRepositoryProvider, ProcessStreamsProvider processStreamsProvider, FetchStrategy modelFetchStrategy, ProjectConfiguration configuration, final FutureCallback<OmniEclipseGradleBuild> resultHandler) {
        super(String.format("Loading tasks of project located at %s", configuration.getRequestAttributes().getProjectDir().getName()));
        this.modelRepositoryProvider = (ModelRepositoryProvider)Preconditions.checkNotNull((Object)modelRepositoryProvider);
        this.processStreamsProvider = (ProcessStreamsProvider)Preconditions.checkNotNull((Object)processStreamsProvider);
        this.modelFetchStrategy = (FetchStrategy)Preconditions.checkNotNull((Object)modelFetchStrategy);
        this.configuration = (ProjectConfiguration)Preconditions.checkNotNull((Object)configuration);
        this.result = null;
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    resultHandler.onSuccess((Object)LoadEclipseGradleBuildJob.this.result);
                } else {
                    resultHandler.onFailure(event.getResult().getException());
                }
            }
        });
    }

    @Override
    protected void runToolingApiJob(IProgressMonitor monitor) throws Exception {
        this.result = this.fetchEclipseGradleBuild(monitor);
    }

    private OmniEclipseGradleBuild fetchEclipseGradleBuild(IProgressMonitor monitor) {
        ProcessStreams stream = this.processStreamsProvider.getBackgroundJobProcessStreams();
        ImmutableList listeners = ImmutableList.of((Object)DelegatingProgressListener.withoutDuplicateLifecycleEvents(monitor));
        TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, stream.getOutput(), stream.getError(), null, (List)listeners, (List)ImmutableList.of(), this.getToken());
        SimpleModelRepository repository = this.modelRepositoryProvider.getModelRepository(this.configuration.getRequestAttributes());
        return repository.fetchEclipseGradleBuild(transientAttributes, this.modelFetchStrategy);
    }

    @Override
    public boolean belongsTo(Object family) {
        return LoadEclipseGradleBuildJob.class.getName().equals(family);
    }
}

