/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui.editors.providers;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.ElementTypeLabelDecorator;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.editor.ExtendedBasicTransactionalFormEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ExtendedColumnLabelProvider
extends ColumnLabelProvider {
    private static final String UPDATE_CHECK_PROBLEM_MARKER = "UPDATE_CHECK_PROBLEM_MARKER";
    private final ExtendedBasicTransactionalFormEditor editor;
    private final TransactionalAdapterFactoryLabelProvider delegate;
    private final ILabelDecorator labelDecorator;

    public ExtendedColumnLabelProvider(ExtendedBasicTransactionalFormEditor editor, TransactionalAdapterFactoryLabelProvider delegate) {
        this.editor = editor;
        this.delegate = delegate;
        this.labelDecorator = new ElementTypeLabelDecorator();
    }

    public String getText(Object element) {
        Object target = element;
        if (element instanceof IStructuredSelection) {
            target = ((IStructuredSelection)element).getFirstElement();
        }
        String text = this.stripTypePrefix(this.delegate.getText(target), target);
        if (this.editor.isShowTypesOfElements()) {
            return this.labelDecorator.decorateText(text, target);
        }
        return text;
    }

    private String stripTypePrefix(String text, Object element) {
        String type;
        if (StringUtils.isBlank((String)text)) {
            return "???";
        }
        String string = type = element instanceof EObject ? ((EObject)element).eClass().getName() : null;
        if (StringUtils.isBlank((String)type)) {
            return text;
        }
        String typeWithBlanks = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)type), (char)' ');
        return StringUtils.removeStart((String)text.trim(), (String)(String.valueOf(typeWithBlanks) + " ")).trim();
    }

    public String getToolTipText(Object element) {
        return this.delegate.getText(element);
    }

    public void addListener(ILabelProviderListener listener) {
        this.delegate.addListener(listener);
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public Color getBackground(Object object) {
        return this.delegate.getBackground(object);
    }

    public Font getFont(Object object) {
        return this.delegate.getFont(object);
    }

    public Color getForeground(Object object) {
        return this.delegate.getForeground(object);
    }

    public Image getImage(Object object) {
        return this.checkForMarkers(object);
    }

    private Image checkForMarkers(Object object) {
        Image image = this.delegate.getImage(object);
        try {
            if (object instanceof EObject) {
                IMarker[] markers = this.getValidationMarkers((EObject)object);
                if (this.isCodePresent(2, markers)) {
                    image = this.addErrorOverlay(image);
                } else if (this.isCodePresent(1, markers)) {
                    image = this.addWarningOverlay(image);
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return image;
    }

    private boolean isCodePresent(int status, IMarker[] markers) {
        boolean result = false;
        int i = -1;
        int len = markers.length;
        while (++i < len) {
            if (markers[i].getAttribute("severity", -1) != status) continue;
            result = true;
            break;
        }
        return result;
    }

    private IMarker[] getValidationMarkers(EObject eObject) throws CoreException {
        IFile resource;
        Job[] jobs = Job.getJobManager().find((Object)UPDATE_CHECK_PROBLEM_MARKER);
        if (jobs.length > 0) {
            try {
                jobs[0].join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if ((resource = EcorePlatformUtil.getFile((EObject)eObject)) == null || !resource.exists()) {
            return new IMarker[0];
        }
        IMarker[] allMarkers = resource.findMarkers(null, true, 2);
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        URI referenceURI = EcoreResourceUtil.getURI((EObject)eObject);
        IMarker[] iMarkerArray = allMarkers;
        int n = allMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            URI currentURI;
            IMarker current = iMarkerArray[n2];
            String currentStringURI = (String)current.getAttribute("uri");
            if (currentStringURI != null && (currentURI = URI.createURI((String)currentStringURI)).equals(referenceURI)) {
                result.add(current);
            }
            ++n2;
        }
        return result.toArray(new IMarker[result.size()]);
    }

    private Image addErrorOverlay(Image image) {
        Point size = new Point(16, 16);
        ImageDescriptor overlay = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR");
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
        imageDescriptorArray[3] = overlay;
        DecorationOverlayIcon deco = new DecorationOverlayIcon(image, imageDescriptorArray, size){};
        ImageRegistry imageRegistry = this.createImageRegistry();
        imageRegistry.put("error", (ImageDescriptor)deco);
        return imageRegistry.get("error");
    }

    private Image addWarningOverlay(Image image) {
        Point size = new Point(16, 16);
        ImageDescriptor overlay = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_WARNING");
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
        imageDescriptorArray[3] = overlay;
        DecorationOverlayIcon deco = new DecorationOverlayIcon(image, imageDescriptorArray, size){};
        ImageRegistry imageRegistry = this.createImageRegistry();
        imageRegistry.put("warning", (ImageDescriptor)deco);
        return imageRegistry.get("warning");
    }

    public boolean isLabelProperty(Object object, String id) {
        return this.delegate.isLabelProperty(object, id);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.delegate.removeListener(listener);
    }

    ImageRegistry createImageRegistry() {
        if (Display.getCurrent() != null) {
            return new ImageRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }
}

