/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.font;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.graphics3d.DisplayListManager;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglFontChar;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.draw3d.util.converter.ColorBufferInfo;
import org.eclipse.draw3d.util.converter.ImageConverter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.lwjgl.opengl.GL11;

public class LwjglFont {
    private static final Logger log = Logger.getLogger(LwjglFont.class.getName());
    private LwjglFontChar[] m_chars;
    private final String m_description;
    private boolean m_disposed = false;
    private final char m_endChar;
    private FontMetrics m_fontMetrics;
    private DisplayListManager m_displayListManager;
    private int m_height;
    private final char m_startChar;
    private int m_tabWidth;
    private int m_textureId = -1;
    private int m_width;

    public LwjglFont(Font i_font, char i_startChar, char i_endChar, boolean i_antiAliased, DisplayListManager i_displayListManager) {
        if (i_font == null) {
            throw new NullPointerException("i_font must not be null");
        }
        if (i_displayListManager == null) {
            throw new NullPointerException("i_displayListManager must not be null");
        }
        this.m_displayListManager = i_displayListManager;
        this.m_displayListManager.interruptDisplayList();
        try {
            this.m_startChar = i_startChar;
            this.m_endChar = i_endChar;
            int numChars = this.m_endChar - this.m_startChar + 1;
            this.m_chars = new LwjglFontChar[numChars];
            Device device = i_font.getDevice();
            Image image = null;
            GC gc = null;
            try {
                image = new Image(device, 1, 1);
                gc = new GC((Drawable)image);
                gc.setFont(i_font);
                this.m_fontMetrics = gc.getFontMetrics();
                this.m_tabWidth = gc.textExtent((String)"\t").x;
                int height = this.m_fontMetrics.getHeight();
                long area = 0L;
                int i = 0;
                while (i < numChars) {
                    char c = (char)(this.m_startChar + i);
                    String s = Character.toString(c);
                    Point cExtent = gc.stringExtent(s);
                    this.m_chars[i] = new LwjglFontChar(c, cExtent.x, height);
                    area += (long)((cExtent.x + 1) * (height + 1));
                    ++i;
                }
                int sideLength = 64;
                int textureArea = 0;
                while ((long)textureArea < area) {
                    textureArea = (sideLength *= 2) * sideLength;
                }
                this.m_width = sideLength;
                this.m_height = sideLength;
                gc.dispose();
                image.dispose();
                image = new Image(device, this.m_width, this.m_height);
                gc = new GC((Drawable)image);
                gc.setTextAntialias(i_antiAliased ? 1 : 0);
                gc.setFont(i_font);
                gc.setForeground(device.getSystemColor(2));
                gc.setBackground(device.getSystemColor(1));
                gc.fillRectangle(image.getBounds());
                int x = 0;
                int y = 0;
                int i2 = 0;
                while (i2 < numChars) {
                    LwjglFontChar fontChar = this.m_chars[i2];
                    int w = fontChar.getWidth() + 1;
                    if (x + w > this.m_width) {
                        x = 0;
                        y += height + 1;
                    }
                    char c = (char)(this.m_startChar + i2);
                    String s = Character.toString(c);
                    gc.drawString(s, x, y);
                    float s1 = (float)x / (float)this.m_width;
                    float t1 = (float)y / (float)this.m_height;
                    float s2 = (float)(x + fontChar.getWidth()) / (float)this.m_width;
                    float t2 = (float)(y + height) / (float)this.m_height;
                    fontChar.setTextureCoords(s1, t1, s2, t2);
                    x += w;
                    ++i2;
                }
                ColorBufferInfo info = new ColorBufferInfo(this.m_width, this.m_height, 6410, 5121, 1);
                ImageConverter converter = ImageConverter.getInstance();
                ByteBuffer buffer = converter.imageToBuffer(image, info, null, false);
                GL11.glPushAttrib((int)262144);
                try {
                    IntBuffer intBuf = Draw3DCache.getIntBuffer((int)1);
                    try {
                        GL11.glGenTextures((IntBuffer)intBuf);
                        this.m_textureId = intBuf.get(0);
                        GL11.glBindTexture((int)3553, (int)this.m_textureId);
                        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
                        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                        GL11.glTexImage2D((int)3553, (int)0, (int)6410, (int)this.m_width, (int)this.m_height, (int)0, (int)6410, (int)5121, (ByteBuffer)buffer);
                        HashMap<LwjglFontChar, 1> requests = new HashMap<LwjglFontChar, 1>(this.m_chars.length);
                        LwjglFontChar[] lwjglFontCharArray = this.m_chars;
                        int n = this.m_chars.length;
                        int n2 = 0;
                        while (n2 < n) {
                            final LwjglFontChar c = lwjglFontCharArray[n2];
                            requests.put(c, new Runnable(){

                                public void run() {
                                    c.render();
                                }
                            });
                            ++n2;
                        }
                        this.m_displayListManager.createDisplayLists(requests);
                    }
                    catch (Throwable throwable) {
                        Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{intBuf});
                        throw throwable;
                    }
                    Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{intBuf});
                }
                finally {
                    GL11.glPopAttrib();
                }
            }
            finally {
                if (gc != null && !gc.isDisposed()) {
                    gc.dispose();
                }
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
            FontData[] fontData = i_font.getFontData();
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < fontData.length) {
                builder.append(fontData[i].getName());
                int style = fontData[i].getStyle();
                if (false) {
                    builder.append(" Normal");
                }
                if ((style & 2) != 0) {
                    builder.append(" Italic");
                }
                if ((style & 1) != 0) {
                    builder.append(" Bold");
                }
                builder.append(" ");
                builder.append(fontData[i].getHeight());
                if (i < fontData.length - 1) {
                    builder.append(", ");
                }
                ++i;
            }
            builder.append(", Antialiasing: ");
            builder.append(i_antiAliased);
            this.m_description = builder.toString();
        }
        finally {
            this.m_displayListManager.resumeDisplayList();
        }
    }

    public void dispose() {
        if (this.m_disposed) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("disposing font " + this);
        }
        if (this.m_textureId != -1) {
            IntBuffer intBuf = Draw3DCache.getIntBuffer((int)1);
            try {
                intBuf.put(0, this.m_textureId);
                intBuf.rewind();
                GL11.glDeleteTextures((IntBuffer)intBuf);
                this.m_textureId = -1;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{intBuf});
                throw throwable;
            }
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{intBuf});
        }
        this.m_chars = null;
        this.m_disposed = true;
    }

    public Point getExtent(String i_string, boolean i_expand) {
        if (this.m_disposed) {
            throw new IllegalStateException("font is disposed");
        }
        if (i_string == null) {
            throw new NullPointerException("i_string must not be null");
        }
        int height = this.m_fontMetrics.getHeight();
        Point extent = new Point(0, height);
        int i = 0;
        while (i < i_string.length()) {
            char c = i_string.charAt(i);
            switch (c) {
                case '\t': {
                    if (!i_expand) break;
                    extent.x += this.m_tabWidth;
                    break;
                }
                case '\n': {
                    if (!i_expand) break;
                    extent.y += height;
                    break;
                }
                default: {
                    int index = c - this.m_startChar;
                    if (index < 0 || index >= this.m_chars.length) break;
                    LwjglFontChar fontChar = this.m_chars[index];
                    extent.x += fontChar.getWidth();
                }
            }
            ++i;
        }
        return extent;
    }

    public int getTextureId() {
        if (this.m_disposed) {
            throw new IllegalStateException("font is disposed");
        }
        return this.m_textureId;
    }

    public FontMetrics getFontMetrics() {
        if (this.m_disposed) {
            throw new IllegalStateException("font is disposed");
        }
        return this.m_fontMetrics;
    }

    public int getLength(String i_string) {
        if (i_string == null) {
            throw new NullPointerException("i_string must not be null");
        }
        int length = 0;
        int i = 0;
        while (i < i_string.length()) {
            char c = i_string.charAt(i);
            int index = c - this.m_startChar;
            if (index >= 0 && index < this.m_chars.length) {
                ++length;
            }
            ++i;
        }
        return length;
    }

    public void renderString(String i_string, IMatrix4f i_transformation, int i_x, int i_y, boolean i_expand, FloatBuffer i_vertexBuffer, FloatBuffer i_coordBuffer) {
        if (this.m_disposed) {
            throw new IllegalStateException("font is disposed");
        }
        if (i_string == null) {
            throw new NullPointerException("i_string must not be null");
        }
        Vector3f p = Draw3DCache.getVector3f();
        try {
            int x = i_x;
            int y = i_y;
            int height = this.m_fontMetrics.getHeight();
            int line = 0;
            int i = 0;
            while (i < i_string.length()) {
                char c = i_string.charAt(i);
                switch (c) {
                    case '\t': {
                        if (!i_expand) break;
                        x += this.m_tabWidth;
                        break;
                    }
                    case '\n': {
                        if (!i_expand) break;
                        y += ++line * height;
                        break;
                    }
                    default: {
                        int index = c - this.m_startChar;
                        if (index < 0 || index >= this.m_chars.length) break;
                        LwjglFontChar fontChar = this.m_chars[index];
                        fontChar.render(i_transformation, x, y, i_vertexBuffer, i_coordBuffer);
                        x += fontChar.getWidth();
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{p});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{p});
    }

    public void renderString(String i_string, int i_x, int i_y, boolean i_expand) {
        if (this.m_disposed) {
            throw new IllegalStateException("font is disposed");
        }
        if (i_string == null) {
            throw new NullPointerException("i_string must not be null");
        }
        GL11.glPushAttrib((int)278528);
        try {
            GL11.glBindTexture((int)3553, (int)this.m_textureId);
            GL11.glTexEnvi((int)8960, (int)8704, (int)3042);
            GL11.glPolygonMode((int)1032, (int)6914);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            try {
                GL11.glTranslatef((float)i_x, (float)i_y, (float)0.0f);
                int height = this.m_fontMetrics.getHeight();
                int line = 0;
                int i = 0;
                while (i < i_string.length()) {
                    char c = i_string.charAt(i);
                    switch (c) {
                        case '\t': {
                            if (!i_expand) break;
                            GL11.glTranslatef((float)this.m_tabWidth, (float)0.0f, (float)0.0f);
                            break;
                        }
                        case '\n': {
                            if (!i_expand) break;
                            GL11.glPopMatrix();
                            GL11.glPushMatrix();
                            GL11.glTranslatef((float)i_x, (float)(i_y + ++line * height), (float)0.0f);
                            break;
                        }
                        default: {
                            int index = c - this.m_startChar;
                            if (index < 0 || index >= this.m_chars.length) break;
                            LwjglFontChar fontChar = this.m_chars[index];
                            this.m_displayListManager.executeDisplayList((Object)fontChar);
                            GL11.glTranslatef((float)fontChar.getWidth(), (float)0.0f, (float)0.0f);
                        }
                    }
                    ++i;
                }
            }
            finally {
                GL11.glPopMatrix();
            }
        }
        finally {
            GL11.glPopAttrib();
        }
    }

    public String toString() {
        return this.m_description;
    }
}

