/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.nonvis;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.TooManyListenersException;
import org.ascape.model.event.ScapeEvent;
import org.ascape.util.PropertyAccessor;
import org.ascape.util.Utility;
import org.ascape.view.nonvis.DataView;

public class DataOutputView
extends DataView {
    private static final long serialVersionUID = 1L;
    private static int numCharsInFileName = 4;
    protected int runCount = 1;
    public static String EOLString = System.getProperty("line.separator");
    int maxPeriods = Integer.MAX_VALUE;
    protected boolean writeHeaders = true;
    protected boolean runHeadersWritten = false;
    protected boolean periodHeadersWritten = false;
    boolean iterationDataInSperateFiles = false;
    protected long startTime;
    protected File runFile;
    private transient FileOutputStream runFileStream;
    protected transient DataOutputStream runDataStream;
    private File periodFile;
    private transient FileOutputStream periodFileStream;
    private transient DataOutputStream periodDataStream;

    public DataOutputView() {
    }

    public DataOutputView(DataOutputStream runDataStream) {
        this();
        this.setRunDataStream(runDataStream);
    }

    public DataOutputView(File file) throws IOException {
        this();
        this.setRunFile(file);
    }

    public DataOutputStream getRunDataStream() {
        return this.runDataStream;
    }

    public void setRunDataStream(DataOutputStream runDataStream) {
        if (this.runDataStream != null) {
            try {
                this.runDataStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.runDataStream = runDataStream;
        this.runHeadersWritten = false;
    }

    public File getRunFile() {
        return this.runFile;
    }

    public void setRunFile(File file) throws IOException {
        this.runFile = file;
        file.createNewFile();
        if (this.runFileStream != null) {
            try {
                this.runFileStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.runFileStream = new FileOutputStream(file);
        this.setRunDataStream(new DataOutputStream(this.runFileStream));
    }

    public DataOutputStream getPeriodDataStream() {
        return this.periodDataStream;
    }

    public void setPeriodDataStream(DataOutputStream periodDataStream) {
        if (this.periodDataStream != null) {
            try {
                this.periodDataStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.periodDataStream = periodDataStream;
        this.periodHeadersWritten = false;
    }

    public File getPeriodFile() {
        return this.periodFile;
    }

    public void setPeriodFile(File file) throws IOException {
        this.periodFile = file;
        file.createNewFile();
        if (this.periodFileStream != null) {
            try {
                this.periodFileStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.periodFileStream = new FileOutputStream(file);
        this.setPeriodDataStream(new DataOutputStream(this.periodFileStream));
    }

    public void writePeriodHeader() throws IOException {
        this.periodDataStream.writeBytes("Run\t");
        this.periodDataStream.writeBytes("Period");
        this.writeStatsHeader(this.periodDataStream);
    }

    private void writeStatsHeader(DataOutputStream stream) throws IOException {
        int i = 0;
        while (i < this.dataSelection.getSelectionSize()) {
            stream.writeBytes("\t");
            stream.writeBytes(this.dataSelection.getSelectedSeries(i).getName());
            ++i;
        }
    }

    public void writePeriodData() throws IOException {
        this.periodDataStream.writeBytes(Integer.toString(this.runCount));
        this.periodDataStream.writeBytes("\t");
        this.periodDataStream.writeBytes(Integer.toString(this.scape.getPeriod()));
        this.writeStats(this.periodDataStream);
    }

    public void writeStats(DataOutputStream stream) throws IOException {
        int i = 0;
        while (i < this.dataSelection.getSelectionSize()) {
            stream.writeBytes("\t");
            stream.writeBytes(Double.toString(this.dataSelection.getSelectedSeries(i).getValue()));
            ++i;
        }
    }

    public void writeRunHeader() throws IOException {
        this.runDataStream.writeBytes("Run\t");
        this.runDataStream.writeBytes("Start Period\t");
        this.runDataStream.writeBytes("Stop Period\t");
        this.runDataStream.writeBytes("Seed");
        List accessors = this.scape.retrieveAllAccessorsOrdered();
        for (PropertyAccessor accessor : accessors) {
            this.runDataStream.writeBytes("\t");
            this.runDataStream.writeBytes(accessor.getLongName());
        }
        this.writeStatsHeader(this.runDataStream);
    }

    public void writeRunData() throws IOException {
        this.runDataStream.writeBytes(Integer.toString(this.runCount));
        this.runDataStream.writeBytes("\t");
        this.runDataStream.writeBytes(Integer.toString(this.scape.getStartPeriod()));
        this.runDataStream.writeBytes("\t");
        this.runDataStream.writeBytes(Integer.toString(this.scape.getPeriod()));
        this.runDataStream.writeBytes("\t");
        this.runDataStream.writeBytes(Long.toString(this.scape.getRandomSeed()));
        List accessors = this.scape.retrieveAllAccessorsOrdered();
        for (PropertyAccessor accessor : accessors) {
            this.runDataStream.writeBytes("\t");
            if (accessor.getValue() instanceof Number) {
                this.runDataStream.writeBytes(Utility.formatToString(((Number)accessor.getValue()).doubleValue(), 4));
                continue;
            }
            if (!(accessor.getValue() instanceof Boolean)) continue;
            if (!((Boolean)accessor.getValue()).booleanValue()) {
                this.runDataStream.writeBytes("False");
                continue;
            }
            this.runDataStream.writeBytes("True");
        }
        this.writeStats(this.runDataStream);
    }

    public boolean stopCondition() {
        return false;
    }

    public static int getNumCharsInFileName() {
        return numCharsInFileName;
    }

    public static void setNumCharsInFileName(int _numCharsInFileName) {
        numCharsInFileName = _numCharsInFileName;
    }

    protected void scapeChanged() {
        if (this.periodDataStream != null) {
            try {
                this.writePeriodData();
                this.periodDataStream.writeBytes(EOLString);
            }
            catch (IOException e) {
                throw new RuntimeException("IO Exception occurred while sending iteration data.");
            }
        }
    }

    @Override
    public void scapeIterated(ScapeEvent scapeEvent) {
        this.scapeChanged();
        if (this.stopCondition()) {
            this.scape.getRunner().stop();
        }
    }

    @Override
    public void scapeClosing(ScapeEvent scapeEvent) {
        if (this.runDataStream != null) {
            try {
                this.runDataStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.runFileStream != null) {
            try {
                this.runFileStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.periodDataStream != null) {
            try {
                this.periodDataStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.periodFileStream != null) {
            try {
                this.periodFileStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void scapeStarted(ScapeEvent scapeEvent) {
        this.startTime = System.currentTimeMillis();
        if (this.writeHeaders) {
            if (!this.runHeadersWritten && this.runDataStream != null) {
                try {
                    this.writeRunHeader();
                    this.runDataStream.writeBytes(EOLString);
                    this.runHeadersWritten = true;
                }
                catch (IOException e) {
                    throw new RuntimeException("IO Exception occurred while sending iteration data: " + e);
                }
            }
            if (!this.periodHeadersWritten && this.periodDataStream != null) {
                try {
                    this.writePeriodHeader();
                    this.periodDataStream.writeBytes(EOLString);
                    this.periodHeadersWritten = true;
                }
                catch (IOException e) {
                    throw new RuntimeException("IO Exception occurred while sending iteration data.");
                }
            }
        }
        if (this.runDataStream == null && this.periodDataStream == null) {
            this.getScape().getEnvironment().getConsole().println("Warning: DataOutput view added, but no output stream specified!");
        }
        this.scapeChanged();
    }

    @Override
    public void scapeStopped(ScapeEvent scapeEvent) {
        if (this.runDataStream != null) {
            try {
                this.writeRunData();
                this.runDataStream.writeBytes(EOLString);
            }
            catch (IOException e) {
                throw new RuntimeException("IO Exception occurred while sending run data. " + e);
            }
        }
        ++this.runCount;
    }

    @Override
    public void scapeDeserialized(ScapeEvent scapeEvent) {
        super.scapeDeserialized(scapeEvent);
        try {
            this.setPeriodFile(this.periodFile);
            this.setRunFile(this.runFile);
        }
        catch (IOException e) {
            System.err.println("There was a problem opening a file for data output:\n" + e);
        }
    }

    @Override
    public void scapeAdded(ScapeEvent scapeEvent) throws TooManyListenersException {
        super.scapeAdded(scapeEvent);
        this.dataSelection.selectAll();
    }

    @Override
    public String toString() {
        return "Data Output View";
    }

    public String getEOLSeparator() {
        return EOLString;
    }

    public static void setEOLSeparator(String string) {
        EOLString = string;
    }
}

