/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.LocatorHelper;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef3d.commands.UpdateConstraintCommand;
import org.eclipse.gef3d.editpolicies.XY3DLayoutPolicy;
import org.eclipse.gef3d.requests.ChangeBounds3DRequest;

public class XYZConstraintLayoutPolicy
extends XY3DLayoutPolicy {
    protected Command createChangeConstraintCommand(EditPart i_child, Object i_constraint) {
        if (i_child instanceof GraphicalEditPart) {
            return new UpdateConstraintCommand(((GraphicalEditPart)i_child).getFigure(), i_constraint, this.getHostFigure().getLayoutManager());
        }
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        if (request instanceof ChangeBounds3DRequest && child.getFigure() instanceof IFigure3D) {
            ChangeBounds3DRequest cbr3D = (ChangeBounds3DRequest)request;
            IFigure3D child3D = (IFigure3D)child.getFigure();
            if (cbr3D.getModifier3D() != ChangeBounds3DRequest.Modifier3D.NONE) {
                Position3D childPos = child3D.getPosition3D();
                Position3D newPos = childPos.getAbsolute(null);
                cbr3D.getTransformedPosition(newPos);
                return this.getConstraintFor(newPos);
            }
            ISurface surface = cbr3D.getStartSurface();
            LocatorHelper locator = new LocatorHelper((IFigure)child3D);
            Position3D newPos = locator.getReferencePosition3D((IFigure)surface.getHost());
            Vector3f surfaceRelativeLocation = Draw3DCache.getVector3f();
            Vector3f size = Draw3DCache.getVector3f();
            try {
                if (request.getMoveDelta() != null) {
                    surfaceRelativeLocation.set(newPos.getLocation3D());
                    surfaceRelativeLocation.translate((float)request.getMoveDelta().x, (float)request.getMoveDelta().y, 0.0f);
                    newPos.setLocation3D((IVector3f)surfaceRelativeLocation);
                }
                if (request.getSizeDelta() != null) {
                    size.set(newPos.getSize3D());
                    size.translate((float)request.getSizeDelta().width, (float)request.getSizeDelta().height, 0.0f);
                    newPos.setSize3D((IVector3f)size);
                }
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{surfaceRelativeLocation, size});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{surfaceRelativeLocation, size});
            return this.getConstraintFor(newPos);
        }
        return super.getConstraintFor(request, child);
    }

    protected Object getConstraintFor(Position3D i_newPos) {
        return i_newPos;
    }
}

