/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newproject;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.AcceleoNewUIConfigurationPage;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleUIActivatorWriter;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleUIBuildWriter;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleUIClasspathWriter;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleUIData;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleUIGenerateAllWriter;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleUIMANIFESTWriter;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleUIPluginXMLWriter;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleUIPopupMenuActionWriter;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleUIProjectWriter;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.CreateModuleUISettingsWriter;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;

public class AcceleoNewProjectUIWizard
extends Wizard
implements INewWizard {
    public static final String MODULE_UI_NAME_PREFIX = "org.eclipse.acceleo.module.";
    public static final String MODULE_UI_NAME_SUFFIX = ".ui";
    protected WizardNewAcceleoProjectCreationPage newProjectPage;
    private ISelection selection;
    private WizardNewProjectReferencePage projectReferencesPage;
    private AcceleoNewUIConfigurationPage uiConfigPage;

    public AcceleoNewProjectUIWizard() {
        this.setWindowTitle(AcceleoUIMessages.getString("AcceleoNewProjectUIWizard.Title"));
    }

    public WizardNewProjectCreationPage getNewProjectPage() {
        return this.newProjectPage;
    }

    public WizardNewProjectReferencePage getProjectReferencesPage() {
        return this.projectReferencesPage;
    }

    public AcceleoNewUIConfigurationPage getConfigurationPage() {
        return this.uiConfigPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection aSelection) {
        this.selection = aSelection;
    }

    public void addPages() {
        IProject selectedProject = this.getSelectedProject();
        ImageDescriptor wizardImage = AcceleoUIActivator.getImageDescriptor("icons/AcceleoWizard.gif");
        this.newProjectPage = new WizardNewAcceleoProjectCreationPage();
        String initialProjectName = selectedProject != null ? (selectedProject.getName().endsWith(MODULE_UI_NAME_SUFFIX) ? selectedProject.getName() : String.valueOf(selectedProject.getName()) + MODULE_UI_NAME_SUFFIX) : "org.eclipse.acceleo.module.*.ui";
        this.newProjectPage.setInitialProjectName(initialProjectName);
        this.newProjectPage.setTitle(AcceleoUIMessages.getString("AcceleoNewProjectUIWizard.Title"));
        this.newProjectPage.setDescription(AcceleoUIMessages.getString("AcceleoNewProjectUIWizard.Description"));
        this.newProjectPage.setImageDescriptor(wizardImage);
        this.addPage((IWizardPage)this.newProjectPage);
        this.projectReferencesPage = new WizardNewProjectReferencePage(AcceleoUIMessages.getString("AcceleoNewProjectUIWizard.Reference.Name"));
        this.projectReferencesPage.setDescription(AcceleoUIMessages.getString("AcceleoNewProjectUIWizard.Reference.Description"));
        this.projectReferencesPage.setImageDescriptor(wizardImage);
        this.addPage((IWizardPage)this.projectReferencesPage);
        this.uiConfigPage = new AcceleoNewUIConfigurationPage(AcceleoUIMessages.getString("AcceleoNewProjectUIWizard.Config.Name"), initialProjectName);
        this.addPage((IWizardPage)this.uiConfigPage);
    }

    private IProject getSelectedProject() {
        IStructuredSelection aSelection;
        IProject selectedProject = null;
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection && (aSelection = (IStructuredSelection)this.selection).size() > 0) {
            Object element = aSelection.getFirstElement();
            if (element instanceof IAdaptable) {
                element = ((IAdaptable)element).getAdapter(IResource.class);
            }
            if (element instanceof IProject) {
                selectedProject = (IProject)element;
            } else if (element instanceof IResource) {
                selectedProject = ((IResource)element).getProject();
            }
        }
        return selectedProject;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        IProject selectedProject = this.getSelectedProject();
        if (selectedProject != null && ((Composite)this.projectReferencesPage.getControl()).getChildren().length > 1 && ((Composite)this.projectReferencesPage.getControl()).getChildren()[1] instanceof Table) {
            String selectedProjectName = selectedProject.getName();
            if (selectedProjectName.endsWith(MODULE_UI_NAME_SUFFIX)) {
                String newName = selectedProjectName.substring(0, selectedProjectName.length() - MODULE_UI_NAME_SUFFIX.length());
                if (ResourcesPlugin.getWorkspace().getRoot().getProject(newName).exists()) {
                    selectedProjectName = newName;
                }
            }
            Table table = (Table)((Composite)this.projectReferencesPage.getControl()).getChildren()[1];
            TableItem[] children = table.getItems();
            int i = 0;
            while (i < children.length) {
                String dataName;
                TableItem item = children[i];
                Object data = item.getData();
                if (data instanceof IProject && selectedProjectName.equals(dataName = ((IProject)data).getName())) {
                    item.setChecked(true);
                }
                ++i;
            }
        }
    }

    public boolean performFinish() {
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                CreateModuleUIData arg = new CreateModuleUIData(AcceleoNewProjectUIWizard.this);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(AcceleoNewProjectUIWizard.this.newProjectPage.getProjectName());
                IPath location = AcceleoNewProjectUIWizard.this.newProjectPage.getLocationPath();
                if (!project.exists()) {
                    IProjectDescription desc = project.getWorkspace().newProjectDescription(AcceleoNewProjectUIWizard.this.newProjectPage.getProjectName());
                    if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocation().equals((Object)location)) {
                        location = null;
                    }
                    desc.setLocation(location);
                    project.create(desc, monitor);
                    project.open(monitor);
                } else if (!project.isOpen()) {
                    project.open(monitor);
                }
                AcceleoNewProjectUIWizard.this.convert(project, arg, monitor);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(create, null);
            return true;
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    protected void convert(IProject project, CreateModuleUIData arg, IProgressMonitor monitor) {
        String baseFolder = "/src/" + arg.getProjectName().replaceAll("\\.", "/");
        this.createDefaultImage(project, monitor);
        CreateModuleUIActivatorWriter activatorWriter = new CreateModuleUIActivatorWriter();
        String text = activatorWriter.generate(arg);
        Path file = new Path(String.valueOf(baseFolder) + "/Activator.java");
        this.createFile(project, (IPath)file, text, false, monitor);
        CreateModuleUIBuildWriter buildWriter = new CreateModuleUIBuildWriter();
        text = buildWriter.generate(arg);
        file = new Path("build.properties");
        this.createFile(project, (IPath)file, text, true, monitor);
        CreateModuleUIClasspathWriter classpathWriter = new CreateModuleUIClasspathWriter();
        text = classpathWriter.generate(arg);
        file = new Path(".classpath");
        this.createFile(project, (IPath)file, text, true, monitor);
        CreateModuleUIMANIFESTWriter manifestWriter = new CreateModuleUIMANIFESTWriter();
        text = manifestWriter.generate(arg);
        file = new Path("META-INF/MANIFEST.MF");
        this.createFile(project, (IPath)file, text, true, monitor);
        CreateModuleUIProjectWriter projectWriter = new CreateModuleUIProjectWriter();
        text = projectWriter.generate(arg);
        file = new Path(".project");
        this.createFile(project, (IPath)file, text, false, monitor);
        CreateModuleUISettingsWriter settingsWriter = new CreateModuleUISettingsWriter();
        text = settingsWriter.generate(arg);
        file = new Path("/.settings/org.eclipse.jdt.core.prefs");
        this.createFile(project, (IPath)file, text, true, monitor);
        CreateModuleUIGenerateAllWriter generateAllWriter = new CreateModuleUIGenerateAllWriter();
        text = generateAllWriter.generate(arg);
        file = new Path(String.valueOf(baseFolder) + "/common/GenerateAll.java");
        this.createFile(project, (IPath)file, text, false, monitor);
        CreateModuleUIPluginXMLWriter pluginXMLWriter = new CreateModuleUIPluginXMLWriter();
        text = pluginXMLWriter.generate(arg);
        file = new Path("plugin.xml");
        this.createFile(project, (IPath)file, text, true, monitor);
        CreateModuleUIPopupMenuActionWriter actionPopupWriter = new CreateModuleUIPopupMenuActionWriter();
        text = actionPopupWriter.generate(arg);
        file = new Path(String.valueOf(baseFolder) + "/popupMenus/AcceleoGenerate" + arg.getModuleNameWithoutSpaces() + "Action.java");
        this.createFile(project, (IPath)file, text, false, monitor);
    }

    private void createDefaultImage(IProject project, IProgressMonitor monitor) {
        try {
            URL imageURL = Platform.getBundle((String)"org.eclipse.acceleo.ide.ui").getEntry("icons/AcceleoEditor.gif");
            imageURL = FileLocator.toFileURL((URL)imageURL);
            File imageFile = new File(imageURL.getFile());
            IFolder icons = project.getFolder((IPath)new Path("icons"));
            if (!icons.exists()) {
                icons.create(true, true, monitor);
            }
            if (!icons.exists((IPath)new Path("default.gif"))) {
                this.copyFile(imageFile, icons.getFile("default.gif").getLocation().toFile());
                icons.refreshLocal(1, monitor);
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    private void createFile(IProject project, IPath projectRelativePath, String content, boolean firstTimeOnly, IProgressMonitor monitor) {
        try {
            IProject container = project;
            String[] folders = projectRelativePath.removeLastSegments(1).segments();
            int i = 0;
            while (i < folders.length) {
                if (!(container = container.getFolder((IPath)new Path(folders[i]))).exists()) {
                    ((IFolder)container).create(true, true, monitor);
                }
                ++i;
            }
            IFile file = container.getFile((IPath)new Path(projectRelativePath.lastSegment()));
            if (!file.exists() && file.getParent().exists()) {
                IResource[] members = file.getParent().members(1);
                int i2 = 0;
                while (i2 < members.length) {
                    if (members[i2] instanceof IFile && file.getName().toLowerCase().equals(members[i2].getName().toLowerCase())) {
                        file = (IFile)members[i2];
                        break;
                    }
                    ++i2;
                }
            }
            String text = content;
            if (!firstTimeOnly && file.exists() && "java".equals(file.getFileExtension())) {
                String jmergeFile = URI.createPlatformPluginURI((String)"org.eclipse.emf.codegen.ecore/templates/emf-merge.xml", (boolean)false).toString();
                JControlModel model = new JControlModel();
                ASTFacadeHelper astFacadeHelper = new ASTFacadeHelper();
                model.initialize((FacadeHelper)astFacadeHelper, jmergeFile);
                if (model.canMerge()) {
                    JMerger jMerger = new JMerger(model);
                    jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(text));
                    try {
                        jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream((InputStream)new FileInputStream(file.getLocation().toFile())));
                        jMerger.merge();
                        text = jMerger.getTargetCompilationUnit().getContents();
                    }
                    catch (FileNotFoundException e) {
                        AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
                    }
                } else {
                    AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.acceleo.ide.ui", AcceleoUIMessages.getString("CreateRunnableAcceleoOperation.MergerUnusable"), null));
                }
            }
            if (!file.exists() || !firstTimeOnly && !text.equals(FileContent.getFileContent((File)file.getLocation().toFile()).toString())) {
                ByteArrayInputStream javaStream = new ByteArrayInputStream(text.getBytes("UTF8"));
                if (!file.exists()) {
                    file.create((InputStream)javaStream, true, monitor);
                } else if (!firstTimeOnly) {
                    file.setContents((InputStream)javaStream, true, false, monitor);
                }
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
        }
        catch (UnsupportedEncodingException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    private void copyFile(File sourceFile, File targetFile) throws FileNotFoundException, IOException {
        if (targetFile.exists()) {
            return;
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(sourceFile);
            out = new FileOutputStream(targetFile);
            int length = 8192;
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                out.write(buffer, 0, count);
            } while ((count = in.read(buffer, 0, buffer.length)) != -1);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private class WizardNewAcceleoProjectCreationPage
    extends WizardNewProjectCreationPage {
        public WizardNewAcceleoProjectCreationPage() {
            super(AcceleoUIMessages.getString("AcceleoNewProjectUIWizard.Module.Title"));
        }

        public boolean isPageComplete() {
            return this.validateProjectExists() || super.isPageComplete();
        }

        protected boolean validatePage() {
            return this.validateProjectExists() || super.validatePage();
        }

        private boolean validateProjectExists() {
            IProject handle = this.getProjectHandle();
            if (handle.exists()) {
                this.setMessage(AcceleoUIMessages.getString("AcceleoNewProjectUIWizard.OverwriteProject"), 2);
                return true;
            }
            return false;
        }
    }
}

