/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.hover;

import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.AcceleoUIDocumentationUtils;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.model.mtl.Documentation;
import org.eclipse.acceleo.model.mtl.DocumentedElement;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleDocumentation;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.ModuleElementDocumentation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.swt.graphics.Point;

public class AcceleoTextHover
implements ITextHover,
ITextHoverExtension2 {
    private AcceleoEditor editor;

    public AcceleoTextHover(AcceleoEditor acceleoEditor) {
        this.editor = acceleoEditor;
    }

    @Deprecated
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String result = null;
        if (hoverRegion != null && this.editor != null && this.editor.getContent() != null) {
            ASTNode astNode = this.editor.getContent().getResolvedASTNode(hoverRegion.getOffset(), hoverRegion.getOffset() + hoverRegion.getLength());
            if (astNode != null) {
                EObject eObject = OpenDeclarationUtils.findDeclarationFromAST(astNode);
                if (eObject instanceof IteratorExp && this.editor.getContent().getOCLEnvironment() != null) {
                    eObject = OpenDeclarationUtils.findIteratorEOperation(this.editor.getContent().getOCLEnvironment(), (IteratorExp)eObject);
                }
                if (eObject != null) {
                    result = this.getInfo(eObject);
                }
            } else if (this.editor.getContent().isInModuleHeader(hoverRegion.getOffset(), hoverRegion.getOffset() + hoverRegion.getLength(), true)) {
                Module module = this.editor.getContent().getAST();
                result = this.getInfo((EObject)module);
            }
        }
        return result;
    }

    private String getInfo(EObject eObject) {
        String result = "";
        if (eObject instanceof DocumentedElement) {
            result = AcceleoUIDocumentationUtils.getDocumentation((DocumentedElement)eObject);
        }
        return result;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        Object result = null;
        if (hoverRegion != null && this.editor != null && this.editor.getContent() != null) {
            ASTNode astNode = this.editor.getContent().getResolvedASTNode(hoverRegion.getOffset(), hoverRegion.getOffset() + hoverRegion.getLength());
            if (astNode != null) {
                Object eObject = null;
                eObject = astNode instanceof Variable && ((Variable)astNode).getName() != null && hoverRegion.getOffset() < ((Variable)astNode).getStartPosition() + ((Variable)astNode).getName().length() ? astNode : OpenDeclarationUtils.findDeclarationFromAST(astNode);
                if (eObject instanceof IteratorExp && this.editor.getContent().getOCLEnvironment() != null) {
                    eObject = OpenDeclarationUtils.findIteratorEOperation(this.editor.getContent().getOCLEnvironment(), (IteratorExp)eObject);
                }
                if (eObject != null) {
                    result = this.getObjectInfo((EObject)eObject);
                }
            } else if (this.editor.getContent().isInModuleHeader(hoverRegion.getOffset(), hoverRegion.getOffset() + hoverRegion.getLength(), true)) {
                Module module = this.editor.getContent().getAST();
                result = this.getObjectInfo((EObject)module);
            }
        }
        return result;
    }

    private Object getObjectInfo(EObject eObject) {
        Documentation documentation = null;
        if (eObject instanceof DocumentedElement) {
            DocumentedElement element = (DocumentedElement)eObject;
            documentation = element.getDocumentation();
            boolean fromFile = false;
            if (documentation == null) {
                fromFile = true;
            } else if (element instanceof Module && !(documentation instanceof ModuleDocumentation) || element instanceof ModuleElement && !(documentation instanceof ModuleElementDocumentation)) {
                fromFile = true;
            }
            if (fromFile) {
                documentation = AcceleoUIDocumentationUtils.getDocumentationFromFile(element);
            }
        }
        if (documentation != null) {
            String result = AcceleoUIDocumentationUtils.getTextFrom(documentation);
            if (documentation.eResource() != null && documentation.eResource() != eObject.eResource()) {
                documentation.eResource().unload();
            }
            return result;
        }
        return eObject;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        Point selection = textViewer.getSelectedRange();
        if (selection.x <= offset && offset < selection.x + selection.y) {
            return new Region(selection.x, selection.y);
        }
        return new Region(offset, 0);
    }
}

