/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.debug.model;

import org.eclipse.acceleo.internal.ide.ui.debug.model.AbstractDebugElement;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoStackFrame;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoValue;
import org.eclipse.acceleo.ui.interpreter.view.Variable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EObject;

public class AcceleoVariable
extends AbstractDebugElement
implements IVariable,
Comparable<AcceleoVariable> {
    protected static final int DEFAULT_TYPE = 0;
    protected static final int CLASS_TYPE = 1;
    protected static final int REFERENCE_TYPE = 2;
    protected static final int ATTRIBUTE_TYPE = 3;
    private String name;
    private Object value;
    private int type;

    public AcceleoVariable(AcceleoStackFrame frame, String name, Object aValue, int type) {
        this(frame.getDebugTarget(), name, aValue, type);
    }

    public AcceleoVariable(IDebugTarget aDebugTarget, String name, Object aValue, int type) {
        super(aDebugTarget);
        this.name = name;
        this.value = aValue;
        this.type = type;
    }

    public IValue getValue() throws DebugException {
        return new AcceleoValue(this.getDebugTarget(), this.value, this.type);
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        String ret = "";
        if (this.value != null) {
            ret = this.getSimpleName(this.value.getClass());
        }
        return ret;
    }

    private String getSimpleName(Class<?> c) {
        String cName = c.getName();
        int i = cName.lastIndexOf(".");
        if (i > -1) {
            cName = cName.substring(i + 1);
        }
        return cName;
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue aValue) throws DebugException {
        return false;
    }

    @Override
    public int compareTo(AcceleoVariable arg0) {
        int ret = 0;
        if (arg0.name != null && this.name != null) {
            ret = this.name.compareTo(arg0.name);
        }
        return ret;
    }

    @Override
    public Object getAdapter(Class adapter) {
        Object adapted = null;
        if (adapter == EObject.class && this.value instanceof EObject) {
            adapted = this.value;
        } else if (adapter == Variable.class) {
            adapted = new Variable(this.name, this.value);
        }
        if (adapted != null) {
            return adapted;
        }
        return super.getAdapter(adapter);
    }
}

