/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.quickfix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.quickfix.AbstractCreateModuleElementResolution;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.JavaServicesUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AcceleoCreateJavaServiceWrapperResolutionAfterLastMember
extends AbstractCreateModuleElementResolution {
    public String getDescription() {
        return AcceleoUIMessages.getString("AcceleoCreateJavaServiceWrapperResolutionAfterLastMember.Description");
    }

    public Image getImage() {
        return AcceleoUIActivator.getDefault().getImage("icons/quickfix/QuickFixCreateQuery.gif");
    }

    public String getLabel() {
        return AcceleoUIMessages.getString("AcceleoCreateJavaServiceWrapperResolutionAfterLastMember.Label");
    }

    @Override
    protected void append(StringBuilder newText, String name, String paramType, String paramName) {
        try {
            for (IFile javaFile : this.getProjectJavaFiles()) {
                this.createJavaWrappers(newText, javaFile, name);
            }
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
    }

    private List<IFile> getProjectJavaFiles() throws CoreException {
        AcceleoEditor editor;
        IFile mtlFile;
        ArrayList<IFile> javaFiles = new ArrayList<IFile>();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null && window.getActivePage().getActiveEditor() instanceof AcceleoEditor && (mtlFile = (editor = (AcceleoEditor)window.getActivePage().getActiveEditor()).getFile()) != null) {
            IProject project = mtlFile.getProject();
            this.members(javaFiles, (IContainer)project, "java");
        }
        return javaFiles;
    }

    private void members(List<IFile> filesOutput, IContainer container, String extension) throws CoreException {
        IResource[] children;
        if (container != null && (children = container.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile && extension.equals(((IFile)resource).getFileExtension())) {
                    filesOutput.add((IFile)resource);
                } else if (resource instanceof IContainer) {
                    this.members(filesOutput, (IContainer)resource, extension);
                }
                ++i;
            }
        }
    }

    private void createJavaWrappers(StringBuilder buffer, IFile javaFile, String serviceName) {
        IJavaElement javaElement = JavaCore.create((IFile)javaFile);
        if (javaElement instanceof ICompilationUnit) {
            IType[] types;
            ICompilationUnit classFile = (ICompilationUnit)javaElement;
            try {
                types = classFile.getTypes();
            }
            catch (JavaModelException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
                types = new IType[]{};
            }
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType iType = iTypeArray[n2];
                try {
                    IMethod[] methods;
                    IMethod[] iMethodArray = methods = iType.getMethods();
                    int n3 = methods.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMethod iMethod = iMethodArray[n4];
                        buffer.append(JavaServicesUtils.createQuery(iType, iMethod, true));
                        ++n4;
                    }
                }
                catch (JavaModelException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
                ++n2;
            }
        }
    }
}

