/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.model;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.ui.internal.model.TMDocumentModel;
import org.eclipse.tm4e.ui.model.ITMModelManager;

public final class TMModelManager
implements ITMModelManager {
    public static final TMModelManager INSTANCE = new TMModelManager();
    private final Map<IDocument, TMDocumentModel> models = new ConcurrentHashMap<IDocument, TMDocumentModel>();

    private TMModelManager() {
    }

    @Override
    public TMDocumentModel connect(IDocument document) {
        return this.models.computeIfAbsent(document, TMDocumentModel::new);
    }

    @Override
    public void disconnect(IDocument document) {
        TMDocumentModel model = (TMDocumentModel)NullSafetyHelper.castNullable((Object)this.models.remove(document));
        if (model != null) {
            model.dispose();
        }
    }

    public @Nullable TMDocumentModel getConnectedModel(IDocument document) {
        return this.models.get(document);
    }

    @Override
    public boolean isConnected(IDocument document) {
        return this.models.containsKey(document);
    }
}

