/**
 * Copyright (c) 2008, 2020 Obeo.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Obeo - initial API and implementation
 */
package org.eclipse.acceleo.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.acceleo.util.AcceleoAdapterFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class AcceleoItemProviderAdapterFactory extends AcceleoAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AcceleoItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.Module} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModuleItemProvider moduleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.Module}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModuleAdapter() {
		if (moduleItemProvider == null) {
			moduleItemProvider = new ModuleItemProvider(this);
		}

		return moduleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorModule} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorModuleItemProvider errorModuleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorModule}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorModuleAdapter() {
		if (errorModuleItemProvider == null) {
			errorModuleItemProvider = new ErrorModuleItemProvider(this);
		}

		return errorModuleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.Metamodel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MetamodelItemProvider metamodelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.Metamodel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMetamodelAdapter() {
		if (metamodelItemProvider == null) {
			metamodelItemProvider = new MetamodelItemProvider(this);
		}

		return metamodelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorMetamodel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorMetamodelItemProvider errorMetamodelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorMetamodel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorMetamodelAdapter() {
		if (errorMetamodelItemProvider == null) {
			errorMetamodelItemProvider = new ErrorMetamodelItemProvider(this);
		}

		return errorMetamodelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.Import} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImportItemProvider importItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.Import}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createImportAdapter() {
		if (importItemProvider == null) {
			importItemProvider = new ImportItemProvider(this);
		}

		return importItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorImport} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorImportItemProvider errorImportItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorImport}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorImportAdapter() {
		if (errorImportItemProvider == null) {
			errorImportItemProvider = new ErrorImportItemProvider(this);
		}

		return errorImportItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ModuleReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModuleReferenceItemProvider moduleReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ModuleReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModuleReferenceAdapter() {
		if (moduleReferenceItemProvider == null) {
			moduleReferenceItemProvider = new ModuleReferenceItemProvider(this);
		}

		return moduleReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorModuleReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorModuleReferenceItemProvider errorModuleReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorModuleReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorModuleReferenceAdapter() {
		if (errorModuleReferenceItemProvider == null) {
			errorModuleReferenceItemProvider = new ErrorModuleReferenceItemProvider(this);
		}

		return errorModuleReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.Comment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommentItemProvider commentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.Comment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommentAdapter() {
		if (commentItemProvider == null) {
			commentItemProvider = new CommentItemProvider(this);
		}

		return commentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.BlockComment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BlockCommentItemProvider blockCommentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.BlockComment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlockCommentAdapter() {
		if (blockCommentItemProvider == null) {
			blockCommentItemProvider = new BlockCommentItemProvider(this);
		}

		return blockCommentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorBlockComment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorBlockCommentItemProvider errorBlockCommentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorBlockComment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorBlockCommentAdapter() {
		if (errorBlockCommentItemProvider == null) {
			errorBlockCommentItemProvider = new ErrorBlockCommentItemProvider(this);
		}

		return errorBlockCommentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorComment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorCommentItemProvider errorCommentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorComment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorCommentAdapter() {
		if (errorCommentItemProvider == null) {
			errorCommentItemProvider = new ErrorCommentItemProvider(this);
		}

		return errorCommentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.CommentBody} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommentBodyItemProvider commentBodyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.CommentBody}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommentBodyAdapter() {
		if (commentBodyItemProvider == null) {
			commentBodyItemProvider = new CommentBodyItemProvider(this);
		}

		return commentBodyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ModuleDocumentation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModuleDocumentationItemProvider moduleDocumentationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ModuleDocumentation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModuleDocumentationAdapter() {
		if (moduleDocumentationItemProvider == null) {
			moduleDocumentationItemProvider = new ModuleDocumentationItemProvider(this);
		}

		return moduleDocumentationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorModuleDocumentation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorModuleDocumentationItemProvider errorModuleDocumentationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorModuleDocumentation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorModuleDocumentationAdapter() {
		if (errorModuleDocumentationItemProvider == null) {
			errorModuleDocumentationItemProvider = new ErrorModuleDocumentationItemProvider(this);
		}

		return errorModuleDocumentationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ModuleElementDocumentation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModuleElementDocumentationItemProvider moduleElementDocumentationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ModuleElementDocumentation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModuleElementDocumentationAdapter() {
		if (moduleElementDocumentationItemProvider == null) {
			moduleElementDocumentationItemProvider = new ModuleElementDocumentationItemProvider(this);
		}

		return moduleElementDocumentationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorModuleElementDocumentation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorModuleElementDocumentationItemProvider errorModuleElementDocumentationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorModuleElementDocumentation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorModuleElementDocumentationAdapter() {
		if (errorModuleElementDocumentationItemProvider == null) {
			errorModuleElementDocumentationItemProvider = new ErrorModuleElementDocumentationItemProvider(this);
		}

		return errorModuleElementDocumentationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ParameterDocumentation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterDocumentationItemProvider parameterDocumentationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ParameterDocumentation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterDocumentationAdapter() {
		if (parameterDocumentationItemProvider == null) {
			parameterDocumentationItemProvider = new ParameterDocumentationItemProvider(this);
		}

		return parameterDocumentationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.Block} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BlockItemProvider blockItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.Block}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlockAdapter() {
		if (blockItemProvider == null) {
			blockItemProvider = new BlockItemProvider(this);
		}

		return blockItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.TypedElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypedElementItemProvider typedElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.TypedElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypedElementAdapter() {
		if (typedElementItemProvider == null) {
			typedElementItemProvider = new TypedElementItemProvider(this);
		}

		return typedElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.Template} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TemplateItemProvider templateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.Template}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTemplateAdapter() {
		if (templateItemProvider == null) {
			templateItemProvider = new TemplateItemProvider(this);
		}

		return templateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorTemplate} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorTemplateItemProvider errorTemplateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorTemplate}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorTemplateAdapter() {
		if (errorTemplateItemProvider == null) {
			errorTemplateItemProvider = new ErrorTemplateItemProvider(this);
		}

		return errorTemplateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.Query} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QueryItemProvider queryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.Query}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQueryAdapter() {
		if (queryItemProvider == null) {
			queryItemProvider = new QueryItemProvider(this);
		}

		return queryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorQuery} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorQueryItemProvider errorQueryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorQuery}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorQueryAdapter() {
		if (errorQueryItemProvider == null) {
			errorQueryItemProvider = new ErrorQueryItemProvider(this);
		}

		return errorQueryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.Expression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionItemProvider expressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.Expression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpressionAdapter() {
		if (expressionItemProvider == null) {
			expressionItemProvider = new ExpressionItemProvider(this);
		}

		return expressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorExpressionItemProvider errorExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorExpressionAdapter() {
		if (errorExpressionItemProvider == null) {
			errorExpressionItemProvider = new ErrorExpressionItemProvider(this);
		}

		return errorExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.Variable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableItemProvider variableItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.Variable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableAdapter() {
		if (variableItemProvider == null) {
			variableItemProvider = new VariableItemProvider(this);
		}

		return variableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorVariable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorVariableItemProvider errorVariableItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorVariable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorVariableAdapter() {
		if (errorVariableItemProvider == null) {
			errorVariableItemProvider = new ErrorVariableItemProvider(this);
		}

		return errorVariableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.Binding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BindingItemProvider bindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.Binding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBindingAdapter() {
		if (bindingItemProvider == null) {
			bindingItemProvider = new BindingItemProvider(this);
		}

		return bindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorBindingItemProvider errorBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorBindingAdapter() {
		if (errorBindingItemProvider == null) {
			errorBindingItemProvider = new ErrorBindingItemProvider(this);
		}

		return errorBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.LeafStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LeafStatementItemProvider leafStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.LeafStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLeafStatementAdapter() {
		if (leafStatementItemProvider == null) {
			leafStatementItemProvider = new LeafStatementItemProvider(this);
		}

		return leafStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ExpressionStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionStatementItemProvider expressionStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ExpressionStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpressionStatementAdapter() {
		if (expressionStatementItemProvider == null) {
			expressionStatementItemProvider = new ExpressionStatementItemProvider(this);
		}

		return expressionStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorExpressionStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorExpressionStatementItemProvider errorExpressionStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorExpressionStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorExpressionStatementAdapter() {
		if (errorExpressionStatementItemProvider == null) {
			errorExpressionStatementItemProvider = new ErrorExpressionStatementItemProvider(this);
		}

		return errorExpressionStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ProtectedArea} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProtectedAreaItemProvider protectedAreaItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ProtectedArea}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProtectedAreaAdapter() {
		if (protectedAreaItemProvider == null) {
			protectedAreaItemProvider = new ProtectedAreaItemProvider(this);
		}

		return protectedAreaItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorProtectedArea} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorProtectedAreaItemProvider errorProtectedAreaItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorProtectedArea}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorProtectedAreaAdapter() {
		if (errorProtectedAreaItemProvider == null) {
			errorProtectedAreaItemProvider = new ErrorProtectedAreaItemProvider(this);
		}

		return errorProtectedAreaItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ForStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ForStatementItemProvider forStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ForStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createForStatementAdapter() {
		if (forStatementItemProvider == null) {
			forStatementItemProvider = new ForStatementItemProvider(this);
		}

		return forStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorForStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorForStatementItemProvider errorForStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorForStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorForStatementAdapter() {
		if (errorForStatementItemProvider == null) {
			errorForStatementItemProvider = new ErrorForStatementItemProvider(this);
		}

		return errorForStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.IfStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IfStatementItemProvider ifStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.IfStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIfStatementAdapter() {
		if (ifStatementItemProvider == null) {
			ifStatementItemProvider = new IfStatementItemProvider(this);
		}

		return ifStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorIfStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorIfStatementItemProvider errorIfStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorIfStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorIfStatementAdapter() {
		if (errorIfStatementItemProvider == null) {
			errorIfStatementItemProvider = new ErrorIfStatementItemProvider(this);
		}

		return errorIfStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.LetStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LetStatementItemProvider letStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.LetStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLetStatementAdapter() {
		if (letStatementItemProvider == null) {
			letStatementItemProvider = new LetStatementItemProvider(this);
		}

		return letStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorLetStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorLetStatementItemProvider errorLetStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorLetStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorLetStatementAdapter() {
		if (errorLetStatementItemProvider == null) {
			errorLetStatementItemProvider = new ErrorLetStatementItemProvider(this);
		}

		return errorLetStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.FileStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FileStatementItemProviderSpec fileStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.FileStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFileStatementAdapter() {
		if (fileStatementItemProvider == null) {
			fileStatementItemProvider = new FileStatementItemProviderSpec(this);
		}

		return fileStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.ErrorFileStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ErrorFileStatementItemProvider errorFileStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.ErrorFileStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErrorFileStatementAdapter() {
		if (errorFileStatementItemProvider == null) {
			errorFileStatementItemProvider = new ErrorFileStatementItemProvider(this);
		}

		return errorFileStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.acceleo.TextStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TextStatementItemProvider textStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.acceleo.TextStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTextStatementAdapter() {
		if (textStatementItemProvider == null) {
			textStatementItemProvider = new TextStatementItemProvider(this);
		}

		return textStatementItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (moduleItemProvider != null)
			moduleItemProvider.dispose();
		if (errorModuleItemProvider != null)
			errorModuleItemProvider.dispose();
		if (metamodelItemProvider != null)
			metamodelItemProvider.dispose();
		if (errorMetamodelItemProvider != null)
			errorMetamodelItemProvider.dispose();
		if (importItemProvider != null)
			importItemProvider.dispose();
		if (errorImportItemProvider != null)
			errorImportItemProvider.dispose();
		if (moduleReferenceItemProvider != null)
			moduleReferenceItemProvider.dispose();
		if (errorModuleReferenceItemProvider != null)
			errorModuleReferenceItemProvider.dispose();
		if (blockCommentItemProvider != null)
			blockCommentItemProvider.dispose();
		if (errorBlockCommentItemProvider != null)
			errorBlockCommentItemProvider.dispose();
		if (commentItemProvider != null)
			commentItemProvider.dispose();
		if (errorCommentItemProvider != null)
			errorCommentItemProvider.dispose();
		if (commentBodyItemProvider != null)
			commentBodyItemProvider.dispose();
		if (moduleDocumentationItemProvider != null)
			moduleDocumentationItemProvider.dispose();
		if (errorModuleDocumentationItemProvider != null)
			errorModuleDocumentationItemProvider.dispose();
		if (moduleElementDocumentationItemProvider != null)
			moduleElementDocumentationItemProvider.dispose();
		if (errorModuleElementDocumentationItemProvider != null)
			errorModuleElementDocumentationItemProvider.dispose();
		if (parameterDocumentationItemProvider != null)
			parameterDocumentationItemProvider.dispose();
		if (blockItemProvider != null)
			blockItemProvider.dispose();
		if (typedElementItemProvider != null)
			typedElementItemProvider.dispose();
		if (templateItemProvider != null)
			templateItemProvider.dispose();
		if (errorTemplateItemProvider != null)
			errorTemplateItemProvider.dispose();
		if (queryItemProvider != null)
			queryItemProvider.dispose();
		if (errorQueryItemProvider != null)
			errorQueryItemProvider.dispose();
		if (expressionItemProvider != null)
			expressionItemProvider.dispose();
		if (errorExpressionItemProvider != null)
			errorExpressionItemProvider.dispose();
		if (variableItemProvider != null)
			variableItemProvider.dispose();
		if (errorVariableItemProvider != null)
			errorVariableItemProvider.dispose();
		if (bindingItemProvider != null)
			bindingItemProvider.dispose();
		if (errorBindingItemProvider != null)
			errorBindingItemProvider.dispose();
		if (leafStatementItemProvider != null)
			leafStatementItemProvider.dispose();
		if (expressionStatementItemProvider != null)
			expressionStatementItemProvider.dispose();
		if (errorExpressionStatementItemProvider != null)
			errorExpressionStatementItemProvider.dispose();
		if (protectedAreaItemProvider != null)
			protectedAreaItemProvider.dispose();
		if (errorProtectedAreaItemProvider != null)
			errorProtectedAreaItemProvider.dispose();
		if (forStatementItemProvider != null)
			forStatementItemProvider.dispose();
		if (errorForStatementItemProvider != null)
			errorForStatementItemProvider.dispose();
		if (ifStatementItemProvider != null)
			ifStatementItemProvider.dispose();
		if (errorIfStatementItemProvider != null)
			errorIfStatementItemProvider.dispose();
		if (letStatementItemProvider != null)
			letStatementItemProvider.dispose();
		if (errorLetStatementItemProvider != null)
			errorLetStatementItemProvider.dispose();
		if (fileStatementItemProvider != null)
			fileStatementItemProvider.dispose();
		if (errorFileStatementItemProvider != null)
			errorFileStatementItemProvider.dispose();
		if (textStatementItemProvider != null)
			textStatementItemProvider.dispose();
	}

}
