/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.location;

import java.util.Collections;
import java.util.Set;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.ForStatement;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.TypedElement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.location.aql.AqlVariablesLocalContext;
import org.eclipse.acceleo.aql.validation.AcceleoValidationUtils;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.util.AcceleoSwitch;

public class AcceleoExpressionVariablesContextProvider
extends AcceleoSwitch<AqlVariablesLocalContext> {
    private final IAcceleoEnvironment acceleoEnvironment;

    public AcceleoExpressionVariablesContextProvider(IAcceleoEnvironment acceleoEnvironment) {
        this.acceleoEnvironment = acceleoEnvironment;
    }

    @Override
    public AqlVariablesLocalContext caseExpression(Expression expression) {
        AqlVariablesLocalContext variablesContext = new AqlVariablesLocalContext();
        variablesContext.addAllVariables((AqlVariablesLocalContext)this.doSwitch(expression.eContainer()));
        return variablesContext;
    }

    @Override
    public AqlVariablesLocalContext caseTypedElement(TypedElement typedElement) {
        AqlVariablesLocalContext variablesContext = new AqlVariablesLocalContext();
        variablesContext.addAllVariables((AqlVariablesLocalContext)this.doSwitch(typedElement.eContainer()));
        return variablesContext;
    }

    @Override
    public AqlVariablesLocalContext caseBlock(Block block) {
        AqlVariablesLocalContext variablesContext = new AqlVariablesLocalContext();
        variablesContext.addAllVariables((AqlVariablesLocalContext)this.doSwitch(block.eContainer()));
        return variablesContext;
    }

    @Override
    public AqlVariablesLocalContext caseStatement(Statement statement) {
        AqlVariablesLocalContext variablesContext = new AqlVariablesLocalContext();
        variablesContext.addAllVariables((AqlVariablesLocalContext)this.doSwitch(statement.eContainer()));
        return variablesContext;
    }

    @Override
    public AqlVariablesLocalContext caseQuery(Query query) {
        AqlVariablesLocalContext variablesContext = new AqlVariablesLocalContext();
        for (Variable parameter : query.getParameters()) {
            variablesContext.addAllVariables(this.getVariableStandaloneContext(parameter));
        }
        return variablesContext;
    }

    @Override
    public AqlVariablesLocalContext caseTemplate(Template template) {
        AqlVariablesLocalContext variablesContext = new AqlVariablesLocalContext();
        Set<ClassType> selfPossibleTypes = Collections.singleton(new ClassType((IReadOnlyQueryEnvironment)this.acceleoEnvironment.getQueryEnvironment(), String.class));
        variablesContext.addVariable(AcceleoUtil.getTemplateImplicitVariableName(), template, selfPossibleTypes);
        for (Variable parameter : template.getParameters()) {
            variablesContext.addAllVariables(this.getVariableStandaloneContext(parameter));
        }
        return variablesContext;
    }

    @Override
    public AqlVariablesLocalContext caseVariable(Variable variable) {
        AqlVariablesLocalContext variablesContext = new AqlVariablesLocalContext();
        variablesContext.addAllVariables(this.getVariableStandaloneContext(variable));
        variablesContext.addAllVariables((AqlVariablesLocalContext)this.doSwitch(variable.eContainer()));
        return variablesContext;
    }

    private AqlVariablesLocalContext getVariableStandaloneContext(Variable variable) {
        AqlVariablesLocalContext variablesContext = new AqlVariablesLocalContext();
        Set<IType> variablePossibleTypes = AcceleoValidationUtils.getPossibleTypes((TypedElement)variable, this.acceleoEnvironment.getQueryEnvironment());
        variablesContext.addVariable(variable.getName(), variable, variablePossibleTypes);
        return variablesContext;
    }

    @Override
    public AqlVariablesLocalContext caseForStatement(ForStatement forStatement) {
        AqlVariablesLocalContext variablesContext = new AqlVariablesLocalContext();
        variablesContext.addAllVariables((AqlVariablesLocalContext)this.doSwitch(forStatement.eContainer()));
        variablesContext.addAllVariables(this.getVariableStandaloneContext(forStatement.getBinding()));
        return variablesContext;
    }

    @Override
    public AqlVariablesLocalContext caseLetStatement(LetStatement letStatement) {
        AqlVariablesLocalContext variablesContext = new AqlVariablesLocalContext();
        variablesContext.addAllVariables((AqlVariablesLocalContext)this.doSwitch(letStatement.eContainer()));
        letStatement.getVariables().forEach(variableBinding -> {
            AqlVariablesLocalContext aqlVariablesLocalContext2 = variablesContext.addAllVariables(this.getVariableStandaloneContext((Variable)variableBinding));
        });
        return variablesContext;
    }
}

