/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.evaluation;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.VisibilityKind;
import org.eclipse.acceleo.aql.AcceleoEnvironment;
import org.eclipse.acceleo.aql.evaluation.AbstractModuleElementService;
import org.eclipse.acceleo.aql.evaluation.AcceleoCallStack;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.lookup.basic.BasicLookupEngine;
import org.eclipse.acceleo.query.validation.type.IType;

public class AcceleoLookupEngine
extends BasicLookupEngine {
    private final AcceleoEnvironment acceleoEnvironment;

    public AcceleoLookupEngine(IReadOnlyQueryEnvironment aqlEnvironment, AcceleoEnvironment acceleoEnvironment) {
        super(aqlEnvironment);
        this.acceleoEnvironment = acceleoEnvironment;
    }

    public IService<?> lookup(String name, IType[] argumentTypes) {
        AcceleoCallStack currentStack = this.acceleoEnvironment.getCurrentStack();
        String last = this.acceleoEnvironment.getModuleQualifiedName((Module)currentStack.peek().eContainer());
        if (last == null) {
            last = currentStack.getStartingModuleQualifiedName();
        }
        Set<IService<?>> lastServices = this.acceleoEnvironment.getServicesWithName(last, name);
        IService<?> result = this.lookup(lastServices, argumentTypes, VisibilityKind.PRIVATE);
        if (result == null) {
            String start = currentStack.getStartingModuleQualifiedName();
            result = this.lookupExtendedService(start, name, argumentTypes, VisibilityKind.PROTECTED, VisibilityKind.PUBLIC);
        }
        if (result == null) {
            result = this.lookupImportedService(last, name, argumentTypes);
        }
        if (result == null) {
            result = super.lookup(name, argumentTypes);
        }
        return result;
    }

    private IService<?> lookupExtendedService(String startQualifiedName, String name, IType[] argumentTypes, VisibilityKind ... candidateVisibilities) {
        String extendedModuleQualifiedName;
        Set<IService<?>> services = this.acceleoEnvironment.getServicesWithName(startQualifiedName, name);
        IService<?> result = this.lookup(services, argumentTypes, candidateVisibilities);
        if (result == null && (extendedModuleQualifiedName = this.acceleoEnvironment.getExtend(startQualifiedName)) != null) {
            result = this.lookupExtendedService(extendedModuleQualifiedName, name, argumentTypes, candidateVisibilities);
        }
        return result;
    }

    private IService<?> lookupImportedService(String start, String name, IType[] argumentTypes) {
        IService<?> result = null;
        Iterator<String> importedIterator = this.acceleoEnvironment.getImports(start).iterator();
        while (importedIterator.hasNext() && result == null) {
            String imported = importedIterator.next();
            result = this.lookupExtendedService(imported, name, argumentTypes, VisibilityKind.PUBLIC);
        }
        return result;
    }

    private IService<?> lookup(Set<IService<?>> services, IType[] argumentTypes, VisibilityKind ... candidateVisibilities) {
        Optional<IService> result = services.stream().filter(service -> service.getNumberOfParameters() == argumentTypes.length).filter(service -> this.isVisible((IService<?>)service, candidateVisibilities)).filter(service -> service.matches(this.queryEnvironment, argumentTypes)).findAny();
        return result.orElse(null);
    }

    private boolean isVisible(IService<?> service, VisibilityKind ... candidateVisibilities) {
        List<VisibilityKind> visibilityList = Arrays.asList(candidateVisibilities);
        boolean res = service instanceof AbstractModuleElementService ? visibilityList.contains((Object)((AbstractModuleElementService)service).getVisibility()) : true;
        return res;
    }

    public Set<IService<?>> getServices(Set<IType> receiverTypes) {
        LinkedHashSet result = new LinkedHashSet();
        AcceleoCallStack currentStack = this.acceleoEnvironment.getCurrentStack();
        String last = this.acceleoEnvironment.getModuleQualifiedName((Module)currentStack.peek().eContainer());
        if (last == null) {
            last = currentStack.getStartingModuleQualifiedName();
        }
        Set<IService<?>> lastServices = this.acceleoEnvironment.getServices(last, receiverTypes);
        result.addAll(this.getServices(lastServices, VisibilityKind.PRIVATE));
        String start = currentStack.getStartingModuleQualifiedName();
        result.addAll(this.getExtendedService(start, receiverTypes, VisibilityKind.PROTECTED, VisibilityKind.PUBLIC));
        result.addAll(this.getImportedService(last, receiverTypes));
        result.addAll(super.getServices(receiverTypes));
        return result;
    }

    private Set<IService<?>> getImportedService(String start, Set<IType> receiverTypes) {
        LinkedHashSet result = new LinkedHashSet();
        for (String imported : this.acceleoEnvironment.getImports(start)) {
            result.addAll(this.getExtendedService(imported, receiverTypes, VisibilityKind.PUBLIC));
        }
        return result;
    }

    private Set<IService<?>> getExtendedService(String startQualifiedName, Set<IType> receiverTypes, VisibilityKind ... candidateVisibilities) {
        Set<IService<?>> services = this.acceleoEnvironment.getServices(startQualifiedName, receiverTypes);
        Set<IService<?>> result = this.getServices(services, candidateVisibilities);
        String extendedModuleQualifiedName = this.acceleoEnvironment.getExtend(startQualifiedName);
        if (extendedModuleQualifiedName != null) {
            result.addAll(this.getExtendedService(extendedModuleQualifiedName, receiverTypes, candidateVisibilities));
        }
        return result;
    }

    private Set<IService<?>> getServices(Set<IService<?>> services, VisibilityKind ... candidateVisibilities) {
        return services.stream().filter(s -> this.isVisible((IService<?>)s, candidateVisibilities)).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

