/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class Positions {
    private final Map<EObject, Integer> startPositions = new HashMap<EObject, Integer>();
    private final Map<EObject, Integer> startLines = new HashMap<EObject, Integer>();
    private final Map<EObject, Integer> startColumns = new HashMap<EObject, Integer>();
    private final Map<EObject, Integer> endPositions = new HashMap<EObject, Integer>();
    private final Map<EObject, Integer> endLines = new HashMap<EObject, Integer>();
    private final Map<EObject, Integer> endColumns = new HashMap<EObject, Integer>();

    public Integer getStartPositions(EObject node) {
        return this.startPositions.get(node);
    }

    public Integer getStartLines(EObject node) {
        return this.startLines.get(node);
    }

    public Integer getStartColumns(EObject node) {
        return this.startColumns.get(node);
    }

    public Integer getEndPositions(EObject node) {
        return this.endPositions.get(node);
    }

    public Integer getEndLines(EObject node) {
        return this.endLines.get(node);
    }

    public Integer getEndColumns(EObject node) {
        return this.endColumns.get(node);
    }

    public void setStartPositions(EObject node, Integer position) {
        this.startPositions.put(node, position);
    }

    public void setStartLines(EObject node, Integer line) {
        this.startLines.put(node, line);
    }

    public void setStartColumns(EObject node, Integer column) {
        this.startColumns.put(node, column);
    }

    public void setEndPositions(EObject node, Integer position) {
        this.endPositions.put(node, position);
    }

    public void setEndLines(EObject node, Integer line) {
        this.endLines.put(node, line);
    }

    public void setEndColumns(EObject node, Integer column) {
        this.endColumns.put(node, column);
    }

    public void remove(EObject node) {
        this.startPositions.remove(node);
        this.startLines.remove(node);
        this.startColumns.remove(node);
        this.endPositions.remove(node);
        this.endLines.remove(node);
        this.endColumns.remove(node);
    }

    public void addAll(Positions others, int offsetPosition, int offsetLine, int offsetColumn) {
        for (Map.Entry<EObject, Integer> entry : others.startPositions.entrySet()) {
            this.startPositions.put(entry.getKey(), entry.getValue() + offsetPosition);
        }
        for (Map.Entry<EObject, Integer> entry : others.startLines.entrySet()) {
            this.startLines.put(entry.getKey(), entry.getValue() + offsetLine);
        }
        for (Map.Entry<EObject, Integer> entry : others.startColumns.entrySet()) {
            this.startColumns.put(entry.getKey(), entry.getValue() + offsetColumn);
        }
        for (Map.Entry<EObject, Integer> entry : others.endPositions.entrySet()) {
            this.endPositions.put(entry.getKey(), entry.getValue() + offsetPosition);
        }
        for (Map.Entry<EObject, Integer> entry : others.endLines.entrySet()) {
            this.endLines.put(entry.getKey(), entry.getValue() + offsetLine);
        }
        for (Map.Entry<EObject, Integer> entry : others.endColumns.entrySet()) {
            this.endColumns.put(entry.getKey(), entry.getValue() + offsetColumn);
        }
    }

    public boolean isInRange(EObject node, int position) {
        return this.isInRange(node, position, -1, -1);
    }

    public boolean isInRange(EObject node, int line, int column) {
        return this.isInRange(node, -1, line, column);
    }

    public EObject getNodeAt(EObject node, int position) {
        return this.getNodeAt(node, position, -1, -1);
    }

    public EObject getNodeAt(EObject node, int line, int column) {
        return this.getNodeAt(node, -1, line, column);
    }

    protected EObject getNodeAt(EObject node, int position, int line, int column) {
        EObject res = null;
        if (!this.isInRange(node, position, line, column)) {
            throw new IllegalArgumentException("the root node can't contain the given position.");
        }
        for (EObject child : node.eContents()) {
            if (this.getStartPositions(child) == null || this.getEndPositions(child) == null || !this.isInRange(child, position, line, column)) continue;
            res = this.getNodeAt(child, position, line, column);
            break;
        }
        if (res == null) {
            res = node;
        }
        return res;
    }

    protected boolean isInRange(EObject node, int position, int line, int column) {
        return this.compareStart(node, position, line, column) <= 0 && this.compareEnd(node, position, line, column) >= 0;
    }

    protected int compareStart(EObject node, int position, int line, int column) {
        int res;
        if (position != -1) {
            res = this.getStartPositions(node) - position;
        } else if (line != -1) {
            int lineDelta = this.getStartLines(node) - line;
            res = lineDelta == 0 ? (column != -1 ? this.getStartColumns(node) - column : lineDelta) : lineDelta;
        } else {
            throw new IllegalArgumentException("at least one of position or line must be different from -1.");
        }
        return res;
    }

    protected int compareEnd(EObject node, int position, int line, int column) {
        int res;
        if (position != -1) {
            res = this.getEndPositions(node) - position;
        } else if (line != -1) {
            int lineDelta = this.getEndLines(node) - line;
            res = lineDelta == 0 ? (column != -1 ? this.getEndColumns(node) - column : lineDelta) : lineDelta;
        } else {
            throw new IllegalArgumentException("at least one of position or line must be different from -1.");
        }
        return res;
    }
}

