/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.launcher;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.AcceleoEnvironment;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.GenerationResult;
import org.eclipse.acceleo.aql.evaluation.writer.DefaultGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.ide.resolver.OSGiQualifiedNameResolver;
import org.eclipse.acceleo.aql.launcher.AcceleoLauncherPlugin;
import org.eclipse.acceleo.aql.resolver.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;
import org.kohsuke.args4j.spi.StringOptionHandler;
import org.osgi.framework.Bundle;

public class AcceleoLauncher
implements IApplication {
    private static final Integer APPLICATION_ERROR = -1;
    @Option(name="-models", usage="Specifies the input models for this generation.", metaVar="INPUT", handler=StringArrayOptionHandler.class, required=true)
    private String[] models = new String[0];
    @Option(name="-bundle", usage="The identifier of the bundle containing the main module of the generation to start.", metaVar="BUNDLE", handler=StringOptionHandler.class, required=true)
    private String bundleIdentifier;
    @Option(name="-module", usage="Specifies the module which main template will be executed.", metaVar="MODULE", handler=StringOptionHandler.class, required=true)
    private String moduleQualifiedName;
    @Option(name="-target", usage="Specifies the destination for the generation.", metaVar="TARGET", handler=StringOptionHandler.class, required=true)
    private String target;
    @Option(name="-data", usage="Specify the folder which will keep the workspace.", metaVar="FOLDER")
    private File dataFolder;
    @Option(name="-consoleLog", usage="Log messages in the console.")
    private boolean consoleLog;
    private List<URI> modelURIs;
    private Bundle bundle;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        return new AcceleoLauncher().doMain(args);
    }

    public Object doMain(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        Integer applicationResult = IApplication.EXIT_OK;
        try {
            parser.parseArgument(args);
            this.validateArguments(parser);
            GenerationResult result = this.launchGeneration();
            if (result.getDiagnostic().getSeverity() > 1) {
                PrintStream stream;
                switch (result.getDiagnostic().getSeverity()) {
                    case 2: {
                        stream = System.out;
                        stream.println("WARNING");
                        break;
                    }
                    default: {
                        stream = System.err;
                        stream.println("ERROR");
                        applicationResult = APPLICATION_ERROR;
                    }
                }
                this.printDiagnostic(stream, result.getDiagnostic(), "");
            }
            Set generatedFiles = result.getGeneratedFiles();
            System.out.println("Generated " + generatedFiles.size() + " in " + this.target);
            if (result.getGeneratedFiles().size() <= 10) {
                for (URI generated : result.getGeneratedFiles()) {
                    System.out.println(generated);
                }
            }
        }
        catch (CmdLineException e) {
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            AcceleoLauncherPlugin.INSTANCE.log((Object)e);
            applicationResult = APPLICATION_ERROR;
        }
        return applicationResult;
    }

    private void validateArguments(CmdLineParser parser) throws CmdLineException {
        if (this.models.length == 0 || this.models[0].length() == 0) {
            throw new CmdLineException(parser, "The input model path cannot be empty.");
        }
        if (this.bundleIdentifier.length() == 0) {
            throw new CmdLineException(parser, "The main module's containing bundle identifier cannot be empty.");
        }
        if (this.moduleQualifiedName.length() == 0) {
            throw new CmdLineException(parser, "The main module's qualified name cannot be empty.");
        }
        if (this.target.length() == 0) {
            throw new CmdLineException(parser, "The target folder path cannot be empty.");
        }
        this.modelURIs = this.convertToURIs(parser, this.models);
        this.bundle = Platform.getBundle((String)this.bundleIdentifier);
        if (this.bundle == null || this.bundle.getState() == 1) {
            throw new CmdLineException(parser, "The Bundle " + this.bundleIdentifier + " must be available in the target platform.");
        }
        try {
            URI.createURI((String)this.target);
        }
        catch (IllegalArgumentException e) {
            throw new CmdLineException(parser, (Throwable)e);
        }
    }

    private List<URI> convertToURIs(CmdLineParser parser, String ... paths) throws CmdLineException {
        ArrayList<URI> uris = new ArrayList<URI>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            URI pathURI = null;
            try {
                pathURI = URI.createURI((String)path, (boolean)true);
            }
            catch (IllegalArgumentException e) {
                throw new CmdLineException(parser, (Throwable)e);
            }
            if (pathURI != null && !pathURI.hasAbsolutePath()) {
                pathURI = URI.createFileURI((String)path);
            }
            if (pathURI != null) {
                uris.add(pathURI);
            }
            ++n2;
        }
        return uris;
    }

    private GenerationResult launchGeneration() {
        ResourceSetImpl modelResourceSet = new ResourceSetImpl();
        for (URI modelURI : this.modelURIs) {
            modelResourceSet.getResource(modelURI, true);
        }
        AcceleoEnvironment environment = new AcceleoEnvironment((IAcceleoGenerationStrategy)new DefaultGenerationStrategy(), URI.createURI((String)this.target));
        OSGiQualifiedNameResolver resolver = new OSGiQualifiedNameResolver(this.bundle, (IReadOnlyQueryEnvironment)environment.getQueryEnvironment());
        environment.setModuleResolver((IQualifiedNameResolver)resolver);
        Module mainModule = environment.getModule(this.moduleQualifiedName);
        this.evaluate((IAcceleoEnvironment)environment, mainModule, (ResourceSet)modelResourceSet);
        return environment.getGenerationResult();
    }

    private void evaluate(IAcceleoEnvironment environment, Module mainModule, ResourceSet modelResourceSet) {
        AcceleoEvaluator evaluator = new AcceleoEvaluator(environment);
        AcceleoUtil.generate((AcceleoEvaluator)evaluator, (IAcceleoEnvironment)environment, (Module)mainModule, (ResourceSet)modelResourceSet);
    }

    private void printDiagnostic(PrintStream stream, Diagnostic diagnostic, String indentation) {
        String nextIndentation = indentation;
        if (diagnostic.getMessage() != null) {
            stream.print(indentation);
            stream.println(diagnostic.getMessage());
            nextIndentation = String.valueOf(nextIndentation) + "\t";
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            this.printDiagnostic(stream, child, nextIndentation);
        }
    }

    public void stop() {
    }
}

