/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.AbstractCollectionType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClassifier;

public class FilterService
extends JavaMethodService {
    final int filterIndex;

    public FilterService(Method serviceMethod, Object serviceInstance) {
        this(serviceMethod, serviceInstance, 1);
    }

    public FilterService(Method serviceMethod, Object serviceInstance, int filterIndex) {
        super(serviceMethod, serviceInstance);
        this.filterIndex = filterIndex;
    }

    @Override
    public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
            EClassifier eClassEClass = queryEnvironment.getEPackageProvider().getType("ecore", "EClass");
            if (entry.getKey().size() > this.filterIndex) {
                LinkedHashSet filterTypes = Sets.newLinkedHashSet();
                if (entry.getKey().get(this.filterIndex) instanceof EClassifierSetLiteralType) {
                    for (EClassifier eClassifier : ((EClassifierSetLiteralType)entry.getKey().get(this.filterIndex)).getEClassifiers()) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eClassifier));
                    }
                } else if (entry.getKey().get(this.filterIndex) instanceof EClassifierLiteralType) {
                    filterTypes.add(entry.getKey().get(this.filterIndex));
                } else if (entry.getKey().get(this.filterIndex).getType() == eClassEClass || entry.getKey().get(this.filterIndex) instanceof SetType && ((AbstractCollectionType)entry.getKey().get(this.filterIndex)).getCollectionType().getType() == eClassEClass) {
                    EClassifier eObjectEClass = queryEnvironment.getEPackageProvider().getType("ecore", "EObject");
                    if (eObjectEClass != null) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eObjectEClass));
                    }
                } else {
                    filterTypes.add(entry.getKey().get(this.filterIndex));
                }
                for (IType filterType : filterTypes) {
                    for (IType possibleType : entry.getValue()) {
                        IType rawType = possibleType instanceof ICollectionType ? ((ICollectionType)possibleType).getCollectionType() : possibleType;
                        if (rawType instanceof NothingType) {
                            builder.append("\n");
                            builder.append(((NothingType)rawType).getMessage());
                            continue;
                        }
                        IType loweredType = services.lower(filterType, rawType);
                        if (loweredType == null) continue;
                        result.add(this.unrawType(queryEnvironment, possibleType, loweredType));
                    }
                }
                continue;
            }
            for (IType possibleType : entry.getValue()) {
                if (possibleType instanceof NothingType) {
                    builder.append("\n");
                    builder.append(((NothingType)possibleType).getMessage());
                    continue;
                }
                result.add(possibleType);
            }
        }
        if (result.isEmpty()) {
            NothingType nothing = services.nothing("Nothing will be left after calling %s:" + builder.toString(), this.getName());
            if (List.class.isAssignableFrom(this.getMethod().getReturnType())) {
                result.add(new SequenceType(queryEnvironment, nothing));
            } else if (Set.class.isAssignableFrom(this.getMethod().getReturnType())) {
                result.add(new SetType(queryEnvironment, nothing));
            } else {
                result.add(nothing);
            }
        }
        return result;
    }

    private IType unrawType(IReadOnlyQueryEnvironment queryEnvironment, IType originalType, IType rawType) {
        IType result = originalType instanceof SequenceType ? new SequenceType(queryEnvironment, rawType) : (originalType instanceof SetType ? new SetType(queryEnvironment, rawType) : rawType);
        return result;
    }
}

