/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.structuredtextcore.ui.editor.STCoreNestedEditor;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.EditorDocumentUndoChange;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.ProviderDocumentChange;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class EditorDocumentChange
extends ProviderDocumentChange {
    private final IEditorPart editorPart;

    public EditorDocumentChange(String name, IEditorPart editorPart, IDocumentProvider documentProvider) {
        super(name, editorPart.getEditorInput(), documentProvider);
        this.editorPart = editorPart;
    }

    public EditorDocumentChange(String name, IEditorPart editorPart, IDocumentProvider documentProvider, boolean doSave) {
        super(name, editorPart.getEditorInput(), documentProvider, doSave);
        this.editorPart = editorPart;
    }

    @Override
    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
        try {
            IEditorPart iEditorPart;
            IEditorPart iEditorPart2 = this.editorPart;
            if (iEditorPart2 instanceof STCoreNestedEditor) {
                STCoreNestedEditor nestedEditor = (STCoreNestedEditor)iEditorPart2;
                nestedEditor.setBlockUpdates(true);
            }
            super.commit(document, pm);
            if (this.isDoSave() && (iEditorPart = this.editorPart) instanceof STCoreNestedEditor) {
                STCoreNestedEditor nestedEditor = (STCoreNestedEditor)iEditorPart;
                nestedEditor.doSaveOuterEditor(pm);
            }
        }
        finally {
            IEditorPart iEditorPart = this.editorPart;
            if (iEditorPart instanceof STCoreNestedEditor) {
                STCoreNestedEditor nestedEditor = (STCoreNestedEditor)iEditorPart;
                nestedEditor.setBlockUpdates(false);
            }
        }
    }

    @Override
    protected Change createUndoChange(UndoEdit edit) {
        return new EditorDocumentUndoChange(this.getName(), this.editorPart, this.getDocumentProvider(), edit, this.isDoSave());
    }
}

