/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.FordiacKeywords;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Comment;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;

public final class NameRepository {
    private NameRepository() {
    }

    public static String createUniqueTypeName(LibraryElement type) {
        TypeLibrary typeLibrary = type.getTypeLibrary();
        String typeName = type.getName();
        if (type instanceof DataType) {
            DataTypeLibrary dataTypeLibrary = typeLibrary.getDataTypeLibrary();
            while (dataTypeLibrary.getTypeIfExists(typeName) != null) {
                typeName = NameRepository.createUniqueName(type.getName(), typeName);
            }
            return typeName;
        }
        if (type instanceof FBType) {
            while (typeLibrary.getFBTypeEntry(typeName) != null) {
                typeName = NameRepository.createUniqueName(type.getName(), typeName);
            }
            return typeName;
        }
        if (type instanceof SubAppType) {
            while (typeLibrary.getSubAppTypeEntry(typeName) != null) {
                typeName = NameRepository.createUniqueName(type.getName(), typeName);
            }
            return typeName;
        }
        if (type instanceof AdapterType) {
            while (typeLibrary.getAdapterTypeEntry(typeName) != null) {
                typeName = NameRepository.createUniqueName(type.getName(), typeName);
            }
            return typeName;
        }
        return null;
    }

    public static String createUniqueName(INamedElement element, String nameProposal) {
        if (element instanceof Comment) {
            return "";
        }
        String retVal = nameProposal;
        if (IdentifierVerifier.verifyIdentifier(nameProposal).isPresent() && nameProposal.contains(".")) {
            retVal = nameProposal.replace(".", "_");
        }
        Assert.isTrue((boolean)IdentifierVerifier.verifyIdentifier(retVal).isEmpty(), (String)"The given name proposal is not a valid identifier!");
        Assert.isNotNull((Object)element.eContainer(), (String)"For a correct operation createuniqueName expects that the model element is already added in its containing model!");
        if (element instanceof IInterfaceElement) {
            retVal = NameRepository.checkReservedKeyWords(retVal);
        }
        return NameRepository.getUniqueName(NameRepository.getRefNames(element), retVal);
    }

    public static boolean isValidName(INamedElement element, String nameProposal) {
        Assert.isNotNull((Object)element.eContainer(), (String)"For a correct operation createuniqueName expects that the model element is already added in its containing model!");
        if (element instanceof Comment) {
            return true;
        }
        Optional<String> verifyIdentifier = IdentifierVerifier.verifyIdentifier(nameProposal);
        if (verifyIdentifier.isPresent()) {
            ErrorMessenger.popUpErrorMessage((String)verifyIdentifier.get());
            return false;
        }
        if (NameRepository.getRefNames(element).parallelStream().anyMatch(name -> name.equalsIgnoreCase(nameProposal))) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.NameRepository_NameAlreadyExists, nameProposal));
            return false;
        }
        return true;
    }

    private static Set<String> getRefNames(INamedElement refElement) {
        EObject eObject;
        Object elementsList = null;
        if (refElement instanceof Algorithm) {
            Algorithm alg = (Algorithm)refElement;
            elementsList = ((BasicFBType)alg.eContainer()).getAlgorithm();
        } else if (refElement instanceof Application) {
            Application app = (Application)refElement;
            elementsList = app.getAutomationSystem().getApplication();
        } else if (refElement instanceof Device) {
            Device dev = (Device)refElement;
            elementsList = dev.getSystemConfiguration().getDevices();
        } else if (refElement instanceof FBNetworkElement) {
            FBNetworkElement fbe = (FBNetworkElement)refElement;
            elementsList = refElement.eContainer() instanceof BaseFBType ? ((BaseFBType)refElement.eContainer()).getInternalFbs() : fbe.getFbNetwork().getNetworkElements();
        } else if (refElement instanceof Resource) {
            Resource res = (Resource)refElement;
            elementsList = res.getDevice().getResource();
        } else if (refElement instanceof Segment) {
            Segment seg = (Segment)refElement;
            elementsList = ((SystemConfiguration)seg.eContainer()).getSegments();
        } else if (refElement instanceof ECState) {
            elementsList = ((ECC)refElement.eContainer()).getECState();
        } else if (refElement instanceof IInterfaceElement) {
            IInterfaceElement ie = (IInterfaceElement)refElement;
            EObject eObject2 = ie.eContainer();
            if (eObject2 instanceof StructuredType) {
                StructuredType structType = (StructuredType)eObject2;
                elementsList = structType.getMemberVariables();
            } else {
                InterfaceList il;
                BasicEList elements = new BasicEList();
                InterfaceList interfaceList = null;
                EObject eObject3 = ie.eContainer();
                interfaceList = eObject3 instanceof InterfaceList ? (il = (InterfaceList)eObject3) : ((BaseFBType)refElement.eContainer()).getInterfaceList();
                elements.addAll(interfaceList.getAllInterfaceElements());
                EObject eObject4 = interfaceList.eContainer();
                if (eObject4 instanceof BaseFBType) {
                    BaseFBType baseFBType = (BaseFBType)eObject4;
                    elements.addAll(baseFBType.getInternalVars());
                    elements.addAll(baseFBType.getInternalConstVars());
                }
                elementsList = elements;
            }
        } else if (refElement instanceof ServiceSequence) {
            ServiceSequence seq = (ServiceSequence)refElement;
            elementsList = seq.getService().getServiceSequence();
        } else if (refElement instanceof Attribute && (eObject = refElement.eContainer()) instanceof ConfigurableObject) {
            ConfigurableObject configurableObject = (ConfigurableObject)eObject;
            elementsList = configurableObject.getAttributes();
        } else {
            throw new IllegalArgumentException("Reference list for given class not available: " + refElement.getClass().toString());
        }
        return elementsList.stream().filter(element -> element != refElement).map(INamedElement::getName).filter(Objects::nonNull).filter(Predicate.not(String::isBlank)).collect(Collectors.toSet());
    }

    private static String getUniqueName(Set<String> existingNameList, String nameProposal) {
        String temp = nameProposal;
        while (existingNameList.contains(temp)) {
            temp = NameRepository.createUniqueName(nameProposal, temp);
        }
        return temp;
    }

    public static String createUniqueName(String nameProposal, String temp) {
        String digits = NameRepository.extractDigitsFromEnd(temp);
        if (!"".equals(digits)) {
            try {
                long newNumber = (long)Integer.parseInt(digits) + 1L;
                if (newNumber > Integer.MAX_VALUE) {
                    return NameRepository.createFallbackProposal(nameProposal);
                }
                return temp.substring(0, temp.length() - digits.length()) + NameRepository.zeroPrefixedNumber(newNumber, digits.length());
            }
            catch (NumberFormatException e) {
                return NameRepository.createFallbackProposal(nameProposal);
            }
        }
        return NameRepository.createFallbackProposal(nameProposal);
    }

    private static String zeroPrefixedNumber(long number, int digits) {
        String zeroPrefixedDecimal = "%0" + digits + "d";
        return String.format(zeroPrefixedDecimal, number);
    }

    private static String createFallbackProposal(String nameProposal) {
        return nameProposal + "_1";
    }

    private static String extractDigitsFromEnd(String data) {
        int MAX_LENGTH_INTEGER = 10;
        StringBuilder sb = new StringBuilder();
        int c = 0;
        int i = data.length() - 1;
        while (i > 0 && c <= 10) {
            if (data.charAt(i) < '0' || data.charAt(i) > '9') break;
            sb.insert(0, data.charAt(i));
            --i;
            ++c;
        }
        if (c > 10) {
            return "";
        }
        return sb.toString();
    }

    private static String checkReservedKeyWords(String name) {
        if (FordiacKeywords.isReservedKeyword(name)) {
            return name + "1";
        }
        return name;
    }
}

