/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.change.AbstractUpdateBlockFBNElementCommand;
import org.eclipse.fordiac.ide.model.helpers.BlockInstanceFactory;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class UpdateFBTypeCommand
extends AbstractUpdateBlockFBNElementCommand {
    public UpdateFBTypeCommand(BlockFBNetworkElement fbnElement, TypeEntry entry) {
        super(fbnElement);
        this.entry = entry instanceof FBTypeEntry || entry instanceof SubAppTypeEntry ? entry : fbnElement.getTypeEntry();
    }

    public UpdateFBTypeCommand(BlockFBNetworkElement fbnElement) {
        this(fbnElement, null);
    }

    public boolean canExecute() {
        if (this.entry == null || this.oldElement == null || this.network == null) {
            return false;
        }
        return FBNetworkHelper.isTypeInsertionSafe((FBType)((FBType)this.entry.getType()), (EObject)this.network);
    }

    protected void setEntry(TypeEntry entry) {
        this.entry = entry;
    }

    protected TypeEntry getEntry() {
        return this.entry;
    }

    @Override
    protected BlockFBNetworkElement createCopiedFBEntry(BlockFBNetworkElement srcElement) {
        this.entry = UpdateFBTypeCommand.reloadTypeEntry(this.entry, (FBNetworkElement)srcElement);
        BlockFBNetworkElement copy = BlockInstanceFactory.createBlockInstanceForTypeEntry((TypeEntry)this.entry);
        if (srcElement instanceof AdapterFB) {
            AdapterFB adp = (AdapterFB)srcElement;
            ((AdapterFB)copy).setAdapterDecl(adp.getAdapterDecl());
        }
        copy.setTypeEntry(this.entry);
        return copy;
    }

    private static TypeEntry reloadTypeEntry(TypeEntry entry, FBNetworkElement context) {
        if (entry == null || UpdateFBTypeCommand.isValidTypeEntry(entry)) {
            return entry;
        }
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext((EObject)context);
        if (typeLibrary == null) {
            FordiacLogHelper.logWarning((String)"Cannot get type library for current FB network element");
            return entry;
        }
        TypeEntry reloadedTypeEntry = typeLibrary.find(entry.getFullTypeName());
        if (UpdateFBTypeCommand.isValidTypeEntry(reloadedTypeEntry)) {
            return reloadedTypeEntry;
        }
        if (entry instanceof SubAppTypeEntry) {
            return typeLibrary.createErrorTypeEntry(entry.getFullTypeName(), LibraryElementPackage.eINSTANCE.getSubAppType());
        }
        if (entry instanceof FBTypeEntry) {
            return typeLibrary.createErrorTypeEntry(entry.getFullTypeName(), LibraryElementPackage.eINSTANCE.getFBType());
        }
        FordiacLogHelper.logWarning((String)("Unsupported error type entry for " + entry.getClass().getName()));
        return entry;
    }

    private static boolean isValidTypeEntry(TypeEntry entry) {
        return entry != null && entry.getFile() != null && entry.getFile().exists() && entry.getTypeLibrary() != null && entry.getTypeLibrary().getTypeEntry(entry.getFile()) == entry;
    }
}

