/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.ui.properties;

import java.util.Optional;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.fordiac.ide.export.ui.Messages;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class TypeExportPropertyPage
extends PropertyPage {
    private OutputDirectoryFieldEditor directoryEditor;
    private BooleanFieldEditor checkboxEditor;
    private ComboFieldEditor exporterEditor;
    private Group settingsContainer;
    private Composite directoryEditorContainer;
    private Composite exporterEditorContainer;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        this.createEnableCheckbox(composite);
        this.settingsContainer = new Group(composite, 0);
        this.settingsContainer.setText(Messages.TypeExport_Settings);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo((Composite)this.settingsContainer);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.settingsContainer);
        this.createDirectoryEditor((Composite)this.settingsContainer);
        this.createDefaultExporterEditor((Composite)this.settingsContainer);
        this.refreshEditors();
        return composite;
    }

    private void createDefaultExporterEditor(Composite parent) {
        this.exporterEditorContainer = new Composite(parent, 0);
        this.exporterEditor = new ComboFieldEditor("EXPORT_FILTER_ID", Messages.TypeExport_Exporter, TypeExportPropertyPage.getExportFilterNames(), this.exporterEditorContainer);
        this.exporterEditor.setPreferenceStore(this.getPreferenceStore());
    }

    private void createEnableCheckbox(Composite parent) {
        Composite checkboxEditorContainer = new Composite(parent, 0);
        this.checkboxEditor = new BooleanFieldEditor("ENABLE_TYPE_EXPORT", Messages.TypeExport_Enable, checkboxEditorContainer);
        this.checkboxEditor.setPreferenceStore(this.getPreferenceStore());
        Control control = this.checkboxEditor.getDescriptionControl(checkboxEditorContainer);
        if (control instanceof Button) {
            Button button = (Button)control;
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TypeExportPropertyPage.this.enableSettings(TypeExportPropertyPage.this.checkboxEditor.getBooleanValue());
                    super.widgetSelected(e);
                }
            });
        }
    }

    protected void performDefaults() {
        this.directoryEditor.loadDefault();
        this.checkboxEditor.loadDefault();
        this.exporterEditor.loadDefault();
        this.enableSettings(false);
        super.performDefaults();
    }

    private void createDirectoryEditor(Composite parent) {
        this.directoryEditorContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.directoryEditorContainer);
        this.directoryEditor = new OutputDirectoryFieldEditor("OUTPUT_FOLDER", Messages.TypeExport_OutputFolder, this.directoryEditorContainer);
        this.directoryEditor.setPreferenceStore(this.getPreferenceStore());
        this.directoryEditor.setPage((DialogPage)this);
        this.directoryEditor.setEmptyStringAllowed(false);
        this.directoryEditor.getTextControl(this.directoryEditorContainer).addModifyListener(e -> this.directoryEditor.getTextControl(this.directoryEditorContainer).requestLayout());
    }

    private String getOutputFolder() {
        if (this.getProject().getFolder("out").exists()) {
            return this.getProject().getFolder("out").getProjectRelativePath().toPortableString();
        }
        return "";
    }

    protected IPreferenceStore doGetPreferenceStore() {
        ProjectScope projectScope = new ProjectScope(this.getProject());
        ScopedPreferenceStore prefStore = new ScopedPreferenceStore((IScopeContext)projectScope, "org.eclipse.fordiac.ide.export");
        prefStore.setDefault("OUTPUT_FOLDER", this.getOutputFolder());
        return prefStore;
    }

    public boolean performOk() {
        this.checkboxEditor.store();
        if (this.checkboxEditor.getBooleanValue()) {
            this.exporterEditor.store();
            if (!this.directoryEditor.isValid()) {
                this.directoryEditor.showErrorMessage();
                return false;
            }
            this.directoryEditor.store();
        }
        return super.performOk();
    }

    protected IProject getProject() {
        return (IProject)Adapters.adapt((Object)this.getElement(), IProject.class);
    }

    /*
     * Exception decompiling
     */
    private static String[][] getExportFilterNames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void refreshEditors() {
        this.checkboxEditor.load();
        this.directoryEditor.load();
        this.exporterEditor.load();
        this.enableSettings(this.checkboxEditor.getBooleanValue());
    }

    private void enableSettings(boolean enable) {
        this.settingsContainer.setEnabled(enable);
        this.directoryEditor.setEnabled(enable, this.directoryEditorContainer);
        this.exporterEditor.setEnabled(enable, this.exporterEditorContainer);
    }

    private static /* synthetic */ String[][] lambda$2(int size) {
        return new String[size][2];
    }

    class OutputDirectoryFieldEditor
    extends StringButtonFieldEditor {
        public OutputDirectoryFieldEditor(String name, String labelText, Composite parent) {
            this.init(name, labelText);
            this.setErrorMessage(JFaceResources.getString((String)"DirectoryFieldEditor.errorMessage"));
            this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
            this.setValidateStrategy(1);
            this.createControl(parent);
        }

        protected String changePressed() {
            Optional<IFolder> selectedDirectory = this.chooseOutputFolder();
            if (selectedDirectory.isPresent() && selectedDirectory.get().exists()) {
                return selectedDirectory.get().getProjectRelativePath().toString();
            }
            return null;
        }

        protected boolean doCheckState() {
            String fileName = this.getTextControl().getText();
            if ((fileName = fileName.trim()).isEmpty() && this.isEmptyStringAllowed()) {
                return true;
            }
            return TypeExportPropertyPage.this.getProject().getFolder(fileName).exists();
        }

        private Optional<IFolder> chooseOutputFolder() {
            Object object;
            IFolder selectedElement;
            ElementTreeSelectionDialog fileDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            fileDialog.setInput((Object)TypeExportPropertyPage.this.getProject());
            fileDialog.setAllowMultiple(false);
            fileDialog.setTitle(Messages.TypeExport_OutputFolder);
            fileDialog.setMessage(Messages.TypeExport_FileDialogMessage);
            if (!this.getTextControl().getText().isEmpty() && (selectedElement = TypeExportPropertyPage.this.getProject().getFolder((IPath)new Path(this.getTextControl().getText()))).exists()) {
                fileDialog.setInitialSelection((Object)selectedElement);
            }
            fileDialog.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    IFolder folder;
                    return element instanceof IFolder && !(folder = (IFolder)element).isVirtual() && !folder.isLinked() && !folder.getName().startsWith(".");
                }
            });
            if (fileDialog.open() == 0 && fileDialog.getResult().length == 1 && (object = fileDialog.getFirstResult()) instanceof IFolder) {
                IFolder folder = (IFolder)object;
                return Optional.of(folder);
            }
            return Optional.empty();
        }
    }
}

