/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.cmake;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.export.forte_ng.ForteNgExportTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.cmake.CMakeListsUtil;
import org.eclipse.fordiac.ide.library.LibraryManager;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.library.Required;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public abstract class CMakeListsTemplate
extends ForteNgExportTemplate {
    protected static final Set<String> SOURCE_EXTENSIONS = Set.of(".c", ".cpp", ".h");
    protected static final List<String> IMPLICIT_DEPENDENCIES = List.of("core");
    protected static final String FILE_SET_HEADERS = "HEADERS";
    protected static final int INDENT = 8;
    protected static final String FORTE = "forte";
    protected static final String FORTE_VERSION = "3.0";
    protected static final String CMAKE_MINIMUM_VERSION = "3.30";
    private final IProject project;
    private final Path output;
    private final Manifest manifest;

    protected CMakeListsTemplate(IProject project, Path output, Path prefix) {
        super("CMakeLists.txt", prefix);
        this.project = project;
        this.output = output;
        this.manifest = ManifestHelper.getContainerManifest((IContainer)this.getProject());
    }

    protected static CharSequence generateCMakeMimumumRequired() {
        return "cmake_minimum_required(VERSION 3.30)" + System.lineSeparator();
    }

    protected CharSequence generateModuleNamePlain() {
        return this.getProjectName();
    }

    protected CharSequence generateTargetName() {
        return CMakeListsTemplate.generateTargetName(this.generateModuleNamePlain());
    }

    protected static CharSequence generateTargetName(CharSequence name) {
        return "forte-" + String.valueOf(name);
    }

    protected CharSequence generateExportName() {
        return CMakeListsTemplate.generateExportName(this.generateTargetName());
    }

    protected static CharSequence generateExportName(CharSequence name) {
        return String.valueOf(name) + "-export";
    }

    protected CharSequence generateVersionRange(String manifestVersionRange) {
        try {
            return CMakeListsTemplate.generateVersionRange(VersionRange.valueOf((String)manifestVersionRange.replace('-', ',')));
        }
        catch (IllegalArgumentException e) {
            this.getErrors().add(e.getLocalizedMessage());
            return manifestVersionRange;
        }
    }

    protected static CharSequence generateVersionRange(VersionRange range) {
        StringBuilder result = new StringBuilder(64);
        result.append(CMakeListsTemplate.generateVersion(range.getLeft()));
        if (range.getRight() == null) {
            return result;
        }
        result.append("...");
        if (range.getRightType() == ')') {
            result.append('<');
        }
        result.append(CMakeListsTemplate.generateVersion(range.getRight()));
        return result;
    }

    protected static CharSequence generateVersion(Version version) {
        StringBuilder result = new StringBuilder(32);
        result.append(version.getMajor());
        result.append('.');
        result.append(version.getMinor());
        result.append('.');
        result.append(version.getMicro());
        return result;
    }

    protected static CharSequence generateHeader() {
        return "# " + HEADER_TEXT + System.lineSeparator() + System.lineSeparator();
    }

    protected static CharSequence generateProject(CharSequence name, CharSequence comment, CharSequence version) {
        return "project(" + String.valueOf(name) + System.lineSeparator() + ((String)(comment != null ? "DESCRIPTION \"" + String.valueOf(comment) + "\"" + System.lineSeparator() : "") + (String)(version != null ? "VERSION \"" + String.valueOf(version) + "\"" + System.lineSeparator() : "") + "LANGUAGES C CXX" + System.lineSeparator()).indent(8) + ")" + System.lineSeparator();
    }

    protected static CharSequence generateFindPackage(CharSequence name, CharSequence version, boolean required) {
        return "if (NOT TARGET " + String.valueOf(name) + ")" + System.lineSeparator() + ("find_package(" + String.valueOf(name) + " " + String.valueOf(version) + (required ? " REQUIRED" : "") + ")" + System.lineSeparator()).indent(8) + "endif ()" + System.lineSeparator();
    }

    protected static CharSequence generateAddSubdirectories(List<? extends CharSequence> subdirs) {
        return subdirs.stream().map(CMakeListsTemplate::generateAddSubdirectory).collect(Collectors.joining());
    }

    protected static CharSequence generateAddSubdirectory(CharSequence subdir) {
        return "add_subdirectory(" + String.valueOf(subdir) + ")" + System.lineSeparator();
    }

    protected static CharSequence generateAddLibrary(CharSequence name) {
        return "add_library(" + String.valueOf(name) + ")" + System.lineSeparator();
    }

    protected static CharSequence generateTargetSources(CharSequence name, Access access, CharSequence fileSet, CharSequence baseDirs, List<? extends CharSequence> sources) {
        if (sources.isEmpty() && baseDirs == null) {
            return "";
        }
        return "target_sources(" + String.valueOf(name) + " " + access.name() + System.lineSeparator() + ((String)(fileSet != null ? "FILE_SET " + String.valueOf(fileSet) + System.lineSeparator() : "") + (String)(baseDirs != null ? "BASE_DIRS " + String.valueOf(baseDirs) + System.lineSeparator() : "") + (String)(fileSet != null && !sources.isEmpty() ? "FILES" + System.lineSeparator() : "") + sources.stream().map(source -> String.valueOf(source) + System.lineSeparator()).collect(Collectors.joining())).indent(8) + ")" + System.lineSeparator();
    }

    protected static CharSequence generateTargetLinkLibraries(CharSequence name, Access access, List<? extends CharSequence> libs) {
        if (libs.isEmpty()) {
            return "";
        }
        return "target_link_libraries(" + String.valueOf(name) + " " + access.name() + " " + libs.stream().map(CMakeListsTemplate::generateTargetName).collect(Collectors.joining(" ")) + ")" + System.lineSeparator();
    }

    protected static CharSequence generateTargetLinkLibrariesWholeArchive(CharSequence name, Access access, List<? extends CharSequence> libs) {
        String libNames = libs.stream().map(CMakeListsTemplate::generateTargetName).collect(Collectors.joining(","));
        return "get_target_property(" + String.valueOf(name) + "_IMPORTED " + String.valueOf(name) + " IMPORTED)" + System.lineSeparator() + "if (NOT " + String.valueOf(name) + "_IMPORTED)" + System.lineSeparator() + ("target_link_libraries(" + String.valueOf(name) + " " + access.name() + " $<IF:$<BOOL:${BUILD_SHARED_LIBS}>," + libNames + ",$<LINK_LIBRARY:WHOLE_ARCHIVE," + libNames + ">>)" + System.lineSeparator()).indent(8) + "endif ()" + System.lineSeparator();
    }

    protected static CharSequence generateInstallPreamble(CharSequence name) {
        return "include(GNUInstallDirs)" + System.lineSeparator() + "include(CMakePackageConfigHelpers)" + System.lineSeparator() + System.lineSeparator() + "set(ConfigPackageLocation lib/cmake/" + name.toString().toLowerCase() + "-${PROJECT_VERSION})" + System.lineSeparator();
    }

    protected static CharSequence generateConfigurePackageConfigFile(CharSequence name) {
        return "configure_package_config_file(" + System.lineSeparator() + (name.toString().toLowerCase() + "-config.cmake.in" + System.lineSeparator() + "${CMAKE_CURRENT_BINARY_DIR}/" + name.toString().toLowerCase() + "-config.cmake" + System.lineSeparator() + "INSTALL_DESTINATION ${ConfigPackageLocation}" + System.lineSeparator()).indent(8) + ")" + System.lineSeparator();
    }

    protected static CharSequence generateWriteBasicPackageVersionFile(CharSequence name) {
        return "write_basic_package_version_file(" + System.lineSeparator() + ("${CMAKE_CURRENT_BINARY_DIR}/" + name.toString().toLowerCase() + "-config-version.cmake" + System.lineSeparator() + "COMPATIBILITY SameMajorVersion" + System.lineSeparator()).indent(8) + ")" + System.lineSeparator();
    }

    protected static CharSequence generateInstallTargets(CharSequence name, CharSequence exportName) {
        return "install(TARGETS " + String.valueOf(name) + " EXPORT " + String.valueOf(exportName) + " FILE_SET HEADERS)" + System.lineSeparator();
    }

    protected static CharSequence generateInstallFiles(CharSequence name) {
        return "install(FILES" + System.lineSeparator() + ("${CMAKE_CURRENT_BINARY_DIR}/" + name.toString().toLowerCase() + "-config.cmake" + System.lineSeparator() + "${CMAKE_CURRENT_BINARY_DIR}/" + name.toString().toLowerCase() + "-config-version.cmake" + System.lineSeparator() + "DESTINATION ${ConfigPackageLocation}" + System.lineSeparator()).indent(8) + ")" + System.lineSeparator();
    }

    protected static CharSequence generateInstallExport(CharSequence exportName) {
        return "install(EXPORT " + String.valueOf(exportName) + System.lineSeparator() + ("DESTINATION ${ConfigPackageLocation}" + System.lineSeparator() + "EXPORT_LINK_INTERFACE_LIBRARIES" + System.lineSeparator()).indent(8) + ")" + System.lineSeparator();
    }

    protected String getProjectName() {
        if (this.manifest == null || this.manifest.getProduct() == null || this.manifest.getProduct().getSymbolicName() == null) {
            return this.project.getName();
        }
        return this.manifest.getProduct().getSymbolicName();
    }

    protected String getProjectComment() {
        if (this.manifest == null || this.manifest.getProduct() == null) {
            return null;
        }
        return this.manifest.getProduct().getComment();
    }

    protected String getProjectVersion() {
        if (this.manifest == null || this.manifest.getProduct() == null || this.manifest.getProduct().getVersionInfo() == null) {
            return null;
        }
        return this.manifest.getProduct().getVersionInfo().getVersion();
    }

    protected List<String> getDependencies() {
        if (this.manifest == null || this.manifest.getDependencies() == null) {
            return IMPLICIT_DEPENDENCIES;
        }
        return Stream.concat(IMPLICIT_DEPENDENCIES.stream(), this.manifest.getDependencies().getRequired().stream().map(Required::getSymbolicName).sorted()).distinct().toList();
    }

    protected List<Required> getExternalDependencies() {
        if (this.manifest == null || this.manifest.getDependencies() == null) {
            return List.of();
        }
        return this.manifest.getDependencies().getRequired().stream().filter(Predicate.not(CMakeListsTemplate::isStandardLibrary)).sorted(Comparator.comparing(Required::getSymbolicName)).toList();
    }

    protected static boolean isStandardLibrary(Required required) {
        return LibraryManager.INSTANCE.getStandardLibraries().containsKey(required.getSymbolicName());
    }

    protected List<String> getSubdirectories() {
        Path currentSourceDir = this.getCurrentSourceDir();
        if (!Files.exists(currentSourceDir, new LinkOption[0])) {
            return List.of();
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> list = Files.list(currentSourceDir);){
                return list.filter(path -> Files.isDirectory(path, new LinkOption[0])).map(Path::getFileName).map(Path::toString).toList();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.errors.add(e.getMessage());
            return List.of();
        }
    }

    protected List<String> getSourceFiles() {
        Path currentSourceDir = this.getCurrentSourceDir();
        if (!Files.exists(currentSourceDir, new LinkOption[0])) {
            return List.of();
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> list = Files.list(currentSourceDir);){
                return list.filter(CMakeListsUtil::isSourceFile).map(Path::getFileName).map(Path::toString).toList();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.errors.add(e.getMessage());
            return List.of();
        }
    }

    protected Path getCurrentSourceDir() {
        return this.output.resolve(this.getPath().subpath(0, this.getPath().getNameCount() - 1));
    }

    protected IProject getProject() {
        return this.project;
    }

    protected Path getOutput() {
        return this.output;
    }

    public static enum Access {
        PUBLIC,
        PRIVATE,
        INTERFACE;

    }
}

