/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.contractSpec.Age;
import org.eclipse.fordiac.ide.contractSpec.CausalAge;
import org.eclipse.fordiac.ide.contractSpec.CausalFuncDecl;
import org.eclipse.fordiac.ide.contractSpec.CausalFuncName;
import org.eclipse.fordiac.ide.contractSpec.CausalReaction;
import org.eclipse.fordiac.ide.contractSpec.CausalRelation;
import org.eclipse.fordiac.ide.contractSpec.ClockDefinition;
import org.eclipse.fordiac.ide.contractSpec.Reaction;
import org.eclipse.fordiac.ide.contractSpec.Repetition;
import org.eclipse.fordiac.ide.contractSpec.SingleEvent;
import org.eclipse.fordiac.ide.contractSpec.TimeSpec;
import org.eclipse.fordiac.ide.contractSpec.impl.ModelImpl;
import org.eclipse.fordiac.ide.contracts.CConnection;
import org.eclipse.fordiac.ide.contracts.Clock;
import org.eclipse.fordiac.ide.contracts.ContractComponent;
import org.eclipse.fordiac.ide.contracts.ContractIssue;
import org.eclipse.fordiac.ide.contracts.ContractRule;
import org.eclipse.fordiac.ide.contracts.ContractRuleBuilder;
import org.eclipse.fordiac.ide.contracts.DynamicCheckResult;
import org.eclipse.fordiac.ide.contracts.DynamicContractChecker;
import org.eclipse.fordiac.ide.contracts.EventOccurrence;
import org.eclipse.fordiac.ide.contracts.Messages;
import org.eclipse.fordiac.ide.contracts.StaticContractChecker;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.ui.utils.ContractspecResourceProvider;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class ContractSystem {
    private final List<ContractComponent> components = new ArrayList<ContractComponent>();
    private final List<Clock> clocks = new ArrayList<Clock>();
    private final List<ContractIssue> issues = new ArrayList<ContractIssue>();
    private final Map<SubApp, ContractComponent> processedSubApps = new HashMap<SubApp, ContractComponent>();

    public void gatherContracts(Set<SubApp> subapps) {
        for (SubApp subapp : subapps) {
            this.gatherContracts(subapp);
        }
    }

    private void gatherContracts(SubApp subapp) {
        if (this.processedSubApps.containsKey(subapp)) {
            return;
        }
        ContractComponent comp = this.createContractComponent(subapp);
        this.components.add(comp);
        this.processedSubApps.put(subapp, comp);
        InterfaceList inter = subapp.getInterface();
        for (Event e : inter.getEventOutputs()) {
            this.checkOutputConnections(e, comp, false);
            this.checkInputConnections(e, comp, true);
        }
        for (Event e : inter.getEventInputs()) {
            this.checkInputConnections(e, comp, false);
            this.checkOutputConnections(e, comp, true);
        }
        for (FBNetworkElement element : subapp.getSubAppNetwork().getNetworkElements()) {
            SubApp sapp;
            if (!(element instanceof SubApp) || (sapp = (SubApp)element).getAttribute("_SUBAPP_CONTRACT") == null) continue;
            this.gatherContracts(sapp);
        }
    }

    private void checkOutputConnections(Event e, ContractComponent comp, boolean inPort) {
        for (Connection c : e.getOutputConnections()) {
            ContractComponent neighbour;
            BlockFBNetworkElement blockFBNetworkElement = c.getDestinationElement();
            if (blockFBNetworkElement instanceof SubApp) {
                SubApp sapp = (SubApp)blockFBNetworkElement;
                v0 = this.processedSubApps.get(sapp);
            } else {
                v0 = neighbour = null;
            }
            if (neighbour == comp || neighbour == null) continue;
            CConnection.Type type = !inPort && !c.getDestination().isIsInput() ? CConnection.Type.FROM_INNER : (inPort && c.getDestination().isIsInput() ? CConnection.Type.FROM_OUTER : CConnection.Type.NORMAL);
            neighbour.addInput(comp, e.getName(), c.getDestination().getName(), type);
        }
    }

    private void checkInputConnections(Event e, ContractComponent comp, boolean outPort) {
        for (Connection c : e.getInputConnections()) {
            ContractComponent neighbour;
            BlockFBNetworkElement blockFBNetworkElement = c.getSourceElement();
            if (blockFBNetworkElement instanceof SubApp) {
                SubApp sapp = (SubApp)blockFBNetworkElement;
                v0 = this.processedSubApps.get(sapp);
            } else {
                v0 = neighbour = null;
            }
            if (neighbour == null) continue;
            CConnection.Type type = outPort && !c.getSource().isIsInput() ? CConnection.Type.FROM_INNER : (!outPort && c.getSource().isIsInput() ? CConnection.Type.FROM_OUTER : CConnection.Type.NORMAL);
            comp.addInput(neighbour, c.getSource().getName(), e.getName(), type);
        }
    }

    private ContractComponent createContractComponent(SubApp subapp) {
        ContractComponent comp = new ContractComponent(subapp.getQualifiedName());
        ContractspecResourceProvider provider = new ContractspecResourceProvider((BlockFBNetworkElement)subapp);
        XtextResource res = provider.createResource();
        String contract = subapp.getAttributeValue("_SUBAPP_CONTRACT");
        this.addContractRules(contract, res, comp);
        return comp;
    }

    public void addComponent(ContractComponent comp, String contract, List<String> iPrts, List<String> oPrts) {
        ContractspecResourceProvider provider = new ContractspecResourceProvider(iPrts, oPrts);
        XtextResource res = provider.createResource();
        this.addContractRules(contract, res, comp);
        this.components.add(comp);
    }

    /*
     * WARNING - void declaration
     */
    private void addContractRules(String contract, XtextResource resource, ContractComponent component) {
        void model;
        if (contract == null) {
            return;
        }
        try {
            resource.load((InputStream)new ByteArrayInputStream(contract.getBytes(StandardCharsets.UTF_8)), null);
        }
        catch (IOException e) {
            this.error(Messages.ContractModelLoadError.formatted(component.getName()), ContractIssue.Code.MODEL_LOADING);
            return;
        }
        IResourceValidator validator = resource.getResourceServiceProvider().getResourceValidator();
        List issues = validator.validate((Resource)resource, CheckMode.ALL, CancelIndicator.NullImpl);
        if (!issues.isEmpty()) {
            for (Issue i : issues) {
                String msg = component.getName() + ": " + i.getMessage();
                this.issue(msg, ContractIssue.Code.SYNTAX_OR_SEMANTIC, i.getSeverity());
            }
            return;
        }
        if (resource.getContents().isEmpty()) {
            return;
        }
        EObject eObject = (EObject)resource.getContents().get(0);
        if (!(eObject instanceof ModelImpl)) {
            this.error(Messages.ContractModelLoadError.formatted(component.getName()), ContractIssue.Code.MODEL_LOADING);
            return;
        }
        ModelImpl i = (ModelImpl)eObject;
        this.addContractRules((List<TimeSpec>)model.getTimeSpec(), component);
    }

    private void addContractRules(List<TimeSpec> timeSpecs, ContractComponent component) {
        ArrayList<CausalFuncDecl> causalFuncDecls = new ArrayList<CausalFuncDecl>();
        ContractRuleBuilder ruleBuilder = new ContractRuleBuilder(this, component);
        for (TimeSpec timespec : timeSpecs) {
            TimeSpec timeSpec;
            Objects.requireNonNull(timespec);
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleEvent.class, Repetition.class, Reaction.class, Age.class, CausalReaction.class, CausalAge.class, CausalFuncDecl.class, ClockDefinition.class}, (Object)timeSpec, 0)) {
                case 0: {
                    SingleEvent se = (SingleEvent)timeSpec;
                    ruleBuilder.addSingleEvent(se);
                    break;
                }
                case 1: {
                    Repetition re = (Repetition)timeSpec;
                    ruleBuilder.addRepetition(re);
                    break;
                }
                case 2: {
                    Reaction re = (Reaction)timeSpec;
                    ruleBuilder.addReaction(re);
                    break;
                }
                case 3: {
                    Age age = (Age)timeSpec;
                    ruleBuilder.addAge(age);
                    break;
                }
                case 4: {
                    CausalReaction cRe = (CausalReaction)timeSpec;
                    ruleBuilder.addCausalReaction(cRe);
                    break;
                }
                case 5: {
                    CausalAge cAge = (CausalAge)timeSpec;
                    ruleBuilder.addCausalAge(cAge);
                    break;
                }
                case 6: {
                    CausalFuncDecl funcDecl = (CausalFuncDecl)timeSpec;
                    causalFuncDecls.add(funcDecl);
                    break;
                }
                case 7: {
                    ClockDefinition clock = (ClockDefinition)timeSpec;
                    this.clocks.add(new Clock(clock));
                    break;
                }
                default: {
                    this.warning(Messages.ContractUnkownRuleWarning.formatted(component.getName()), ContractIssue.Code.UNKOWN_RULE);
                }
            }
        }
        for (ContractRule reaction : component.getReactions()) {
            ContractSystem.associateCausalFuncDecl(reaction, causalFuncDecls);
        }
    }

    private static void associateCausalFuncDecl(ContractRule reaction, List<CausalFuncDecl> funcDecls) {
        if (reaction.getType() == ContractRule.Type.CAUSAL_AGE) {
            for (CausalFuncDecl funcDecl : funcDecls) {
                if (funcDecl.getFuncName() != CausalFuncName.AGE || !funcDecl.getPort1().getName().equals(reaction.getOutputs().getFirst()) || !funcDecl.getPort2().getName().equals(reaction.getInputs().getFirst())) continue;
                reaction.setCausalRelation(funcDecl.getRelation());
                return;
            }
        } else if (reaction.getType() == ContractRule.Type.CAUSAL_REACTION) {
            for (CausalFuncDecl funcDecl : funcDecls) {
                if (funcDecl.getFuncName() != CausalFuncName.REACTION || !funcDecl.getPort1().getName().equals(reaction.getInputs().getFirst()) || !funcDecl.getPort2().getName().equals(reaction.getOutputs().getFirst())) continue;
                reaction.setCausalRelation(funcDecl.getRelation());
                return;
            }
        }
        reaction.setCausalRelation(CausalRelation.FIFO);
    }

    public void performStaticCheck() {
        StaticContractChecker checker = new StaticContractChecker(this, this.components);
        checker.checkSystem();
    }

    public DynamicCheckResult performDynamicCheck(List<EventOccurrence> eventOccurences) {
        DynamicContractChecker checker = new DynamicContractChecker(this, this.components, eventOccurences);
        return checker.checkSystem();
    }

    public List<ContractIssue> getIssues() {
        return this.issues;
    }

    public int getNComponents() {
        return this.components.size();
    }

    public void error(String message, ContractIssue.Code code) {
        this.issue(message, code, Severity.ERROR);
    }

    public void warning(String message, ContractIssue.Code code) {
        this.issue(message, code, Severity.WARNING);
    }

    public void info(String message, ContractIssue.Code code) {
        this.issue(message, code, Severity.INFO);
    }

    public void issue(String message, ContractIssue.Code code, Severity severity) {
        this.addIssue(new ContractIssue(message, code, severity));
    }

    public void addIssue(ContractIssue issue) {
        this.issues.add(issue);
    }
}

